/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mtr.BlockEntityTypes;
import mtr.Blocks;
import mtr.block.IBlock;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.Text;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockRailwaySign
extends BlockDirectionalMapper
implements EntityBlockMapper,
IBlock {
    public final int length;
    public final boolean isOdd;
    public static final float SMALL_SIGN_PERCENTAGE = 0.75f;

    public BlockRailwaySign(int length, boolean isOdd) {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60999_().m_60978_(2.0f).m_60953_(state -> 15));
        this.length = length;
        this.isOdd = isOdd;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult hit) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            BlockPos checkPos;
            Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
            Direction hitSide = hit.m_82434_();
            if ((hitSide == facing || hitSide == facing.m_122424_()) && (checkPos = this.findEndWithDirection(world, pos, hitSide.m_122424_(), false)) != null) {
                PacketTrainDataGuiServer.openRailwaySignScreenS2C((ServerPlayer)player, checkPos);
            }
        });
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        boolean isNext;
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        boolean bl = isNext = direction == facing.m_122427_() || state.m_60713_(Blocks.RAILWAY_SIGN_MIDDLE.get()) && direction == facing.m_122428_();
        if (isNext && !(newState.m_60734_() instanceof BlockRailwaySign)) {
            return net.minecraft.world.level.block.Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_8125_();
        return IBlock.isReplaceable(ctx, facing.m_122427_(), this.getMiddleLength() + 2) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)facing) : null;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        BlockPos checkPos = this.findEndWithDirection(world, pos, facing, true);
        if (checkPos != null) {
            IBlock.onBreakCreative(world, player, checkPos);
        }
        super.m_5707_(world, pos, state, player);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.f_46443_) {
            Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
            for (int i = 1; i <= this.getMiddleLength(); ++i) {
                world.m_7731_(pos.m_5484_(facing.m_122427_(), i), (BlockState)Blocks.RAILWAY_SIGN_MIDDLE.get().m_49966_().m_61124_((Property)f_54117_, (Comparable)facing), 3);
            }
            world.m_7731_(pos.m_5484_(facing.m_122427_(), this.getMiddleLength() + 1), (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)facing.m_122424_()), 3);
            world.m_46672_(pos, net.minecraft.world.level.block.Blocks.f_50016_);
            state.m_60701_((LevelAccessor)world, pos, 3);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        if (state.m_60713_(Blocks.RAILWAY_SIGN_MIDDLE.get())) {
            return IBlock.getVoxelShapeByDirection(0.0, 0.0, 7.0, 16.0, 12.0, 9.0, facing);
        }
        int xStart = this.getXStart();
        VoxelShape main = IBlock.getVoxelShapeByDirection((double)xStart - 0.75, 0.0, 7.0, 16.0, 12.0, 9.0, facing);
        VoxelShape pole = IBlock.getVoxelShapeByDirection(xStart - 2, 0.0, 7.0, (double)xStart - 0.75, 16.0, 9.0, facing);
        return Shapes.m_83110_((VoxelShape)main, (VoxelShape)pole);
    }

    public String m_7705_() {
        return "block.mtr.railway_sign";
    }

    public void m_5871_(ItemStack itemStack, BlockGetter blockGetter, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Text.translatable("tooltip.mtr.railway_sign_length", this.length).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
        tooltip.add((Component)Text.translatable(this.isOdd ? "tooltip.mtr.railway_sign_odd" : "tooltip.mtr.railway_sign_even", new Object[0]).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
    }

    @Override
    public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
        if (this == Blocks.RAILWAY_SIGN_MIDDLE.get()) {
            return null;
        }
        return new TileEntityRailwaySign(this.length, this.isOdd, pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public int getXStart() {
        switch (this.length % 4) {
            default: {
                return this.isOdd ? 8 : 16;
            }
            case 1: {
                return this.isOdd ? 4 : 12;
            }
            case 2: {
                return this.isOdd ? 16 : 8;
            }
            case 3: 
        }
        return this.isOdd ? 12 : 4;
    }

    private int getMiddleLength() {
        return (this.length - (4 - this.getXStart() / 4)) / 2;
    }

    private BlockPos findEndWithDirection(Level world, BlockPos startPos, Direction direction, boolean allowOpposite) {
        int i = 0;
        while (true) {
            BlockPos checkPos;
            BlockState checkState;
            if ((checkState = world.m_8055_(checkPos = startPos.m_5484_(direction.m_122428_(), i))).m_60734_() instanceof BlockRailwaySign) {
                Direction facing = (Direction)IBlock.getStatePropertySafe(checkState, f_54117_);
                if (!checkState.m_60713_(Blocks.RAILWAY_SIGN_MIDDLE.get()) && (facing == direction || allowOpposite && facing == direction.m_122424_())) {
                    return checkPos;
                }
            } else {
                return null;
            }
            ++i;
        }
    }

    public static class TileEntityRailwaySign
    extends BlockEntityClientSerializableMapper {
        private final Set<Long> selectedIds;
        private final String[] signIds;
        private static final String KEY_SELECTED_IDS = "selected_ids";
        private static final String KEY_SIGN_LENGTH = "sign_length";

        public TileEntityRailwaySign(int length, boolean isOdd, BlockPos pos, BlockState state) {
            super(TileEntityRailwaySign.getType(length, isOdd), pos, state);
            this.signIds = new String[length];
            this.selectedIds = new HashSet<Long>();
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            this.selectedIds.clear();
            Arrays.stream(compoundTag.m_128467_(KEY_SELECTED_IDS)).forEach(this.selectedIds::add);
            for (int i = 0; i < this.signIds.length; ++i) {
                String signId = compoundTag.m_128461_(KEY_SIGN_LENGTH + i);
                this.signIds[i] = signId.isEmpty() ? null : signId;
            }
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.m_128428_(KEY_SELECTED_IDS, new ArrayList<Long>(this.selectedIds));
            for (int i = 0; i < this.signIds.length; ++i) {
                compoundTag.m_128359_(KEY_SIGN_LENGTH + i, this.signIds[i] == null ? "" : this.signIds[i]);
            }
        }

        public AABB getRenderBoundingBox() {
            return new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }

        public void setData(Set<Long> selectedIds, String[] signTypes) {
            this.selectedIds.clear();
            this.selectedIds.addAll(selectedIds);
            if (this.signIds.length == signTypes.length) {
                System.arraycopy(signTypes, 0, this.signIds, 0, signTypes.length);
            }
            this.m_6596_();
            this.syncData();
        }

        public Set<Long> getSelectedIds() {
            return this.selectedIds;
        }

        public String[] getSignIds() {
            return this.signIds;
        }

        private static BlockEntityType<?> getType(int length, boolean isOdd) {
            switch (length) {
                case 2: {
                    return isOdd ? BlockEntityTypes.RAILWAY_SIGN_2_ODD_TILE_ENTITY.get() : BlockEntityTypes.RAILWAY_SIGN_2_EVEN_TILE_ENTITY.get();
                }
                case 3: {
                    return isOdd ? BlockEntityTypes.RAILWAY_SIGN_3_ODD_TILE_ENTITY.get() : BlockEntityTypes.RAILWAY_SIGN_3_EVEN_TILE_ENTITY.get();
                }
                case 4: {
                    return isOdd ? BlockEntityTypes.RAILWAY_SIGN_4_ODD_TILE_ENTITY.get() : BlockEntityTypes.RAILWAY_SIGN_4_EVEN_TILE_ENTITY.get();
                }
                case 5: {
                    return isOdd ? BlockEntityTypes.RAILWAY_SIGN_5_ODD_TILE_ENTITY.get() : BlockEntityTypes.RAILWAY_SIGN_5_EVEN_TILE_ENTITY.get();
                }
                case 6: {
                    return isOdd ? BlockEntityTypes.RAILWAY_SIGN_6_ODD_TILE_ENTITY.get() : BlockEntityTypes.RAILWAY_SIGN_6_EVEN_TILE_ENTITY.get();
                }
                case 7: {
                    return isOdd ? BlockEntityTypes.RAILWAY_SIGN_7_ODD_TILE_ENTITY.get() : BlockEntityTypes.RAILWAY_SIGN_7_EVEN_TILE_ENTITY.get();
                }
            }
            return null;
        }
    }

    public static enum SignType {
        ARROW_LEFT("arrow", true, false),
        ARROW_RIGHT("arrow", true, true),
        ARROW_UP("arrow_up", true, false),
        ARROW_DOWN("arrow_down", true, false),
        ARROW_UP_LEFT("arrow_up_left", true, false),
        ARROW_UP_RIGHT("arrow_up_left", true, true),
        ARROW_DOWN_LEFT("arrow_down_left", true, false),
        ARROW_DOWN_RIGHT("arrow_down_left", true, true),
        ARROW_TURN_BACK_LEFT("arrow_turn_back", true, false),
        ARROW_TURN_BACK_RIGHT("arrow_turn_back", true, true),
        EXIT_1("exit_1", false, false),
        EXIT_2("exit_2", true, false),
        EXIT_3("exit_3", true, false),
        ESCALATOR("escalator", true, false),
        ESCALATOR_FLIPPED("escalator", true, true),
        STAIRS_UP("stairs_up", true, false),
        STAIRS_UP_FLIPPED("stairs_up", true, true),
        STAIRS_DOWN_FLIPPED("stairs_down", true, true),
        STAIRS_DOWN("stairs_down", true, false),
        LIFT_1("lift_1", true, false),
        LIFT_2("lift_2", true, false),
        WHEELCHAIR("wheelchair", true, false),
        TOILET("toilets", false, false),
        FEMALE("female", true, false),
        MALE("male", true, false),
        TRAIN("train", true, false),
        TRAIN_OLD("train_old", true, false),
        AIRPORT_EXPRESS("airport_express", true, false),
        LIGHT_RAIL_1("light_rail_1", true, false),
        LIGHT_RAIL_2("light_rail_2", false, false),
        LIGHT_RAIL_3("light_rail_3", true, false),
        LIGHT_RAIL_4("light_rail_4", false, false),
        XRL_1("xrl_1", true, false),
        XRL_2("xrl_2", true, false),
        SP1900("sp1900", true, false),
        YELLOW_HEAD_1("yellow_head_1", true, false),
        YELLOW_HEAD_2("yellow_head_2", false, false),
        BOAT("boat", true, false),
        CABLE_CAR("cable_car", true, false),
        AIRPLANE("airplane", true, false),
        AIRPLANE_LEFT("airplane_left", true, false),
        AIRPLANE_RIGHT("airplane_left", true, true),
        AIRPLANE_UP_LEFT("airplane_up_left", true, false),
        AIRPLANE_UP_RIGHT("airplane_up_left", true, true),
        CROSS("cross", true, false),
        LOGO("logo", false, false),
        EXIT_LETTER("exit_letter", true, false, true),
        EXIT_LETTER_FLIPPED("exit_letter", true, true, true),
        ESCALATOR_TO_CONCOURSE_UP("escalator", "escalator_to_concourse_up", true, true, false, true, 0),
        ESCALATOR_TO_CONCOURSE_UP_FLIPPED("escalator", "escalator_to_concourse_up", true, false, true, true, 0),
        ESCALATOR_TO_CONCOURSE_DOWN("escalator", "escalator_to_concourse_down", true, false, false, true, 0),
        ESCALATOR_TO_CONCOURSE_DOWN_FLIPPED("escalator", "escalator_to_concourse_down", true, true, true, true, 0),
        PLATFORM("platform", true, false, true),
        PLATFORM_FLIPPED("platform", true, true, true),
        LINE("line", true, false, true),
        LINE_FLIPPED("line", true, true, true),
        STATION("station", false, false, true),
        STATION_FLIPPED("station", false, true, true),
        LIFT_1_TEXT("lift_1", true, false, true),
        LIFT_1_TEXT_FLIPPED("lift_1", true, true, true),
        LIFT_2_TEXT("lift_2", true, false, true),
        LIFT_2_TEXT_FLIPPED("lift_2", true, true, true),
        TOILETS("toilets", false, false, true),
        TOILETS_FLIPPED("toilets", false, true, true),
        FEMALE_TOILETS("female", true, false, true),
        FEMALE_TOILETS_FLIPPED("female", true, true, true),
        MALE_TOILETS("male", true, false, true),
        MALE_TOILETS_FLIPPED("male", true, true, true),
        WHEELCHAIR_TOILETS("wheelchair", true, false, true),
        WHEELCHAIR_TOILETS_FLIPPED("wheelchair", true, true, true),
        TRAINS("train", true, false, true),
        TRAINS_FLIPPED("train", true, true, true),
        TRAINS_OLD("train_old", true, false, true),
        TRAINS_OLD_FLIPPED("train_old", true, true, true),
        AIRPORT_EXPRESS_TRAINS("airport_express", true, false, true),
        AIRPORT_EXPRESS_TRAINS_FLIPPED("airport_express", true, true, true),
        AIRPORT_EXPRESS_TRAINS_CITY("airport_express", "airport_express_city", true, false, true),
        AIRPORT_EXPRESS_TRAINS_CITY_FLIPPED("airport_express", "airport_express_city", true, true, true),
        IN_TOWN_CHECK_IN("check_in", "in_town_check_in", true, false, true),
        IN_TOWN_CHECK_IN_FLIPPED("check_in", "in_town_check_in", true, true, true),
        CHECK_IN_PASSENGERS("check_in", "check_in_passengers", true, false, true),
        CHECK_IN_PASSENGERS_FLIPPED("check_in", "check_in_passengers", true, true, true),
        LIGHT_RAIL_1_TRAINS("light_rail_1", true, false, true),
        LIGHT_RAIL_1_TRAINS_FLIPPED("light_rail_1", true, true, true),
        LIGHT_RAIL_2_TRAINS("light_rail_2", false, false, true),
        LIGHT_RAIL_2_TRAINS_FLIPPED("light_rail_2", false, true, true),
        LIGHT_RAIL_3_TRAINS("light_rail_3", true, false, true),
        LIGHT_RAIL_3_TRAINS_FLIPPED("light_rail_3", true, true, true),
        LIGHT_RAIL_4_TRAINS("light_rail_4", false, false, true),
        LIGHT_RAIL_4_TRAINS_FLIPPED("light_rail_4", false, true, true),
        XRL_1_TRAINS("xrl_1", true, false, true),
        XRL_1_TRAINS_FLIPPED("xrl_1", true, true, true),
        XRL_2_TRAINS("xrl_2", true, false, true),
        XRL_2_TRAINS_FLIPPED("xrl_2", true, true, true),
        SP1900_TRAINS("sp1900", true, false, true),
        SP1900_TRAINS_FLIPPED("sp1900", true, true, true),
        YELLOW_HEAD_1_TRAINS("yellow_head_1", true, false, true),
        YELLOW_HEAD_1_TRAINS_FLIPPED("yellow_head_1", true, true, true),
        YELLOW_HEAD_2_TRAINS("yellow_head_2", false, false, true),
        YELLOW_HEAD_2_TRAINS_FLIPPED("yellow_head_2", false, true, true),
        BOAT_BOATS("boat", true, false, true),
        BOAT_BOATS_FLIPPED("boat", true, true, true),
        CABLE_CAR_CABLE_CARS("cable_car", true, false, true),
        CABLE_CAR_CABLE_CARS_FLIPPED("cable_car", true, true, true),
        AIRPORT("airplane", "airport", true, false, false, true, 0),
        AIRPORT_FLIPPED("airplane", "airport", true, false, true, true, 0),
        AIRPORT_LEFT("airplane_left", "airport", true, false, false, true, 0),
        AIRPORT_RIGHT("airplane_left", "airport", true, true, true, true, 0),
        AIRPORT_UP_LEFT("airplane_up_left", "airport", true, false, false, true, 0),
        AIRPORT_UP_RIGHT("airplane_up_left", "airport", true, true, true, true, 0),
        AIRPORT_ARRIVALS("airplane_down_left", "airport_arrivals", true, true, false, true, 0),
        AIRPORT_ARRIVALS_FLIPPED("airplane_down_left", "airport_arrivals", true, false, true, true, 0),
        AIRPORT_DEPARTURES("airplane_up_left", "airport_departures", true, false, false, true, 0),
        AIRPORT_DEPARTURES_FLIPPED("airplane_up_left", "airport_departures", true, true, true, true, 0),
        AIRPORT_TRANSFER("airport_transfer", true, false, true),
        AIRPORT_TRANSFER_FLIPPED("airport_transfer", true, true, true),
        BAGGAGE_CLAIM("baggage_claim", true, false, true),
        BAGGAGE_CLAIM_FLIPPED("baggage_claim", true, true, true),
        CUSTOMER_SERVICE_CENTRE("customer_service_centre", true, false, true),
        CUSTOMER_SERVICE_CENTRE_FLIPPED("customer_service_centre", true, true, true),
        TICKETS("tickets", true, false, true),
        TICKETS_FLIPPED("tickets", true, true, true),
        NO_ENTRY("cross", true, false, true),
        NO_ENTRY_FLIPPED("cross", true, true, true),
        EMERGENCY_EXIT("emergency_exit", "emergency_exit", false, false, false, true, 37967),
        EMERGENCY_EXIT_FLIPPED("emergency_exit", "emergency_exit", false, true, true, true, 37967),
        WIFI("wifi", "wifi", true, false, false, true, 16415522),
        WIFI_FLIPPED("wifi", "wifi", true, true, true, true, 16415522),
        LOGO_TEXT("logo", false, false, true),
        LOGO_TEXT_FLIPPED("logo", false, true, true);

        public final ResourceLocation textureId;
        public final String customText;
        public final boolean small;
        public final boolean flipTexture;
        public final boolean flipCustomText;
        public final int backgroundColor;

        private SignType(String texture, String translation, boolean small, boolean flipTexture, boolean flipCustomText, boolean hasCustomText, int backgroundColor) {
            this.textureId = new ResourceLocation("mtr:textures/block/sign/" + texture + ".png");
            this.customText = hasCustomText ? Text.translatable("sign.mtr." + translation + "_cjk", new Object[0]).m_130946_("|").m_7220_((Component)Text.translatable("sign.mtr." + translation, new Object[0])).getString() : "";
            this.small = small;
            this.flipTexture = flipTexture;
            this.flipCustomText = flipCustomText;
            this.backgroundColor = backgroundColor;
        }

        private SignType(String texture, String translation, boolean small, boolean flipTexture, boolean hasCustomText) {
            this(texture, translation, small, false, flipTexture, hasCustomText, 0);
        }

        private SignType(String texture, boolean small, boolean flipCustomText, boolean hasCustomText) {
            this(texture, texture, small, false, flipCustomText, hasCustomText, 0);
        }

        private SignType(String texture, boolean small, boolean flipTexture) {
            this(texture, texture, small, flipTexture, false, false, 0);
        }
    }
}

