/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.block.BlockAPGDoor;
import mtr.block.BlockAPGGlass;
import mtr.block.BlockAPGGlassEnd;
import mtr.block.BlockPSDAPGDoorBase;
import mtr.block.BlockPSDDoor;
import mtr.block.BlockPSDGlass;
import mtr.block.BlockPSDGlassEnd;
import mtr.block.IBlock;
import mtr.mappings.BlockDirectionalMapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockPlatform
extends BlockDirectionalMapper {
    private final boolean isIndented;
    public static final EnumProperty<EnumDoorType> DOOR_TYPE = EnumProperty.m_61587_((String)"door_type", EnumDoorType.class);
    public static final IntegerProperty SIDE = IntegerProperty.m_61631_((String)"side", (int)0, (int)4);

    public BlockPlatform(BlockBehaviour.Properties settings, boolean isIndented) {
        super(settings);
        this.isIndented = isIndented;
        this.m_49959_((BlockState)this.m_49966_().m_61124_(DOOR_TYPE, (Comparable)((Object)EnumDoorType.NONE)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        return this.getActualState((BlockGetter)world, pos, state);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (this.isIndented) {
            Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
            return Shapes.m_83110_((VoxelShape)IBlock.getVoxelShapeByDirection(0.0, 0.0, 6.0, 16.0, 13.0, 16.0, facing), (VoxelShape)Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        }
        return super.m_5940_(state, world, pos, context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, DOOR_TYPE, SIDE});
    }

    private BlockState getActualState(BlockGetter world, BlockPos pos, BlockState state) {
        int side;
        EnumDoorType doorType;
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        BlockState stateAbove = world.m_8055_(pos.m_7494_());
        Block blockAbove = stateAbove.m_60734_();
        if (blockAbove instanceof BlockPSDDoor || blockAbove instanceof BlockPSDGlass || blockAbove instanceof BlockPSDGlassEnd) {
            doorType = EnumDoorType.PSD;
            facing = (Direction)IBlock.getStatePropertySafe(stateAbove, f_54117_);
        } else if (blockAbove instanceof BlockAPGDoor || blockAbove instanceof BlockAPGGlass || blockAbove instanceof BlockAPGGlassEnd) {
            doorType = EnumDoorType.APG;
            facing = (Direction)IBlock.getStatePropertySafe(stateAbove, f_54117_);
        } else {
            doorType = EnumDoorType.NONE;
        }
        boolean aboveIsDoor = blockAbove instanceof BlockPSDAPGDoorBase;
        BlockState stateLeftAbove = world.m_8055_(pos.m_7494_().m_121945_(facing.m_122428_()));
        boolean leftAboveIsDoor = stateLeftAbove.m_60734_() instanceof BlockPSDAPGDoorBase;
        BlockState stateRightAbove = world.m_8055_(pos.m_7494_().m_121945_(facing.m_122427_()));
        boolean rightAboveIsDoor = stateRightAbove.m_60734_() instanceof BlockPSDAPGDoorBase;
        if (aboveIsDoor && rightAboveIsDoor) {
            side = 2;
        } else if (aboveIsDoor && leftAboveIsDoor) {
            side = 3;
        } else if (rightAboveIsDoor) {
            side = 1;
            facing = (Direction)IBlock.getStatePropertySafe(stateRightAbove, f_54117_);
        } else if (leftAboveIsDoor) {
            side = 4;
            facing = (Direction)IBlock.getStatePropertySafe(stateLeftAbove, f_54117_);
        } else {
            side = 0;
        }
        return (BlockState)((BlockState)((BlockState)state.m_61124_((Property)f_54117_, (Comparable)facing)).m_61124_(DOOR_TYPE, (Comparable)((Object)doorType))).m_61124_((Property)SIDE, (Comparable)Integer.valueOf(side));
    }

    private static enum EnumDoorType implements StringRepresentable
    {
        NONE("none"),
        PSD("psd"),
        APG("apg");

        private final String name;

        private EnumDoorType(String nameIn) {
            this.name = nameIn;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

