/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.List;
import mtr.Items;
import mtr.MTR;
import mtr.block.BlockLiftTrackFloor;
import mtr.block.IBlock;
import mtr.block.ITripleBlock;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.Text;
import mtr.mappings.TickableMapper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BlockLiftPanelBase
extends BlockDirectionalMapper
implements EntityBlockMapper,
ITripleBlock {
    private final boolean isOdd;
    private final boolean isFlat;
    @Deprecated
    public static final BooleanProperty LEFT = BooleanProperty.m_61465_((String)"left");
    @Deprecated
    public static final BooleanProperty TEMP = BooleanProperty.m_61465_((String)"temp");

    public BlockLiftPanelBase(boolean isOdd, boolean isFlat) {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60999_().m_60978_(2.0f).m_60953_(state -> 5));
        this.isOdd = isOdd;
        this.isFlat = isFlat;
    }

    public StateDefinition<Block, BlockState> m_49965_() {
        return super.m_49965_();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        if (this.isOdd) {
            return ITripleBlock.updateShape(state, direction, newState.m_60713_((Block)this), () -> super.m_7417_(state, direction, newState, world, pos, posFrom));
        }
        if (IBlock.getSideDirection(state) == direction && !newState.m_60713_((Block)this)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction = ctx.m_8125_();
        if (this.isOdd) {
            return IBlock.isReplaceable(ctx, direction.m_122427_(), 3) ? (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_((Property)SIDE, (Comparable)((Object)IBlock.EnumSide.LEFT))).m_61124_((Property)ODD, (Comparable)Boolean.valueOf(false)) : null;
        }
        if (this.isFlat) {
            return IBlock.isReplaceable(ctx, direction.m_122427_(), 2) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_((Property)SIDE, (Comparable)((Object)IBlock.EnumSide.LEFT)) : null;
        }
        return IBlock.isReplaceable(ctx, direction.m_122427_(), 2) ? (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_((Property)SIDE, (Comparable)((Object)IBlock.EnumSide.LEFT))).m_61124_((Property)TEMP, (Comparable)Boolean.valueOf(false)) : null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return IBlock.getVoxelShapeByDirection(0.0, 0.0, 0.0, 16.0, 16.0, this.isFlat ? 1.0 : 4.0, (Direction)state.m_61143_((Property)f_54117_));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!world.f_46443_) {
            Direction direction = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
            if (this.isOdd) {
                world.m_7731_(pos.m_121945_(direction.m_122427_()), (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_((Property)SIDE, (Comparable)((Object)IBlock.EnumSide.RIGHT))).m_61124_((Property)ODD, (Comparable)Boolean.valueOf(true)), 3);
                world.m_7731_(pos.m_5484_(direction.m_122427_(), 2), (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_((Property)SIDE, (Comparable)((Object)IBlock.EnumSide.RIGHT))).m_61124_((Property)ODD, (Comparable)Boolean.valueOf(false)), 3);
                world.m_46672_(pos.m_121945_(direction.m_122427_()), Blocks.f_50016_);
                state.m_60701_((LevelAccessor)world, pos.m_121945_(direction.m_122427_()), 3);
            } else if (this.isFlat) {
                world.m_7731_(pos.m_121945_(direction.m_122427_()), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_((Property)SIDE, (Comparable)((Object)IBlock.EnumSide.RIGHT)), 3);
            } else {
                world.m_7731_(pos.m_121945_(direction.m_122427_()), (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_((Property)SIDE, (Comparable)((Object)IBlock.EnumSide.RIGHT))).m_61124_((Property)TEMP, (Comparable)Boolean.valueOf(false)), 3);
            }
            world.m_46672_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)world, pos, 3);
        }
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (this.isOdd) {
            ITripleBlock.playerWillDestroy(world, pos, state, player, false);
        } else if (IBlock.getStatePropertySafe(state, SIDE) == IBlock.EnumSide.RIGHT) {
            IBlock.onBreakCreative(world, player, pos.m_121945_(IBlock.getSideDirection(state)));
        }
        super.m_5707_(world, pos, state, player);
    }

    public PushReaction m_5537_(BlockState blockState) {
        return PushReaction.BLOCK;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        return player.m_21055_(Items.LIFT_BUTTONS_LINK_CONNECTOR.get()) || player.m_21055_(Items.LIFT_BUTTONS_LINK_REMOVER.get()) ? InteractionResult.PASS : InteractionResult.FAIL;
    }

    @Override
    public <T extends BlockEntityMapper> void tick(Level world, BlockPos pos, T blockEntity) {
        TileEntityLiftPanel1Base.tick(world, pos, blockEntity);
    }

    public void m_5871_(ItemStack itemStack, BlockGetter blockGetter, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Text.translatable("tooltip.mtr.railway_sign_" + (this.isOdd ? "odd" : "even"), new Object[0]).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
    }

    public static abstract class TileEntityLiftPanel1Base
    extends BlockEntityClientSerializableMapper
    implements TickableMapper {
        private BlockPos trackPosition = null;
        protected boolean converted = false;
        private final boolean isOdd;
        private static final String KEY_TRACK_FLOOR_POS = "track_floor_pos";
        private static final String KEY_CONVERTED = "converted";
        private static final int UPDATE_INTERVAL = 60;

        public TileEntityLiftPanel1Base(BlockEntityType<?> type, BlockPos pos, BlockState state, boolean isOdd) {
            super(type, pos, state);
            this.isOdd = isOdd;
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            long data = compoundTag.m_128454_(KEY_TRACK_FLOOR_POS);
            this.trackPosition = data == 0L ? null : BlockPos.m_122022_((long)data);
            this.converted = compoundTag.m_128471_(KEY_CONVERTED);
            super.readCompoundTag(compoundTag);
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.m_128356_(KEY_TRACK_FLOOR_POS, this.trackPosition == null ? 0L : this.trackPosition.m_121878_());
            compoundTag.m_128379_(KEY_CONVERTED, this.converted);
        }

        @Override
        public void tick() {
            TileEntityLiftPanel1Base.tick(this.f_58857_, this.f_58858_, this);
        }

        public void registerFloor(BlockPos pos, boolean isAdd) {
            if (this.f_58857_ == null) {
                return;
            }
            this.setFloor((BlockPos)(isAdd ? pos : null));
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.isOdd && (Boolean)IBlock.getStatePropertySafe(state, ITripleBlock.ODD) != false ? this.m_58899_() : this.m_58899_().m_121945_(IBlock.getSideDirection(state)));
            if (blockEntity instanceof TileEntityLiftPanel1Base) {
                ((TileEntityLiftPanel1Base)blockEntity).setFloor((BlockPos)(isAdd ? pos : null));
            }
        }

        public BlockPos getTrackPosition(Level world) {
            if (this.trackPosition != null && !(world.m_7702_(this.trackPosition) instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor)) {
                this.trackPosition = null;
            }
            return this.trackPosition;
        }

        private void setFloor(BlockPos pos) {
            this.trackPosition = pos;
            this.m_6596_();
            this.syncData();
        }

        protected void convert() {
            if (!this.converted) {
                this.converted = true;
                this.m_6596_();
                this.syncData();
            }
        }

        public static <T extends BlockEntityMapper> void tick(Level world, BlockPos pos, T blockEntity) {
            if (world != null && world.m_5788_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 16.0, entity -> true) != null && blockEntity instanceof TileEntityLiftPanel1Base && !world.f_46443_ && MTR.isGameTickInterval(60, (int)pos.m_121878_())) {
                ((TileEntityLiftPanel1Base)blockEntity).getTrackPosition(world);
                blockEntity.m_6596_();
                ((TileEntityLiftPanel1Base)blockEntity).syncData();
            }
            if (world != null && !world.f_46443_ && blockEntity instanceof TileEntityLiftPanel1Base) {
                ((TileEntityLiftPanel1Base)blockEntity).convert();
            }
        }
    }
}

