/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.Items;
import mtr.block.IBlock;
import mtr.mappings.HorizontalBlockWithSoftLanding;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BlockEscalatorBase
extends HorizontalBlockWithSoftLanding
implements IBlock {
    public static final EnumProperty<EnumEscalatorOrientation> ORIENTATION = EnumProperty.m_61587_((String)"orientation", EnumEscalatorOrientation.class);

    protected BlockEscalatorBase() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60999_().m_60978_(2.0f).m_60955_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        if (this.getSideDirection(state) == direction && !newState.m_60713_((Block)this)) {
            return Blocks.f_50016_.m_49966_();
        }
        return (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)this.getOrientation((BlockGetter)world, pos, state)));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext collisionContext) {
        EnumEscalatorOrientation orientation = this.getOrientation(world, pos, state);
        if (orientation == EnumEscalatorOrientation.SLOPE || orientation == EnumEscalatorOrientation.TRANSITION_TOP) {
            return Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)IBlock.getVoxelShapeByDirection(0.0, 8.0, 0.0, 16.0, 15.0, 8.0, (Direction)IBlock.getStatePropertySafe(state, f_54117_)));
        }
        return Shapes.m_83144_();
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return state;
    }

    public Item m_5456_() {
        return Items.ESCALATOR.get();
    }

    public ItemStack m_7397_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)this.m_5456_());
    }

    public PushReaction m_5537_(BlockState blockState) {
        return PushReaction.BLOCK;
    }

    protected final EnumEscalatorOrientation getOrientation(BlockGetter world, BlockPos pos, BlockState state) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        BlockPos posAhead = pos.m_121945_(facing);
        BlockPos posBehind = pos.m_5484_(facing, -1);
        boolean isAhead = state.m_60713_(world.m_8055_(posAhead).m_60734_());
        boolean isAheadUp = state.m_60713_(world.m_8055_(posAhead.m_7494_()).m_60734_());
        boolean isBehind = state.m_60713_(world.m_8055_(posBehind).m_60734_());
        boolean isBehindDown = state.m_60713_(world.m_8055_(posBehind.m_7495_()).m_60734_());
        if (isAhead && isBehind) {
            return EnumEscalatorOrientation.FLAT;
        }
        if (isAheadUp && isBehindDown) {
            return EnumEscalatorOrientation.SLOPE;
        }
        if (isAheadUp && isBehind) {
            return EnumEscalatorOrientation.TRANSITION_BOTTOM;
        }
        if (isAhead && isBehindDown) {
            return EnumEscalatorOrientation.TRANSITION_TOP;
        }
        if (isBehind) {
            return EnumEscalatorOrientation.LANDING_TOP;
        }
        return EnumEscalatorOrientation.LANDING_BOTTOM;
    }

    @Override
    private Direction getSideDirection(BlockState state) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        return IBlock.getStatePropertySafe(state, SIDE) == IBlock.EnumSide.RIGHT ? facing.m_122428_() : facing.m_122427_();
    }

    protected static enum EnumEscalatorOrientation implements StringRepresentable
    {
        LANDING_BOTTOM("landing_bottom"),
        LANDING_TOP("landing_top"),
        FLAT("flat"),
        SLOPE("slope"),
        TRANSITION_BOTTOM("transition_bottom"),
        TRANSITION_TOP("transition_top");

        private final String name;

        private EnumEscalatorOrientation(String nameIn) {
            this.name = nameIn;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

