/*
 * Decompiled with CFR 0.152.
 */
package mtr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import mtr.BlockEntityTypes;
import mtr.Blocks;
import mtr.EntityTypes;
import mtr.Items;
import mtr.KeyMappings;
import mtr.Keys;
import mtr.Patreon;
import mtr.Registry;
import mtr.RegistryClient;
import mtr.block.BlockTactileMap;
import mtr.client.ClientData;
import mtr.client.Config;
import mtr.client.IDrawing;
import mtr.data.Depot;
import mtr.data.IGui;
import mtr.data.PIDSType;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.Station;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.render.RenderAPGGlass;
import mtr.render.RenderBoatNode;
import mtr.render.RenderClock;
import mtr.render.RenderLift;
import mtr.render.RenderLiftButtons;
import mtr.render.RenderLiftPanel;
import mtr.render.RenderPIDS;
import mtr.render.RenderPSDAPGDoor;
import mtr.render.RenderPSDTop;
import mtr.render.RenderRailwaySign;
import mtr.render.RenderRouteSign;
import mtr.render.RenderSignalLight2Aspect;
import mtr.render.RenderSignalLight3Aspect;
import mtr.render.RenderSignalLight4Aspect;
import mtr.render.RenderSignalSemaphore;
import mtr.render.RenderStationNameTall;
import mtr.render.RenderStationNameTiled;
import mtr.render.RenderTrains;
import mtr.servlet.Webserver;
import mtr.sound.LoopingSoundInstance;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.world.item.Item;

public class MTRClient
implements IPacket {
    private static boolean isReplayMod;
    private static boolean isVivecraft;
    private static boolean isPehkui;
    private static float gameTick;
    private static float lastPlayedTrainSoundsTick;
    private static int tick;
    private static long startSampleMillis;
    private static float startSampleGameTick;
    private static float gameTickTest;
    private static int skipTicks;
    private static int lastSkipTicks;
    public static final int TICKS_PER_SPEED_SOUND = 4;
    public static final LoopingSoundInstance TACTILE_MAP_SOUND_INSTANCE;
    private static final int SAMPLE_MILLIS = 1000;

    public static void init() {
        if (!Keys.LIFTS_ONLY) {
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.APG_DOOR.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.APG_GLASS.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.APG_GLASS_END.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.CABLE_CAR_NODE_LOWER.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.CABLE_CAR_NODE_UPPER.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.CLOCK.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110466_(), Blocks.GLASS_FENCE_CIO.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110466_(), Blocks.GLASS_FENCE_CKT.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110466_(), Blocks.GLASS_FENCE_HEO.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110466_(), Blocks.GLASS_FENCE_MOS.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110466_(), Blocks.GLASS_FENCE_PLAIN.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110466_(), Blocks.GLASS_FENCE_SHM.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110466_(), Blocks.GLASS_FENCE_STAINED.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110466_(), Blocks.GLASS_FENCE_STW.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110466_(), Blocks.GLASS_FENCE_TSH.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110466_(), Blocks.GLASS_FENCE_WKS.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.LOGO.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.PLATFORM.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.PLATFORM_INDENTED.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.PLATFORM_NA_1.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.PLATFORM_NA_1_INDENTED.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.PLATFORM_NA_2.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.PLATFORM_NA_2_INDENTED.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.PLATFORM_UK_1.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.PLATFORM_UK_1_INDENTED.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.PSD_DOOR_1.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.PSD_GLASS_1.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.PSD_GLASS_END_1.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.PSD_DOOR_2.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.PSD_GLASS_2.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.PSD_GLASS_END_2.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.RUBBISH_BIN_1.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110466_(), Blocks.STATION_COLOR_STAINED_GLASS.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110466_(), Blocks.STATION_COLOR_STAINED_GLASS_SLAB.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.STATION_NAME_TALL_BLOCK.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.STATION_NAME_TALL_BLOCK_DOUBLE_SIDED.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.STATION_NAME_TALL_WALL.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.TICKET_BARRIER_ENTRANCE_1.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.TICKET_BARRIER_EXIT_1.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.TICKET_MACHINE.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.TICKET_PROCESSOR.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.TICKET_PROCESSOR_ENTRANCE.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.TICKET_PROCESSOR_EXIT.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.TICKET_PROCESSOR_ENQUIRY.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.TRAIN_ANNOUNCER.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.TRAIN_CARGO_LOADER.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.TRAIN_CARGO_UNLOADER.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.TRAIN_REDSTONE_SENSOR.get());
            RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.TRAIN_SCHEDULE_SENSOR.get());
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_20.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_20_ONE_WAY.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_40.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_40_ONE_WAY.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_60.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_60_ONE_WAY.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_80.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_80_ONE_WAY.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_120.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_120_ONE_WAY.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_160.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_160_ONE_WAY.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_200.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_200_ONE_WAY.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_300.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_300_ONE_WAY.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_PLATFORM.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_SIDING.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_TURN_BACK.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_CABLE_CAR.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_CONNECTOR_RUNWAY.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.RAIL_REMOVER.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_WHITE.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_ORANGE.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_MAGENTA.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_LIGHT_BLUE.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_YELLOW.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_LIME.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_PINK.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_GRAY.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_LIGHT_GRAY.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_CYAN.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_PURPLE.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_BLUE.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_BROWN.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_GREEN.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_RED.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_CONNECTOR_BLACK.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_WHITE.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_ORANGE.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_MAGENTA.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_LIGHT_BLUE.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_YELLOW.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_LIME.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_PINK.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_GRAY.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_LIGHT_GRAY.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_CYAN.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_PURPLE.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_BLUE.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_BROWN.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_GREEN.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_RED.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.SIGNAL_REMOVER_BLACK.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.BRIDGE_CREATOR_3.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.BRIDGE_CREATOR_5.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.BRIDGE_CREATOR_7.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.BRIDGE_CREATOR_9.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_4_3.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_4_5.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_4_7.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_4_9.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_5_3.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_5_5.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_5_7.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_5_9.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_6_3.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_6_5.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_6_7.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_CREATOR_6_9.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_4_3.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_4_5.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_4_7.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_4_9.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_5_3.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_5_5.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_5_7.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_5_9.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_6_3.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_6_5.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_6_7.get(), "pos");
            RegistryClient.registerItemModelPredicate("mtr:selected", Items.TUNNEL_WALL_CREATOR_6_9.get(), "pos");
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.ARRIVAL_PROJECTOR_1_SMALL_TILE_ENTITY.get(), dispatcher -> new RenderPIDS((BlockEntityRenderDispatcher)dispatcher, 12, 1.0f, 15.0f, 16.0f, 14.0f, 14, false, false, PIDSType.ARRIVAL_PROJECTOR, 0xFF9900, 0xFF9900));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.ARRIVAL_PROJECTOR_1_MEDIUM_TILE_ENTITY.get(), dispatcher -> new RenderPIDS((BlockEntityRenderDispatcher)dispatcher, 12, -15.0f, 15.0f, 16.0f, 30.0f, 46, false, false, PIDSType.ARRIVAL_PROJECTOR, 0xFF9900, 0xFF9900));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.ARRIVAL_PROJECTOR_1_LARGE_TILE_ENTITY.get(), dispatcher -> new RenderPIDS((BlockEntityRenderDispatcher)dispatcher, 16, -15.0f, 15.0f, 16.0f, 46.0f, 46, false, false, PIDSType.ARRIVAL_PROJECTOR, 0xFF9900, 0xFF9900));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.BOAT_NODE_TILE_ENTITY.get(), RenderBoatNode::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.CLOCK_TILE_ENTITY.get(), RenderClock::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.PSD_DOOR_1_TILE_ENTITY.get(), dispatcher -> new RenderPSDAPGDoor((BlockEntityRenderDispatcher)dispatcher, 0));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.PSD_DOOR_2_TILE_ENTITY.get(), dispatcher -> new RenderPSDAPGDoor((BlockEntityRenderDispatcher)dispatcher, 1));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.PSD_TOP_TILE_ENTITY.get(), RenderPSDTop::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.APG_GLASS_TILE_ENTITY.get(), RenderAPGGlass::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.APG_DOOR_TILE_ENTITY.get(), dispatcher -> new RenderPSDAPGDoor((BlockEntityRenderDispatcher)dispatcher, 2));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.PIDS_1_TILE_ENTITY.get(), dispatcher -> new RenderPIDS((BlockEntityRenderDispatcher)dispatcher, 1, 1.0f, 3.25f, 6.0f, 2.5f, 30, true, false, PIDSType.PIDS, 0xFF9900, 0xFF9900));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.PIDS_2_TILE_ENTITY.get(), dispatcher -> new RenderPIDS((BlockEntityRenderDispatcher)dispatcher, 3, 1.5f, 7.5f, 6.0f, 6.5f, 29, true, true, PIDSType.PIDS, 0xFF9900, 0xFF9900));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.PIDS_3_TILE_ENTITY.get(), dispatcher -> new RenderPIDS((BlockEntityRenderDispatcher)dispatcher, 2, 2.5f, 7.5f, 6.0f, 6.5f, 27, true, false, PIDSType.PIDS, 0xFF9900, 0x33CC00, 1.25f, true));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_2_EVEN_TILE_ENTITY.get(), RenderRailwaySign::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_2_ODD_TILE_ENTITY.get(), RenderRailwaySign::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_3_EVEN_TILE_ENTITY.get(), RenderRailwaySign::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_3_ODD_TILE_ENTITY.get(), RenderRailwaySign::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_4_EVEN_TILE_ENTITY.get(), RenderRailwaySign::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_4_ODD_TILE_ENTITY.get(), RenderRailwaySign::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_5_EVEN_TILE_ENTITY.get(), RenderRailwaySign::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_5_ODD_TILE_ENTITY.get(), RenderRailwaySign::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_6_EVEN_TILE_ENTITY.get(), RenderRailwaySign::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_6_ODD_TILE_ENTITY.get(), RenderRailwaySign::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_7_EVEN_TILE_ENTITY.get(), RenderRailwaySign::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.RAILWAY_SIGN_7_ODD_TILE_ENTITY.get(), RenderRailwaySign::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.ROUTE_SIGN_STANDING_LIGHT_TILE_ENTITY.get(), RenderRouteSign::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.ROUTE_SIGN_STANDING_METAL_TILE_ENTITY.get(), RenderRouteSign::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.ROUTE_SIGN_WALL_LIGHT_TILE_ENTITY.get(), RenderRouteSign::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.ROUTE_SIGN_WALL_METAL_TILE_ENTITY.get(), RenderRouteSign::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.SIGNAL_LIGHT_2_ASPECT_1.get(), dispatcher -> new RenderSignalLight2Aspect((BlockEntityRenderDispatcher)dispatcher, true, false, -16776961));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.SIGNAL_LIGHT_2_ASPECT_2.get(), dispatcher -> new RenderSignalLight2Aspect((BlockEntityRenderDispatcher)dispatcher, false, false, -16776961));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.SIGNAL_LIGHT_2_ASPECT_3.get(), dispatcher -> new RenderSignalLight2Aspect((BlockEntityRenderDispatcher)dispatcher, true, true, -16711936));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.SIGNAL_LIGHT_2_ASPECT_4.get(), dispatcher -> new RenderSignalLight2Aspect((BlockEntityRenderDispatcher)dispatcher, false, true, -16711936));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.SIGNAL_LIGHT_3_ASPECT_1.get(), dispatcher -> new RenderSignalLight3Aspect((BlockEntityRenderDispatcher)dispatcher, true));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.SIGNAL_LIGHT_3_ASPECT_2.get(), dispatcher -> new RenderSignalLight3Aspect((BlockEntityRenderDispatcher)dispatcher, false));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.SIGNAL_LIGHT_4_ASPECT_1.get(), dispatcher -> new RenderSignalLight4Aspect((BlockEntityRenderDispatcher)dispatcher, true));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.SIGNAL_LIGHT_4_ASPECT_2.get(), dispatcher -> new RenderSignalLight4Aspect((BlockEntityRenderDispatcher)dispatcher, false));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.SIGNAL_SEMAPHORE_1.get(), dispatcher -> new RenderSignalSemaphore((BlockEntityRenderDispatcher)dispatcher, true));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.SIGNAL_SEMAPHORE_2.get(), dispatcher -> new RenderSignalSemaphore((BlockEntityRenderDispatcher)dispatcher, false));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.STATION_NAME_ENTRANCE_TILE_ENTITY.get(), dispatcher -> new RenderStationNameTiled((BlockEntityRenderDispatcher)dispatcher, true));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.STATION_NAME_TALL_BLOCK_TILE_ENTITY.get(), RenderStationNameTall::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.STATION_NAME_TALL_BLOCK_DOUBLE_SIDED_TILE_ENTITY.get(), RenderStationNameTall::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.STATION_NAME_TALL_WALL_TILE_ENTITY.get(), RenderStationNameTall::new);
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.STATION_NAME_WALL_WHITE_TILE_ENTITY.get(), dispatcher -> new RenderStationNameTiled((BlockEntityRenderDispatcher)dispatcher, false));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.STATION_NAME_WALL_GRAY_TILE_ENTITY.get(), dispatcher -> new RenderStationNameTiled((BlockEntityRenderDispatcher)dispatcher, false));
            RegistryClient.registerTileEntityRenderer(BlockEntityTypes.STATION_NAME_WALL_BLACK_TILE_ENTITY.get(), dispatcher -> new RenderStationNameTiled((BlockEntityRenderDispatcher)dispatcher, false));
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_ANDESITE.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_BEDROCK.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_BIRCH_WOOD.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_BONE_BLOCK.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_CHISELED_QUARTZ_BLOCK.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_CHISELED_STONE_BRICKS.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_CLAY.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_COAL_ORE.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_COBBLESTONE.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_CONCRETE.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_CONCRETE_POWDER.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_CRACKED_STONE_BRICKS.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_DARK_PRISMARINE.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_DIORITE.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_GRAVEL.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_IRON_BLOCK.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_METAL.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_PLANKS.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_POLISHED_ANDESITE.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_POLISHED_DIORITE.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_PURPUR_BLOCK.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_PURPUR_PILLAR.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_QUARTZ_BLOCK.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_QUARTZ_BRICKS.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_QUARTZ_PILLAR.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_SMOOTH_QUARTZ.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_SMOOTH_STONE.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_SNOW_BLOCK.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_STAINED_GLASS.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_STONE.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_STONE_BRICKS.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_WOOL.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_ANDESITE_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_BEDROCK_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_BIRCH_WOOD_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_BONE_BLOCK_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_CHISELED_QUARTZ_BLOCK_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_CHISELED_STONE_BRICKS_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_CLAY_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_COAL_ORE_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_COBBLESTONE_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_CONCRETE_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_CONCRETE_POWDER_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_CRACKED_STONE_BRICKS_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_DARK_PRISMARINE_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_DIORITE_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_GRAVEL_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_IRON_BLOCK_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_METAL_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_PLANKS_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_POLISHED_ANDESITE_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_POLISHED_DIORITE_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_PURPUR_BLOCK_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_PURPUR_PILLAR_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_QUARTZ_BLOCK_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_QUARTZ_BRICKS_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_QUARTZ_PILLAR_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_SMOOTH_QUARTZ_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_SMOOTH_STONE_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_SNOW_BLOCK_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_STAINED_GLASS_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_STONE_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_STONE_BRICKS_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_WOOL_SLAB.get());
            RegistryClient.registerBlockColors(Blocks.STATION_NAME_TALL_BLOCK.get());
            RegistryClient.registerBlockColors(Blocks.STATION_NAME_TALL_BLOCK_DOUBLE_SIDED.get());
            RegistryClient.registerBlockColors(Blocks.STATION_NAME_TALL_WALL.get());
            RegistryClient.registerBlockColors(Blocks.STATION_COLOR_POLE.get());
        }
        RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.LIFT_DOOR_EVEN_1.get());
        RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.LIFT_DOOR_ODD_1.get());
        RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.LIFT_PANEL_EVEN_1.get());
        RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.LIFT_PANEL_ODD_1.get());
        RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.LIFT_PANEL_EVEN_2.get());
        RegistryClient.registerBlockRenderType(RenderType.m_110463_(), Blocks.LIFT_PANEL_ODD_2.get());
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.LIFT_BUTTONS_LINK_CONNECTOR.get(), "pos");
        RegistryClient.registerItemModelPredicate("mtr:selected", Items.LIFT_BUTTONS_LINK_REMOVER.get(), "pos");
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.LIFT_BUTTONS_1_TILE_ENTITY.get(), RenderLiftButtons::new);
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.LIFT_PANEL_EVEN_1_TILE_ENTITY.get(), dispatcher -> new RenderLiftPanel((BlockEntityRenderDispatcher)dispatcher, false, false));
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.LIFT_PANEL_ODD_1_TILE_ENTITY.get(), dispatcher -> new RenderLiftPanel((BlockEntityRenderDispatcher)dispatcher, true, false));
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.LIFT_PANEL_EVEN_2_TILE_ENTITY.get(), dispatcher -> new RenderLiftPanel((BlockEntityRenderDispatcher)dispatcher, false, true));
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.LIFT_PANEL_ODD_2_TILE_ENTITY.get(), dispatcher -> new RenderLiftPanel((BlockEntityRenderDispatcher)dispatcher, true, true));
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.LIFT_DOOR_EVEN_1_TILE_ENTITY.get(), dispatcher -> new RenderPSDAPGDoor((BlockEntityRenderDispatcher)dispatcher, 3));
        RegistryClient.registerTileEntityRenderer(BlockEntityTypes.LIFT_DOOR_ODD_1_TILE_ENTITY.get(), dispatcher -> new RenderPSDAPGDoor((BlockEntityRenderDispatcher)dispatcher, 4));
        RegistryClient.registerEntityRenderer(EntityTypes.SEAT.get(), RenderTrains::new);
        RegistryClient.registerEntityRenderer(EntityTypes.LiftType.SIZE_2_2.registryObject.get(), RenderLift::new);
        RegistryClient.registerEntityRenderer(EntityTypes.LiftType.SIZE_2_2_DOUBLE_SIDED.registryObject.get(), RenderLift::new);
        RegistryClient.registerEntityRenderer(EntityTypes.LiftType.SIZE_3_2.registryObject.get(), RenderLift::new);
        RegistryClient.registerEntityRenderer(EntityTypes.LiftType.SIZE_3_2_DOUBLE_SIDED.registryObject.get(), RenderLift::new);
        RegistryClient.registerEntityRenderer(EntityTypes.LiftType.SIZE_3_3.registryObject.get(), RenderLift::new);
        RegistryClient.registerEntityRenderer(EntityTypes.LiftType.SIZE_3_3_DOUBLE_SIDED.registryObject.get(), RenderLift::new);
        RegistryClient.registerEntityRenderer(EntityTypes.LiftType.SIZE_4_3.registryObject.get(), RenderLift::new);
        RegistryClient.registerEntityRenderer(EntityTypes.LiftType.SIZE_4_3_DOUBLE_SIDED.registryObject.get(), RenderLift::new);
        RegistryClient.registerEntityRenderer(EntityTypes.LiftType.SIZE_4_4.registryObject.get(), RenderLift::new);
        RegistryClient.registerEntityRenderer(EntityTypes.LiftType.SIZE_4_4_DOUBLE_SIDED.registryObject.get(), RenderLift::new);
        RegistryClient.registerNetworkReceiver(PACKET_VERSION_CHECK, packet -> PacketTrainDataGuiClient.openVersionCheckS2C(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_CHUNK_S2C, packet -> PacketTrainDataGuiClient.receiveChunk(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_OPEN_DASHBOARD_SCREEN, packet -> PacketTrainDataGuiClient.openDashboardScreenS2C(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_OPEN_PIDS_CONFIG_SCREEN, packet -> PacketTrainDataGuiClient.openPIDSConfigScreenS2C(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_OPEN_ARRIVAL_PROJECTOR_CONFIG_SCREEN, packet -> PacketTrainDataGuiClient.openArrivalProjectorConfigScreenS2C(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_OPEN_RAILWAY_SIGN_SCREEN, packet -> PacketTrainDataGuiClient.openRailwaySignScreenS2C(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_OPEN_TICKET_MACHINE_SCREEN, packet -> PacketTrainDataGuiClient.openTicketMachineScreenS2C(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_OPEN_TRAIN_SENSOR_SCREEN, packet -> PacketTrainDataGuiClient.openTrainSensorScreenS2C(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_OPEN_RESOURCE_PACK_CREATOR_SCREEN, packet -> PacketTrainDataGuiClient.openResourcePackCreatorScreen(Minecraft.m_91087_()));
        RegistryClient.registerNetworkReceiver(PACKET_ANNOUNCE, packet -> PacketTrainDataGuiClient.announceS2C(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_GENERATE_PATH, packet -> PacketTrainDataGuiClient.generatePathS2C(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_CREATE_RAIL, packet -> PacketTrainDataGuiClient.createRailS2C(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_CREATE_SIGNAL, packet -> PacketTrainDataGuiClient.createSignalS2C(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_REMOVE_NODE, packet -> PacketTrainDataGuiClient.removeNodeS2C(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_REMOVE_RAIL, packet -> PacketTrainDataGuiClient.removeRailConnectionS2C(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_REMOVE_SIGNALS, packet -> PacketTrainDataGuiClient.removeSignalsS2C(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_REMOVE_LIFT_FLOOR_TRACK, packet -> PacketTrainDataGuiClient.removeLiftFloorTrackS2C(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_STATION, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.m_91087_(), packet, ClientData.STATIONS, ClientData.DATA_CACHE.stationIdMap, (id, transportMode) -> new Station((long)id), false));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_PLATFORM, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.m_91087_(), packet, ClientData.PLATFORMS, ClientData.DATA_CACHE.platformIdMap, null, false));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_SIDING, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.m_91087_(), packet, ClientData.SIDINGS, ClientData.DATA_CACHE.sidingIdMap, null, false));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_ROUTE, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.m_91087_(), packet, ClientData.ROUTES, ClientData.DATA_CACHE.routeIdMap, Route::new, false));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_DEPOT, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.m_91087_(), packet, ClientData.DEPOTS, ClientData.DATA_CACHE.depotIdMap, Depot::new, false));
        RegistryClient.registerNetworkReceiver(PACKET_DELETE_STATION, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.m_91087_(), packet, ClientData.STATIONS, ClientData.DATA_CACHE.stationIdMap, (id, transportMode) -> new Station((long)id), true));
        RegistryClient.registerNetworkReceiver(PACKET_DELETE_PLATFORM, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.m_91087_(), packet, ClientData.PLATFORMS, ClientData.DATA_CACHE.platformIdMap, null, true));
        RegistryClient.registerNetworkReceiver(PACKET_DELETE_SIDING, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.m_91087_(), packet, ClientData.SIDINGS, ClientData.DATA_CACHE.sidingIdMap, null, true));
        RegistryClient.registerNetworkReceiver(PACKET_DELETE_ROUTE, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.m_91087_(), packet, ClientData.ROUTES, ClientData.DATA_CACHE.routeIdMap, Route::new, true));
        RegistryClient.registerNetworkReceiver(PACKET_DELETE_DEPOT, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.m_91087_(), packet, ClientData.DEPOTS, ClientData.DATA_CACHE.depotIdMap, Depot::new, true));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_LIFT, packet -> PacketTrainDataGuiClient.receiveUpdateOrDeleteS2C(Minecraft.m_91087_(), packet, ClientData.LIFTS, ClientData.DATA_CACHE.liftsClientIdMap, null, false));
        RegistryClient.registerNetworkReceiver(PACKET_WRITE_RAILS, packet -> ClientData.writeRails(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_TRAINS, packet -> ClientData.updateTrains(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_LIFTS, packet -> ClientData.updateLifts(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_DELETE_TRAINS, packet -> ClientData.deleteTrains(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_DELETE_LIFTS, packet -> ClientData.deleteLifts(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_TRAIN_PASSENGERS, packet -> ClientData.updateTrainPassengers(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_LIFT_PASSENGERS, packet -> ClientData.updateLiftPassengers(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_TRAIN_PASSENGER_POSITION, packet -> ClientData.updateTrainPassengerPosition(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_LIFT_PASSENGER_POSITION, packet -> ClientData.updateLiftPassengerPosition(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_RAIL_ACTIONS, packet -> ClientData.updateRailActions(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_UPDATE_SCHEDULE, packet -> ClientData.updateSchedule(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_OPEN_LIFT_TRACK_FLOOR_SCREEN, packet -> PacketTrainDataGuiClient.openLiftTrackFloorS2C(Minecraft.m_91087_(), packet));
        RegistryClient.registerNetworkReceiver(PACKET_OPEN_LIFT_CUSTOMIZATION_SCREEN, packet -> PacketTrainDataGuiClient.openLiftCustomizationS2C(Minecraft.m_91087_(), packet));
        RegistryClient.registerKeyBinding(KeyMappings.LIFT_MENU);
        if (!Keys.LIFTS_ONLY) {
            RegistryClient.registerKeyBinding(KeyMappings.TRAIN_ACCELERATE);
            RegistryClient.registerKeyBinding(KeyMappings.TRAIN_BRAKE);
            RegistryClient.registerKeyBinding(KeyMappings.TRAIN_TOGGLE_DOORS);
            RegistryClient.registerKeyBinding(KeyMappings.DEBUG_1_NEGATIVE);
            RegistryClient.registerKeyBinding(KeyMappings.DEBUG_2_NEGATIVE);
            RegistryClient.registerKeyBinding(KeyMappings.DEBUG_3_NEGATIVE);
            RegistryClient.registerKeyBinding(KeyMappings.DEBUG_1_POSITIVE);
            RegistryClient.registerKeyBinding(KeyMappings.DEBUG_2_POSITIVE);
            RegistryClient.registerKeyBinding(KeyMappings.DEBUG_3_POSITIVE);
            RegistryClient.registerKeyBinding(KeyMappings.DEBUG_ROTATE_CATEGORY_NEGATIVE);
            RegistryClient.registerKeyBinding(KeyMappings.DEBUG_ROTATE_CATEGORY_POSITIVE);
        }
        Patreon.getPatreonList(Config.PATREON_LIST);
        Config.refreshProperties();
        RegistryClient.registerPlayerJoinEvent(player -> {
            Minecraft minecraft;
            Config.refreshProperties();
            isReplayMod = player.getClass().toGenericString().toLowerCase(Locale.ENGLISH).contains("replaymod");
            try {
                Class.forName("org.vivecraft.main.VivecraftMain");
                isVivecraft = true;
            }
            catch (Exception ignored) {
                isVivecraft = false;
            }
            try {
                Class.forName("virtuoel.pehkui.Pehkui");
                isPehkui = true;
            }
            catch (Exception ignored) {
                isPehkui = false;
            }
            System.out.println(isReplayMod ? "Running in Replay Mod mode" : "Not running in Replay Mod mode");
            System.out.println(isVivecraft ? "Vivecraft detected" : "Vivecraft not detected");
            System.out.println(isPehkui ? "Pehkui detected" : "Pehkui not detected");
            if (!Keys.LIFTS_ONLY && !(minecraft = Minecraft.m_91087_()).m_91091_()) {
                Webserver.callback = arg_0 -> ((Minecraft)minecraft).execute(arg_0);
                Webserver.getWorlds = () -> minecraft.f_91073_ == null ? new ArrayList() : Collections.singletonList(minecraft.f_91073_);
                Webserver.getRoutes = railwayData -> ClientData.ROUTES;
                Webserver.getDataCache = railwayData -> ClientData.DATA_CACHE;
                Webserver.start(Minecraft.m_91087_().f_91069_.toPath().resolve("config").resolve("mtr_webserver_port.txt"));
            }
        });
        if (!Keys.LIFTS_ONLY) {
            Webserver.init();
            Registry.registerPlayerQuitEvent(player -> Webserver.stop());
            BlockTactileMap.TileEntityTactileMap.updateSoundSource = TACTILE_MAP_SOUND_INSTANCE::setPos;
            BlockTactileMap.TileEntityTactileMap.onUse = pos -> {
                Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
                if (station != null) {
                    IDrawing.narrateOrAnnounce(IGui.insertTranslation("gui.mtr.welcome_station_cjk", "gui.mtr.welcome_station", 1, IGui.textOrUntitled(station.name)));
                }
            };
        }
    }

    public static boolean isReplayMod() {
        return isReplayMod;
    }

    public static boolean isVivecraft() {
        return isVivecraft;
    }

    public static boolean isPehkui() {
        return isPehkui;
    }

    public static float getGameTick() {
        return gameTick;
    }

    public static void incrementGameTick() {
        long millis;
        float lastFrameDuration = MTRClient.getLastFrameDuration();
        gameTickTest += lastFrameDuration;
        if (isReplayMod || tick == 0) {
            gameTick += lastFrameDuration;
        }
        if (++tick >= skipTicks) {
            tick = 0;
        }
        if ((millis = System.currentTimeMillis()) - startSampleMillis >= 1000L) {
            skipTicks = Math.round((gameTickTest - startSampleGameTick) * 50.0f / (float)(millis - startSampleMillis));
            startSampleMillis = millis;
            startSampleGameTick = gameTickTest;
            if (skipTicks != lastSkipTicks) {
                System.out.println("Tick skip updated to " + skipTicks);
            }
            lastSkipTicks = skipTicks;
        }
        ClientData.tick();
    }

    public static float getLastFrameDuration() {
        return isReplayMod ? 0.33333334f : Minecraft.m_91087_().m_91297_();
    }

    public static boolean canPlaySound() {
        if (gameTick - lastPlayedTrainSoundsTick >= 4.0f) {
            lastPlayedTrainSoundsTick = gameTick;
        }
        return gameTick == lastPlayedTrainSoundsTick && !Minecraft.m_91087_().m_91104_();
    }

    static {
        gameTick = 0.0f;
        lastPlayedTrainSoundsTick = 0.0f;
        TACTILE_MAP_SOUND_INSTANCE = new LoopingSoundInstance("tactile_map_music");
    }

    @FunctionalInterface
    public static interface RegisterItemModelPredicate {
        public void accept(String var1, Item var2, String var3);
    }
}

