/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.geforcemods.securitycraft.inventory.StateSelectorAccessMenu;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.geforcemods.securitycraft.screen.components.ToggleComponentButton;
import net.geforcemods.securitycraft.util.StandingOrWallType;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;

public class StateSelector
extends Screen
implements GuiEventListener,
NarratableEntry,
ContainerListener {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/state_selector.png");
    private static final int PAGE_LENGTH = 5;
    private static final float ROTATION_SENSITIVITY = 0.1f;
    private static final Vector3f Y_DRAG_ROTATION_VECTOR = new Vector3f((float)(1.0 / Math.sqrt(2.0)), 0.0f, (float)(1.0 / Math.sqrt(2.0)));
    private static final Quaternion DEFAULT_ROTATION = Quaternion.m_175225_((Vector3f)new Vector3f(15.0f, -135.0f, 0.0f));
    private static final EnumProperty<StandingOrWallType> STANDING_OR_WALL_TYPE_PROPERTY = EnumProperty.m_61587_((String)"standing_or_wall", StandingOrWallType.class);
    private final StateSelectorAccessMenu menu;
    private final int xStart;
    private final int yStart;
    private final int slotToCheck;
    private final float previewXTranslation;
    private final float previewYTranslation;
    private final HoverChecker dragHoverChecker;
    private final List<Rect2i> extraAreas = new ArrayList<Rect2i>();
    private Item blockItem = Items.f_41852_;
    private BlockState state = Blocks.f_50016_.m_49966_();
    private List<Property<?>> properties = List.of();
    private BlockEntity be = null;
    private BlockEntityRenderer beRenderer = null;
    private List<BlockStatePropertyButton<?>> buttons = new ArrayList();
    private int page;
    private int amountOfPages;
    private Button previousPageButton;
    private Button nextPageButton;
    private Matrix4f dragRotation = (Matrix4f)Util.m_137469_((Object)new Matrix4f(), matrix -> matrix.m_27624_());
    private boolean clickedInDragRegion = false;
    private StandingOrWallType standingOrWallType = StandingOrWallType.NONE;

    public StateSelector(StateSelectorAccessMenu menu, Component title, int xStart, int yStart, int slotToCheck, int dragStartX, int dragStartY, float previewXTranslation, float previewYTranslation) {
        super(title);
        menu.m_38893_(this);
        this.menu = menu;
        this.xStart = xStart;
        this.yStart = yStart;
        this.slotToCheck = slotToCheck;
        this.previewXTranslation = previewXTranslation;
        this.previewYTranslation = previewYTranslation;
        this.dragHoverChecker = new HoverChecker(dragStartY += yStart, dragStartY + 47, dragStartX += xStart, dragStartX + 47);
    }

    protected void m_7856_() {
        Item item = this.menu.getStateStack().m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            BlockState savedState = this.menu.getSavedState();
            Block blockToCheck = blockItem.m_40614_();
            this.standingOrWallType = this.menu.getStandingOrWallType();
            if (blockItem instanceof StandingAndWallBlockItem) {
                StandingAndWallBlockItem sawbi = (StandingAndWallBlockItem)blockItem;
                if (this.standingOrWallType == StandingOrWallType.WALL) {
                    blockToCheck = sawbi.f_43246_;
                }
            }
            this.state = blockToCheck == savedState.m_60734_() ? savedState : blockItem.m_40614_().m_49966_();
            this.blockItem = blockItem;
        }
        this.previousPageButton = new Button(this.xStart + 69, this.yStart + 125, 20, 20, (Component)Component.m_237113_((String)"<"), button -> this.turnPage(-1));
        this.nextPageButton = new Button(this.xStart + 126, this.yStart + 125, 20, 20, (Component)Component.m_237113_((String)">"), button -> this.turnPage(1));
        this.updateButtons(true, false);
        this.extraAreas.add(new Rect2i(this.xStart, 0, 193, this.f_96541_.m_91268_().m_85446_()));
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTick) {
        MultiBufferSource.BufferSource bufferSource = this.f_96541_.m_91269_().m_110104_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(pose, this.xStart, this.yStart, 0, 0, 193, 150);
        super.m_6305_(pose, mouseX, mouseY, partialTick);
        this.previousPageButton.m_6305_(pose, mouseX, mouseY, partialTick);
        this.nextPageButton.m_6305_(pose, mouseX, mouseY, partialTick);
        pose.m_85836_();
        pose.m_85837_((double)this.previewXTranslation, (double)this.previewYTranslation, 0.0);
        pose.m_85850_().m_85861_().m_27630_(1.5f);
        pose.m_85837_(0.5, 0.5, 0.5);
        pose.m_85845_(DEFAULT_ROTATION);
        pose.m_166854_(this.dragRotation);
        pose.m_85837_(-0.5, -0.5, -0.5);
        this.renderBlockModel(this.state, pose, (MultiBufferSource)bufferSource);
        if (this.beRenderer != null) {
            this.beRenderer.m_6922_(this.be, partialTick, pose, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_);
        }
        pose.m_85849_();
        for (int i = 0; i < this.buttons.size(); ++i) {
            String propertyName = this.buttons.get(i).getProperty().m_61708_();
            this.f_96547_.m_92883_(pose, propertyName, (float)(this.xStart + 91 - this.f_96547_.m_92895_(propertyName) - 2), (float)(this.yStart + i * 23 + 10), 0x404040);
        }
        this.f_96547_.m_92883_(pose, this.page + "/" + this.amountOfPages, (float)(this.xStart + 100), (float)(this.yStart + 130), 0x404040);
    }

    public void updateButtons(boolean updateInfo, boolean slotChanged) {
        if (updateInfo) {
            this.properties = new ArrayList(this.state.m_61147_());
            this.properties.removeIf(arg_0 -> ((BooleanProperty)BlockStateProperties.f_61362_).equals(arg_0));
            if (this.blockItem instanceof StandingAndWallBlockItem) {
                this.properties.add(0, (Property<?>)STANDING_OR_WALL_TYPE_PROPERTY);
                if (slotChanged) {
                    this.standingOrWallType = StandingOrWallType.STANDING;
                }
            } else if (slotChanged) {
                this.standingOrWallType = StandingOrWallType.NONE;
            }
            this.amountOfPages = (int)Math.ceil((float)this.properties.size() / 5.0f);
            this.page = switch (this.amountOfPages) {
                case 0 -> 0;
                default -> 1;
            };
            this.updateBlockEntityInfo(true);
            this.dragRotation.m_27624_();
        }
        int buttonY = 0;
        int pageStartIndex = (this.page - 1) * 5;
        int i = 0;
        this.buttons.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.buttons.clear();
        for (Property<?> property : this.properties) {
            if (i < pageStartIndex) {
                ++i;
                continue;
            }
            if (i >= pageStartIndex + 5) break;
            Collection values = property.m_6908_();
            StandingOrWallType defaultValue = property == STANDING_OR_WALL_TYPE_PROPERTY ? this.standingOrWallType : this.state.m_61143_(property);
            int defaultValueIndex = 0;
            for (Object o : values) {
                if (o == defaultValue) break;
                ++defaultValueIndex;
            }
            this.buttons.add((BlockStatePropertyButton)this.m_142416_((GuiEventListener)new BlockStatePropertyButton(this.xStart + 91, this.yStart + buttonY + 5, 100, 20, defaultValueIndex, property)));
            buttonY += 23;
            ++i;
        }
        if (this.previousPageButton != null) {
            boolean bl = this.previousPageButton.f_93623_ = this.page > 1;
        }
        if (this.nextPageButton != null) {
            this.nextPageButton.f_93623_ = this.page != this.amountOfPages;
        }
    }

    public void turnPage(int direction) {
        this.page = (int)((float)this.page + Math.signum(direction));
        if (this.page > this.amountOfPages) {
            this.page = 1;
        } else if (this.page < 1) {
            this.page = this.amountOfPages;
        }
        this.updateButtons(false, false);
    }

    private void updateBlockEntityInfo(boolean reset) {
        if (reset) {
            this.be = null;
            this.beRenderer = null;
        }
        if (this.state.m_155947_()) {
            if (this.be == null) {
                Minecraft mc = Minecraft.m_91087_();
                this.be = ((EntityBlock)this.state.m_60734_()).m_142194_(BlockPos.f_121853_, this.state);
                if (this.be != null) {
                    this.be.m_142339_((Level)mc.f_91073_);
                    this.beRenderer = mc.m_167982_().m_112265_(this.be);
                } else {
                    this.beRenderer = null;
                }
            } else {
                this.be.m_155250_(this.state);
            }
        }
    }

    public void renderBlockModel(BlockState state, PoseStack pose, MultiBufferSource bufferSource) {
        if (state.m_60799_() == RenderShape.MODEL) {
            BlockRenderDispatcher blockRenderer = this.f_96541_.m_91289_();
            BakedModel blockModel = blockRenderer.m_110910_(state);
            int color = this.f_96541_.m_91298_().m_92577_(state, null, null, 0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            for (RenderType renderType : blockModel.getRenderTypes(state, this.f_96541_.f_91073_.f_46441_, ModelData.EMPTY)) {
                blockRenderer.m_110937_().renderModel(pose.m_85850_(), bufferSource.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)false)), state, blockModel, r, g, b, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
            }
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.clickedInDragRegion) {
            this.dragRotation.m_27659_();
            this.dragRotation.m_27646_(Vector3f.f_122224_.m_122270_((float)dragX * 0.1f));
            this.dragRotation.m_27646_(Y_DRAG_ROTATION_VECTOR.m_122270_((float)dragY * 0.1f));
            this.dragRotation.m_27659_();
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (int i = 0; i < this.buttons.size() && !this.buttons.get(i).m_6375_(mouseX, mouseY, button); ++i) {
        }
        this.previousPageButton.m_6375_(mouseX, mouseY, button);
        this.nextPageButton.m_6375_(mouseX, mouseY, button);
        this.clickedInDragRegion = this.dragHoverChecker.checkHover(mouseX, mouseY);
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.clickedInDragRegion = false;
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        for (int i = 0; i < this.buttons.size() && !this.buttons.get(i).m_6050_(mouseX, mouseY, delta); ++i) {
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void m_7934_(AbstractContainerMenu menu, int slotIndex, ItemStack newStack) {
        block3: {
            if (slotIndex != this.slotToCheck) break block3;
            var5_4 = newStack.m_41720_();
            if (!(var5_4 instanceof BlockItem)) ** GOTO lbl-1000
            blockItem = (BlockItem)var5_4;
            if (this.state == null || blockItem.m_40614_() != this.state.m_60734_()) {
                this.state = blockItem.m_40614_().m_49966_();
                this.blockItem = blockItem;
            } else lbl-1000:
            // 2 sources

            {
                this.state = Blocks.f_50016_.m_49966_();
                this.blockItem = Items.f_41852_;
            }
            this.updateButtons(true, true);
            if (this.menu != null) {
                this.menu.onStateChange(this.state);
            }
        }
    }

    public boolean m_5755_(boolean focus) {
        return false;
    }

    public List<? extends GuiEventListener> m_6702_() {
        return List.of();
    }

    public void m_142153_(AbstractContainerMenu menu, int slotIndex, int value) {
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public BlockState getState() {
        return this.state;
    }

    public StandingOrWallType getStandingOrWallType() {
        return this.standingOrWallType;
    }

    public List<Rect2i> getGuiExtraAreas() {
        return this.extraAreas;
    }

    public class BlockStatePropertyButton<T extends Comparable<T>>
    extends ToggleComponentButton {
        private final Property<T> property;
        private T value;

        public BlockStatePropertyButton(int xPos, int yPos, int width, int height, int initialValue, Property<T> property) {
            super(xPos, yPos, width, height, null, initialValue, property.m_6908_().size(), b -> {});
            this.property = property;
            this.onValueChange();
        }

        @Override
        public void onValueChange() {
            if (this.property != null) {
                Collection values = this.property.m_6908_();
                int i = 0;
                for (Comparable t : values) {
                    if (i++ != this.getCurrentIndex()) continue;
                    this.value = t;
                    break;
                }
                this.m_93666_((Component)Component.m_237113_((String)this.property.m_6940_(this.value)));
            }
        }

        public void m_5691_() {
            if (this.property == STANDING_OR_WALL_TYPE_PROPERTY) {
                StateSelector.this.state = StateSelector.this.standingOrWallType.getNewState((StandingAndWallBlockItem)StateSelector.this.blockItem);
                StateSelector.this.standingOrWallType = StateSelector.this.standingOrWallType == StandingOrWallType.STANDING ? StandingOrWallType.WALL : StandingOrWallType.STANDING;
                StateSelector.this.updateButtons(true, false);
                StateSelector.this.updateBlockEntityInfo(true);
            } else {
                StateSelector.this.state = (BlockState)StateSelector.this.state.m_61124_(this.property, this.value);
                StateSelector.this.updateBlockEntityInfo(false);
            }
            StateSelector.this.menu.onStateChange(StateSelector.this.state);
        }

        public Property<T> getProperty() {
            return this.property;
        }

        public T getValue() {
            return this.value;
        }
    }
}

