/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.EnumMap;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.SyncLaserSideConfig;
import net.geforcemods.securitycraft.screen.components.CallbackCheckbox;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class LaserScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/block_pocket_manager.png");
    private final boolean hasSmartModule;
    private Component smartModuleTooltip;
    private int xSize = 176;
    private int ySize = 194;
    private int leftPos;
    private int topPos;
    private LaserBlockBlockEntity be;
    private EnumMap<Direction, Boolean> sideConfig;

    public LaserScreen(LaserBlockBlockEntity be, EnumMap<Direction, Boolean> sideConfig) {
        super(be.m_7755_());
        this.be = be;
        this.sideConfig = sideConfig;
        this.hasSmartModule = be.isModuleEnabled(ModuleType.SMART);
    }

    public void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.xSize) / 2;
        this.topPos = (this.f_96544_ - this.ySize) / 2;
        if (this.hasSmartModule) {
            this.sideConfig.forEach((dir, enabled) -> {
                CallbackCheckbox checkbox = new CallbackCheckbox(this.leftPos + 10, this.topPos + dir.m_122411_() * 25 + 30, 20, 20, (Component)Utils.localize("gui.securitycraft:laser." + dir.m_122433_() + "Enabled", new Object[0]), (boolean)enabled, newValue -> this.onChangeValue((Direction)dir, (boolean)newValue), 0x404040);
                checkbox.f_93623_ = this.be.isEnabled();
                this.m_142416_((GuiEventListener)checkbox);
            });
            this.smartModuleTooltip = Utils.localize("gui.securitycraft:laser.smartModule", new Object[0]);
        } else {
            this.smartModuleTooltip = Utils.localize("gui.securitycraft:laser.noSmartModule", new Object[0]);
        }
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(pose);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(pose, this.leftPos, this.topPos, 0, 0, this.xSize, this.ySize);
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92889_(pose, this.f_96539_, (float)(this.leftPos + this.xSize / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2), (float)(this.topPos + 6), 0x404040);
        ClientUtils.renderModuleInfo(pose, ModuleType.SMART, this.smartModuleTooltip, this.hasSmartModule, this.leftPos + 5, this.topPos + 5, this.f_96543_, this.f_96544_, mouseX, mouseY);
    }

    public void onChangeValue(Direction dir, boolean newValue) {
        this.sideConfig.put(dir, newValue);
        SecurityCraft.channel.sendToServer((Object)new SyncLaserSideConfig(this.be.m_58899_(), this.sideConfig));
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

