/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PlayAlarmSound {
    private BlockPos bePos;
    private SoundEvent sound;
    private int soundX;
    private int soundY;
    private int soundZ;
    private float volume;
    private long seed;

    public PlayAlarmSound() {
    }

    public PlayAlarmSound(BlockPos bePos, SoundEvent sound, float volume, long seed) {
        this.bePos = bePos;
        this.sound = sound;
        this.soundX = (int)((float)bePos.m_123341_() * 8.0f);
        this.soundY = (int)((float)bePos.m_123342_() * 8.0f);
        this.soundZ = (int)((float)bePos.m_123343_() * 8.0f);
        this.volume = volume;
        this.seed = seed;
    }

    public static void encode(PlayAlarmSound message, FriendlyByteBuf buf) {
        buf.m_130064_(message.bePos);
        buf.m_130085_(ForgeRegistries.SOUND_EVENTS.getKey((Object)message.sound));
        buf.writeInt(message.soundX);
        buf.writeInt(message.soundY);
        buf.writeInt(message.soundZ);
        buf.writeFloat(message.volume);
        buf.writeLong(message.seed);
    }

    public static PlayAlarmSound decode(FriendlyByteBuf buf) {
        PlayAlarmSound message = new PlayAlarmSound();
        message.bePos = buf.m_130135_();
        message.sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(buf.m_130281_());
        message.soundX = buf.readInt();
        message.soundY = buf.readInt();
        message.soundZ = buf.readInt();
        message.volume = buf.readFloat();
        message.seed = buf.readLong();
        return message;
    }

    public double getX() {
        return (float)this.soundX / 8.0f;
    }

    public double getY() {
        return (float)this.soundY / 8.0f;
    }

    public double getZ() {
        return (float)this.soundZ / 8.0f;
    }

    public static void onMessage(PlayAlarmSound message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level level = ClientHandler.getClientLevel();
            BlockEntity patt2491$temp = level.m_7702_(message.bePos);
            if (patt2491$temp instanceof AlarmBlockEntity) {
                AlarmBlockEntity be = (AlarmBlockEntity)patt2491$temp;
                be.playSound(level, message.getX(), message.getY(), message.getZ(), message.sound, message.volume, message.seed);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

