/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.function.Consumer;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.SpecialDoorBlockEntity;
import net.geforcemods.securitycraft.blocks.KeypadDoorBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class KeypadDoorBlockEntity
extends SpecialDoorBlockEntity
implements IPasswordProtected {
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption(() -> ((KeypadDoorBlockEntity)this).m_58899_());
    private long cooldownEnd = 0L;
    private String passcode;

    public KeypadDoorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.KEYPAD_DOOR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.m_128359_("passcode", this.passcode);
        }
        tag.m_128356_("cooldownLeft", this.getCooldownEnd() - System.currentTimeMillis());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.passcode = tag.m_128461_("passcode");
        this.cooldownEnd = System.currentTimeMillis() + tag.m_128454_("cooldownLeft");
    }

    @Override
    public void activate(Player player) {
        Block block;
        if (!this.f_58857_.f_46443_ && (block = this.m_58900_().m_60734_()) instanceof KeypadDoorBlock) {
            KeypadDoorBlock block2 = (KeypadDoorBlock)block;
            block2.activate(this.m_58900_(), this.f_58857_, this.f_58858_, player, this.getSignalLength());
        }
    }

    @Override
    public boolean shouldAttemptCodebreak(BlockState state, Player player) {
        if (this.isDisabled()) {
            player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            return false;
        }
        return (Boolean)state.m_61143_((Property)DoorBlock.f_52727_) == false && IPasswordProtected.super.shouldAttemptCodebreak(state, player);
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
        this.runForOtherHalf(otherHalf -> otherHalf.setPasswordExclusively(password));
        this.m_6596_();
    }

    public void setPasswordExclusively(String password) {
        this.passcode = password;
        this.m_6596_();
    }

    @Override
    public void startCooldown() {
        long start = System.currentTimeMillis();
        this.startCooldown(start);
        this.runForOtherHalf(otherHalf -> otherHalf.startCooldown(start));
    }

    public void startCooldown(long start) {
        if (!this.isOnCooldown()) {
            this.cooldownEnd = start + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            this.m_6596_();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.SMART, ModuleType.HARMING};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength, this.disabled, this.smartModuleCooldown};
    }

    @Override
    public int defaultSignalLength() {
        return 60;
    }

    @Override
    public void setCustomName(Component customName) {
        super.setCustomName(customName);
        if (this.m_58900_().m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
            ((INameSetter)this.f_58857_.m_7702_(this.f_58858_.m_7494_())).setCustomName(customName);
        }
    }

    public void runForOtherHalf(Consumer<KeypadDoorBlockEntity> action) {
        BlockEntity be = null;
        if (this.m_58900_().m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER) {
            be = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        } else if (this.m_58900_().m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER) {
            be = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        }
        if (be instanceof KeypadDoorBlockEntity) {
            KeypadDoorBlockEntity otherHalf = (KeypadDoorBlockEntity)be;
            action.accept(otherHalf);
        }
    }
}

