/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.util.ItemRequirement;
import io.github.lightman314.lightmanscurrency.util.ItemStackHelper;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;

public class InventoryUtil {
    public static SimpleContainer buildInventory(List<ItemStack> list) {
        SimpleContainer inventory = new SimpleContainer(list.size());
        for (int i = 0; i < list.size(); ++i) {
            inventory.m_6836_(i, list.get(i).m_41777_());
        }
        return inventory;
    }

    public static Container buildInventory(ItemStack stack) {
        SimpleContainer inventory = new SimpleContainer(1);
        inventory.m_6836_(0, stack);
        return inventory;
    }

    public static Container copyInventory(Container inventory) {
        SimpleContainer copy = new SimpleContainer(inventory.m_6643_());
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            copy.m_6836_(i, inventory.m_8020_(i).m_41777_());
        }
        return copy;
    }

    public static NonNullList<ItemStack> buildList(Container inventory) {
        NonNullList list = NonNullList.m_122780_((int)inventory.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            list.set(i, (Object)inventory.m_8020_(i).m_41777_());
        }
        return list;
    }

    public static List<ItemStack> copyList(List<ItemStack> list) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack : list) {
            result.add(stack.m_41777_());
        }
        return result;
    }

    public static int GetItemCount(Container inventory, Item item) {
        int count = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41720_() != item) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    public static int GetItemCount(Container inventory, ItemStack item) {
        int count = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!InventoryUtil.ItemMatches(stack, item)) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    public static int GetItemCount(IItemHandler inventory, ItemStack item) {
        int count = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!InventoryUtil.ItemMatches(stack, item)) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    public static int GetItemCount(Container inventory, Predicate<ItemStack> filter) {
        int count = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!filter.test(stack)) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    public static boolean RemoveItemCount(Container inventory, Item item, int count) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41720_() != item) continue;
            if (stack.m_41613_() > count) {
                stack.m_41774_(count);
                return true;
            }
            count -= stack.m_41613_();
            inventory.m_6836_(i, ItemStack.f_41583_);
        }
        return count <= 0;
    }

    public static boolean RemoveItemCount(Container inventory, ItemStack item) {
        if (InventoryUtil.GetItemCount(inventory, item) < item.m_41613_()) {
            return false;
        }
        int count = item.m_41613_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!InventoryUtil.ItemMatches(stack, item)) continue;
            int amountToTake = MathUtil.clamp(count, 0, stack.m_41613_());
            count -= amountToTake;
            if (amountToTake == stack.m_41613_()) {
                inventory.m_6836_(i, ItemStack.f_41583_);
                continue;
            }
            stack.m_41774_(amountToTake);
        }
        return true;
    }

    public static boolean RemoveItemCount(IItemHandler itemHandler, ItemStack item) {
        if (!InventoryUtil.CanExtractItem(itemHandler, item)) {
            return false;
        }
        int amountToRemove = item.m_41613_();
        for (int i = 0; i < itemHandler.getSlots() && amountToRemove > 0; ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (!InventoryUtil.ItemMatches(stack, item)) continue;
            ItemStack removedStack = itemHandler.extractItem(i, amountToRemove, false);
            if (InventoryUtil.ItemMatches(removedStack, item)) {
                amountToRemove -= removedStack.m_41613_();
                continue;
            }
            itemHandler.insertItem(i, removedStack, false);
        }
        return true;
    }

    public static boolean CanExtractItem(IItemHandler itemHandler, ItemStack item) {
        int amountToRemove = item.m_41613_();
        for (int i = 0; i < itemHandler.getSlots() && amountToRemove > 0; ++i) {
            ItemStack removedStack;
            if (!InventoryUtil.ItemMatches(itemHandler.getStackInSlot(i), item) || !InventoryUtil.ItemMatches(removedStack = itemHandler.extractItem(i, amountToRemove, true), item)) continue;
            amountToRemove -= removedStack.m_41613_();
        }
        return amountToRemove == 0;
    }

    public static int GetItemSpace(Container container, ItemStack item) {
        return InventoryUtil.GetItemSpace(container, item, 0, container.m_6643_());
    }

    public static int GetItemSpace(Container container, ItemStack item, int startingIndex, int stopIndex) {
        int count = 0;
        for (int i = startingIndex; i < stopIndex && i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (InventoryUtil.ItemMatches(item, stack)) {
                count += stack.m_41741_() - stack.m_41613_();
                continue;
            }
            if (!stack.m_41619_()) continue;
            count += stack.m_41741_();
        }
        return count;
    }

    public static int GetItemTagCount(Container inventory, TagKey<Item> itemTag, Item ... blacklistItems) {
        ArrayList blacklist = Lists.newArrayList((Object[])blacklistItems);
        int count = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!InventoryUtil.ItemHasTag(stack, itemTag) || blacklist.contains(stack.m_41720_())) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    public static boolean RemoveItemTagCount(Container inventory, TagKey<Item> itemTag, int count, Item ... blacklistItems) {
        if (InventoryUtil.GetItemTagCount(inventory, itemTag, blacklistItems) < count) {
            return false;
        }
        ArrayList blacklist = Lists.newArrayList((Object[])blacklistItems);
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!InventoryUtil.ItemHasTag(stack, itemTag) || blacklist.contains(stack.m_41720_())) continue;
            int amountToTake = MathUtil.clamp(count, 0, stack.m_41613_());
            count -= amountToTake;
            if (amountToTake == stack.m_41613_()) {
                inventory.m_6836_(i, ItemStack.f_41583_);
                continue;
            }
            stack.m_41774_(amountToTake);
        }
        return true;
    }

    public static boolean PutItemStack(Container inventory, ItemStack stack) {
        int amountToPlace;
        ItemStack inventoryStack;
        int i;
        int amountToMerge = stack.m_41613_();
        Item mergeItem = stack.m_41720_();
        ArrayList<Pair> mergeOrders = new ArrayList<Pair>();
        for (i = 0; i < inventory.m_6643_() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.m_8020_(i);
            if (!InventoryUtil.ItemMatches(stack, inventoryStack) || inventoryStack.m_41613_() == inventoryStack.m_41741_()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, inventoryStack.m_41741_() - inventoryStack.m_41613_());
            mergeOrders.add(new Pair((Object)i, (Object)amountToPlace));
            amountToMerge -= amountToPlace;
        }
        for (i = 0; i < inventory.m_6643_() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.m_8020_(i);
            if (!inventoryStack.m_41619_()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, stack.m_41741_());
            mergeOrders.add(new Pair((Object)i, (Object)amountToPlace));
            amountToMerge -= amountToPlace;
        }
        if (amountToMerge > 0) {
            return false;
        }
        mergeOrders.forEach(order -> {
            ItemStack itemStack = inventory.m_8020_(((Integer)order.getFirst()).intValue());
            if (itemStack.m_41619_()) {
                ItemStack newStack = new ItemStack((ItemLike)mergeItem, ((Integer)order.getSecond()).intValue());
                if (stack.m_41782_()) {
                    newStack.m_41751_(stack.m_41783_().m_6426_());
                }
                inventory.m_6836_(((Integer)order.getFirst()).intValue(), newStack);
            } else {
                itemStack.m_41764_(itemStack.m_41613_() + (Integer)order.getSecond());
            }
        });
        return true;
    }

    public static ItemStack TryPutItemStack(Container inventory, ItemStack stack) {
        int amountToPlace;
        ItemStack inventoryStack;
        int i;
        int amountToMerge = stack.m_41613_();
        for (i = 0; i < inventory.m_6643_() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.m_8020_(i);
            if (!InventoryUtil.ItemMatches(stack, inventoryStack) || inventoryStack.m_41613_() >= inventoryStack.m_41741_()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, inventoryStack.m_41741_() - inventoryStack.m_41613_());
            inventoryStack.m_41769_(amountToPlace);
            inventory.m_6836_(i, inventoryStack);
            amountToMerge -= amountToPlace;
        }
        for (i = 0; i < inventory.m_6643_() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.m_8020_(i);
            if (!inventoryStack.m_41619_()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, stack.m_41741_());
            ItemStack newStack = stack.m_41777_();
            newStack.m_41764_(amountToPlace);
            inventory.m_6836_(i, newStack);
            amountToMerge -= amountToPlace;
        }
        if (amountToMerge > 0) {
            ItemStack leftovers = stack.m_41777_();
            leftovers.m_41764_(amountToMerge);
            return leftovers;
        }
        return ItemStack.f_41583_;
    }

    public static boolean CanPutItemStack(Container inventory, ItemStack stack) {
        int amountToPlace;
        ItemStack inventoryStack;
        int i;
        if (stack.m_41619_()) {
            return true;
        }
        int amountToMerge = stack.m_41613_();
        for (i = 0; i < inventory.m_6643_() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.m_8020_(i);
            if (!InventoryUtil.ItemMatches(stack, inventoryStack) || inventoryStack.m_41613_() == inventoryStack.m_41741_()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, inventoryStack.m_41741_() - inventoryStack.m_41613_());
            amountToMerge -= amountToPlace;
        }
        for (i = 0; i < inventory.m_6643_() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.m_8020_(i);
            if (!inventoryStack.m_41619_()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, stack.m_41741_());
            amountToMerge -= amountToPlace;
        }
        return amountToMerge <= 0;
    }

    public static boolean CanPutItemStacks(Container inventory, ItemStack ... stacks) {
        return InventoryUtil.CanPutItemStacks(inventory, Lists.newArrayList((Object[])stacks));
    }

    public static boolean CanPutItemStacks(Container inventory, List<ItemStack> stacks) {
        int i;
        SimpleContainer copyInventory = new SimpleContainer(inventory.m_6643_());
        for (i = 0; i < inventory.m_6643_(); ++i) {
            copyInventory.m_6836_(i, inventory.m_8020_(i).m_41777_());
        }
        for (i = 0; i < stacks.size(); ++i) {
            if (InventoryUtil.PutItemStack((Container)copyInventory, stacks.get(i))) continue;
            return false;
        }
        return true;
    }

    public static void MergeStacks(Container inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            int amountWanted;
            ItemStack thisStack = inventory.m_8020_(i);
            if (thisStack.m_41619_() || (amountWanted = thisStack.m_41741_() - thisStack.m_41613_()) <= 0) continue;
            for (int j = i + 1; j < inventory.m_6643_(); ++j) {
                ItemStack nextStack = inventory.m_8020_(j);
                if (nextStack.m_41619_() || nextStack.m_41720_() != thisStack.m_41720_() || !ItemStackHelper.TagEquals(thisStack, nextStack)) continue;
                while (amountWanted > 0 && !nextStack.m_41619_()) {
                    nextStack.m_41764_(nextStack.m_41613_() - 1);
                    thisStack.m_41764_(thisStack.m_41613_() + 1);
                    --amountWanted;
                }
            }
        }
    }

    public static void saveAllItems(String key, CompoundTag compound, Container inventory) {
        ItemStackHelper.saveAllItems(key, compound, InventoryUtil.buildList(inventory));
    }

    public static SimpleContainer loadAllItems(String key, CompoundTag compound, int inventorySize) {
        NonNullList tempInventory = NonNullList.m_122780_((int)inventorySize, (Object)ItemStack.f_41583_);
        ItemStackHelper.loadAllItems(key, compound, (NonNullList<ItemStack>)tempInventory);
        return InventoryUtil.buildInventory((List<ItemStack>)tempInventory);
    }

    public static void encodeItems(Container inventory, FriendlyByteBuf buffer) {
        CompoundTag tag = new CompoundTag();
        InventoryUtil.saveAllItems("ITEMS", tag, inventory);
        buffer.writeInt(inventory.m_6643_());
        buffer.m_130079_(tag);
    }

    public static SimpleContainer decodeItems(FriendlyByteBuf buffer) {
        int inventorySize = buffer.readInt();
        return InventoryUtil.loadAllItems("ITEMS", buffer.m_130261_(), inventorySize);
    }

    public static SimpleContainer copy(Container inventory) {
        SimpleContainer copy = new SimpleContainer(inventory.m_6643_());
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            copy.m_6836_(i, inventory.m_8020_(i).m_41777_());
        }
        return copy;
    }

    public static void dumpContents(Level level, BlockPos pos, Container inventory) {
        if (level.f_46443_) {
            return;
        }
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            InventoryUtil.dumpContents(level, pos, inventory.m_8020_(i));
        }
    }

    public static void dumpContents(Level level, BlockPos pos, List<ItemStack> inventory) {
        if (level.f_46443_) {
            return;
        }
        for (ItemStack itemStack : inventory) {
            InventoryUtil.dumpContents(level, pos, itemStack);
        }
    }

    public static void dumpContents(Level level, BlockPos pos, ItemStack stack) {
        if (level.f_46443_) {
            return;
        }
        if (!stack.m_41619_()) {
            ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
            level.m_7967_((Entity)entity);
        }
    }

    public static List<ItemStack> combineQueryItems(ItemStack ... items) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            boolean addNew = true;
            if (item.m_41619_()) continue;
            for (int i = 0; i < itemList.size() && addNew; ++i) {
                if (!InventoryUtil.ItemMatches(item, (ItemStack)itemList.get(i))) continue;
                ((ItemStack)itemList.get(i)).m_41769_(item.m_41613_());
            }
            if (!addNew || item.m_41619_()) continue;
            itemList.add(item.m_41777_());
        }
        return itemList;
    }

    public static List<ItemStack> combineQueryItems(List<ItemStack> items) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            boolean addNew = true;
            for (int i = 0; i < itemList.size() && addNew; ++i) {
                if (!InventoryUtil.ItemMatches(item, (ItemStack)itemList.get(i))) continue;
                ((ItemStack)itemList.get(i)).m_41769_(item.m_41613_());
            }
            if (!addNew || item.m_41619_()) continue;
            itemList.add(item.m_41777_());
        }
        return itemList;
    }

    public static List<ItemRequirement> combineRequirements(ItemRequirement ... requirements) {
        ArrayList<ItemRequirement> list = new ArrayList<ItemRequirement>();
        for (ItemRequirement requirement : requirements) {
            boolean addNew = !requirement.isNull();
            for (int i = 0; i < list.size() && addNew; ++i) {
                if (!((ItemRequirement)list.get((int)i)).filter.equals(requirement.filter)) continue;
                list.set(i, requirement.merge((ItemRequirement)list.get(i)));
                addNew = false;
            }
            if (!addNew) continue;
            list.add(requirement);
        }
        return list;
    }

    public static boolean ItemMatches(ItemStack stack1, ItemStack stack2) {
        if (stack1.m_41720_() == stack2.m_41720_()) {
            return ItemStackHelper.TagEquals(stack1, stack2);
        }
        return false;
    }

    public static boolean ItemsFullyMatch(ItemStack stack1, ItemStack stack2) {
        return InventoryUtil.ItemMatches(stack1, stack2) && stack1.m_41613_() == stack2.m_41613_();
    }

    public static boolean ContainerMatches(@Nonnull Container container1, @Nonnull Container container2) {
        if (container1.m_6643_() != container2.m_6643_()) {
            return false;
        }
        for (int i = 0; i < container1.m_6643_(); ++i) {
            if (InventoryUtil.ItemsFullyMatch(container1.m_8020_(i), container2.m_8020_(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean ItemHasTag(ItemStack item, TagKey<Item> tag) {
        return item.m_204131_().anyMatch(t -> t.equals((Object)tag));
    }

    public static int safeGiveToPlayer(Inventory inv, ItemStack stack) {
        int i = inv.m_36050_(stack);
        if (i == -1) {
            i = inv.m_36062_();
        }
        if (i >= 0) {
            ItemStack stackInSlot = inv.m_8020_(i);
            int putCount = Math.min(stack.m_41613_(), stackInSlot.m_41619_() ? stack.m_41741_() : stackInSlot.m_41741_() - stackInSlot.m_41613_());
            if (putCount > 0) {
                if (stackInSlot.m_41619_()) {
                    stackInSlot = stack.m_41777_();
                    stackInSlot.m_41764_(putCount);
                } else {
                    stackInSlot.m_41769_(putCount);
                }
                stack.m_41774_(putCount);
                inv.m_6836_(i, stackInSlot);
                inv.m_6596_();
            }
            return putCount;
        }
        return 0;
    }
}

