/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.packet;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public abstract class CustomPacket {
    public abstract void encode(@Nonnull FriendlyByteBuf var1);

    public static abstract class SimpleHandler<T extends CustomPacket>
    extends Handler<T> {
        protected final T instance;

        protected SimpleHandler(@Nonnull T instance) {
            this.instance = instance;
        }

        @Override
        @Nonnull
        public final T decode(@Nonnull FriendlyByteBuf buffer) {
            return this.instance;
        }
    }

    public static abstract class Handler<T extends CustomPacket> {
        @Nonnull
        public abstract T decode(@Nonnull FriendlyByteBuf var1);

        public final void handlePacket(@Nonnull T message, @Nonnull Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context context = supplier.get();
            context.enqueueWork(() -> this.handle(message, context.getSender()));
            context.setPacketHandled(true);
        }

        protected abstract void handle(@Nonnull T var1, @Nullable ServerPlayer var2);
    }
}

