/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.walletslot;

import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class CPacketSetVisible
extends ClientToServerPacket {
    public static final CustomPacket.Handler<CPacketSetVisible> HANDLER = new H();
    int entityID;
    boolean visible;

    public CPacketSetVisible(int entityID, boolean visible) {
        this.entityID = entityID;
        this.visible = visible;
    }

    @Override
    public void encode(@Nonnull FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityID);
        buffer.writeBoolean(this.visible);
    }

    private static class H
    extends CustomPacket.Handler<CPacketSetVisible> {
        private H() {
        }

        @Override
        @Nonnull
        public CPacketSetVisible decode(@Nonnull FriendlyByteBuf buffer) {
            return new CPacketSetVisible(buffer.readInt(), buffer.readBoolean());
        }

        @Override
        protected void handle(@Nonnull CPacketSetVisible message, @Nullable ServerPlayer sender) {
            IWalletHandler walletHandler;
            if (sender == null) {
                return;
            }
            Entity entity = sender.f_19853_.m_6815_(message.entityID);
            if (entity != null && (walletHandler = WalletCapability.lazyGetWalletHandler(entity)) != null) {
                walletHandler.setVisible(message.visible);
            }
        }
    }
}

