/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.trader;

import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.menus.validation.IValidatedMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.SimpleValidator;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class CPacketOpenTrades
extends ClientToServerPacket {
    public static final CustomPacket.Handler<CPacketOpenTrades> HANDLER = new H();
    private final long traderID;

    public CPacketOpenTrades(long traderID) {
        this.traderID = traderID;
    }

    @Override
    public void encode(@Nonnull FriendlyByteBuf buffer) {
        buffer.writeLong(this.traderID);
    }

    private static class H
    extends CustomPacket.Handler<CPacketOpenTrades> {
        private H() {
        }

        @Override
        @Nonnull
        public CPacketOpenTrades decode(@Nonnull FriendlyByteBuf buffer) {
            return new CPacketOpenTrades(buffer.readLong());
        }

        @Override
        protected void handle(@Nonnull CPacketOpenTrades message, @Nullable ServerPlayer sender) {
            if (sender != null) {
                TraderData data;
                MenuValidator validator = SimpleValidator.NULL;
                AbstractContainerMenu abstractContainerMenu = sender.f_36096_;
                if (abstractContainerMenu instanceof IValidatedMenu) {
                    IValidatedMenu tm = (IValidatedMenu)abstractContainerMenu;
                    validator = tm.getValidator();
                }
                if ((data = TraderSaveData.GetTrader(false, message.traderID)) != null) {
                    data.openTraderMenu((Player)sender, validator);
                }
            }
        }
    }
}

