/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.config;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class SPacketResetConfig
extends ServerToClientPacket {
    public static final CustomPacket.Handler<SPacketResetConfig> HANDLER = new H();
    private final String fileName;
    private final String option;

    public SPacketResetConfig(@Nonnull String fileName, @Nonnull String option) {
        this.fileName = fileName;
        this.option = option;
    }

    @Override
    public void encode(@Nonnull FriendlyByteBuf buffer) {
        buffer.m_130070_(this.fileName);
        buffer.m_130070_(this.option);
    }

    private static class H
    extends CustomPacket.Handler<SPacketResetConfig> {
        private H() {
        }

        @Override
        @Nonnull
        public SPacketResetConfig decode(@Nonnull FriendlyByteBuf buffer) {
            String fileName = buffer.m_130277_();
            String option = buffer.m_130277_();
            return new SPacketResetConfig(fileName, option);
        }

        @Override
        protected void handle(@Nonnull SPacketResetConfig message, @Nullable ServerPlayer sender) {
            for (ConfigFile file : ConfigFile.getAvailableFiles()) {
                if (!file.isClientOnly() || !file.getFileName().equals(message.fileName)) continue;
                Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
                if (optionMap.containsKey(message.option)) {
                    ConfigOption<?> option = optionMap.get(message.option);
                    option.setToDefault();
                    LightmansCurrency.PROXY.sendClientMessage((Component)EasyText.translatable("command.lightmanscurrency.lcconfig.edit.success", option.getName(), option.write()));
                    continue;
                }
                LightmansCurrency.PROXY.sendClientMessage((Component)EasyText.translatable("command.lightmanscurrency.lcconfig.edit.missing", new Object[0]).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

