/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.config;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.ListOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class SPacketEditListConfig
extends ServerToClientPacket {
    public static final CustomPacket.Handler<SPacketEditListConfig> HANDLER = new H();
    private final String fileName;
    private final String option;
    private final String input;
    private final int listIndex;
    private final boolean isEdit;

    public SPacketEditListConfig(@Nonnull String fileName, @Nonnull String option, @Nonnull String input, int listIndex, boolean isEdit) {
        this.fileName = fileName;
        this.option = option;
        this.input = input;
        this.listIndex = listIndex;
        this.isEdit = isEdit;
    }

    @Override
    public void encode(@Nonnull FriendlyByteBuf buffer) {
        buffer.m_130070_(this.fileName);
        buffer.m_130070_(this.option);
        buffer.writeInt(this.input.length());
        buffer.m_130072_(this.input, this.input.length());
        buffer.writeInt(this.listIndex);
        buffer.writeBoolean(this.isEdit);
    }

    private static class H
    extends CustomPacket.Handler<SPacketEditListConfig> {
        private H() {
        }

        @Override
        @Nonnull
        public SPacketEditListConfig decode(@Nonnull FriendlyByteBuf buffer) {
            String fileName = buffer.m_130277_();
            String option = buffer.m_130277_();
            int inputLength = buffer.readInt();
            return new SPacketEditListConfig(fileName, option, buffer.m_130136_(inputLength), buffer.readInt(), buffer.readBoolean());
        }

        @Override
        protected void handle(@Nonnull SPacketEditListConfig message, @Nullable ServerPlayer sender) {
            for (ConfigFile file : ConfigFile.getAvailableFiles()) {
                ConfigOption<?> configOption;
                if (!file.isClientOnly() || !file.getFileName().equals(message.fileName)) continue;
                Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
                if (optionMap.containsKey(message.option) && (configOption = optionMap.get(message.option)) instanceof ListOption) {
                    int listIndex;
                    ListOption option = (ListOption)configOption;
                    Pair<Boolean, ConfigParsingException> result = option.editList(message.input, message.listIndex, message.isEdit);
                    if (!((Boolean)result.getFirst()).booleanValue()) {
                        LightmansCurrency.PROXY.sendClientMessage((Component)EasyText.translatable("command.lightmanscurrency.lcconfig.edit.fail.parse", ((ConfigParsingException)result.getSecond()).getMessage()).m_130940_(ChatFormatting.RED));
                        return;
                    }
                    if (!message.isEdit) {
                        LightmansCurrency.PROXY.sendClientMessage((Component)EasyText.translatable("command.lightmanscurrency.lcconfig.edit.list.remove.success", message.option + "[" + message.listIndex + "]"));
                    }
                    if ((listIndex = message.listIndex) < 0) {
                        listIndex = ((List)option.get()).size() - 1;
                    }
                    LightmansCurrency.PROXY.sendClientMessage((Component)EasyText.translatable("command.lightmanscurrency.lcconfig.edit.success", message.option + "[" + listIndex + "]", message.input));
                    return;
                }
                LightmansCurrency.PROXY.sendClientMessage((Component)EasyText.translatable("command.lightmanscurrency.lcconfig.edit.fail.missing", new Object[0]).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

