/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.config;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class SPacketEditConfig
extends ServerToClientPacket {
    public static final CustomPacket.Handler<SPacketEditConfig> HANDLER = new H();
    private final String fileName;
    private final String option;
    private final String input;

    public SPacketEditConfig(@Nonnull String fileName, @Nonnull String option, @Nonnull String input) {
        this.fileName = fileName;
        this.option = option;
        this.input = input;
    }

    @Override
    public void encode(@Nonnull FriendlyByteBuf buffer) {
        buffer.m_130070_(this.fileName);
        buffer.m_130070_(this.option);
        buffer.writeInt(this.input.length());
        buffer.m_130072_(this.input, this.input.length());
    }

    private static class H
    extends CustomPacket.Handler<SPacketEditConfig> {
        private H() {
        }

        @Override
        @Nonnull
        public SPacketEditConfig decode(@Nonnull FriendlyByteBuf buffer) {
            String fileName = buffer.m_130277_();
            String option = buffer.m_130277_();
            int inputLength = buffer.readInt();
            return new SPacketEditConfig(fileName, option, buffer.m_130136_(inputLength));
        }

        @Override
        protected void handle(@Nonnull SPacketEditConfig message, @Nullable ServerPlayer sender) {
            for (ConfigFile file : ConfigFile.getAvailableFiles()) {
                if (!file.isClientOnly() || !file.getFileName().equals(message.fileName)) continue;
                Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
                if (optionMap.containsKey(message.option)) {
                    ConfigOption<?> option = optionMap.get(message.option);
                    Pair<Boolean, ConfigParsingException> result = option.load(message.input, ConfigOption.LoadSource.COMMAND);
                    if (!((Boolean)result.getFirst()).booleanValue()) {
                        LightmansCurrency.PROXY.sendClientMessage((Component)EasyText.translatable("command.lightmanscurrency.lcconfig.edit.fail.parse", ((ConfigParsingException)result.getSecond()).getMessage()).m_130940_(ChatFormatting.RED));
                        return;
                    }
                    LightmansCurrency.PROXY.sendClientMessage((Component)EasyText.translatable("command.lightmanscurrency.lcconfig.edit.success", message.option, message.input));
                    return;
                }
                LightmansCurrency.PROXY.sendClientMessage((Component)EasyText.translatable("command.lightmanscurrency.lcconfig.edit.fail.missing", new Object[0]).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

