/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.tconstruct;

import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.datagen.util.WoodData;
import io.github.lightman314.lightmanscurrency.datagen.util.WoodDataHelper;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.MaterialColor;

public class TinkersCustomWoodTypes {
    private static final String MODID = "tconstruct";
    public static final WoodType GREENHEART = WoodType.builder("greenheart", "tconstruct").ofName("Greenheart").ofColor(MaterialColor.f_76417_).build();
    public static final WoodType SKYROOT = WoodType.builder("skyroot", "tconstruct").ofName("Skyroot").ofColor(MaterialColor.f_76421_).build();
    public static final WoodType BLOODSHROOM = WoodType.builder("bloodshroom", "tconstruct").ofName("Bloodshroom").ofColor(MaterialColor.f_76364_).build();
    public static final WoodType ENDERBARK = WoodType.builder("enderbark", "tconstruct").ofName("Enderbark").ofColor(MaterialColor.f_76364_).build();
    public static final WoodType LAVAWOOD = WoodType.builder("lavawood", "tconstruct").ofName("Lavawood").ofColor(MaterialColor.f_76413_).withAttributes(WoodType.Attributes.PLANKS_AND_SLAB_ONLY).build();
    public static final WoodType BLAZEWOOD = WoodType.builder("blazewood", "tconstruct").ofName("Blazewood").ofColor(MaterialColor.f_76413_).withAttributes(WoodType.Attributes.PLANKS_AND_SLAB_ONLY).build();
    public static final WoodType NAHUATL = WoodType.builder("nahuatl", "tconstruct").ofName("Nahuatl").ofColor(MaterialColor.f_76365_).withAttributes(WoodType.Attributes.PLANKS_AND_SLAB_ONLY).build();

    public static void setupWoodTypes() {
        TinkersCustomWoodTypes.setupType(GREENHEART);
        TinkersCustomWoodTypes.setupType(SKYROOT);
        TinkersCustomWoodTypes.setupType(BLOODSHROOM);
        TinkersCustomWoodTypes.setupType(ENDERBARK);
        TinkersCustomWoodTypes.setupSimpleType(LAVAWOOD);
        TinkersCustomWoodTypes.setupSimpleType(BLAZEWOOD);
        WoodDataHelper.register(NAHUATL, WoodData.of2(null, TinkersCustomWoodTypes.getSupplier("nahuatl", null), TinkersCustomWoodTypes.getSupplier("nahuatl", "slab"), null, null, new ResourceLocation(MODID, "block/wood/nahuatl")));
    }

    private static void setupType(@Nonnull WoodType type) {
        WoodDataHelper.register(type, WoodData.of2(TinkersCustomWoodTypes.getSupplier(type.id, "log"), TinkersCustomWoodTypes.getSupplier(type.id, "planks"), TinkersCustomWoodTypes.getSupplier(type.id, "planks_slab"), new ResourceLocation(MODID, "block/wood/" + type.id + "/log"), new ResourceLocation(MODID, "block/wood/" + type.id + "/log_top"), new ResourceLocation(MODID, "block/wood/" + type.id + "/planks")));
    }

    private static void setupSimpleType(@Nonnull WoodType type) {
        WoodDataHelper.register(type, WoodData.of2(null, TinkersCustomWoodTypes.getSupplier(type.id, null), TinkersCustomWoodTypes.getSupplier(type.id, "slab"), null, null, new ResourceLocation(MODID, "block/wood/" + type.id)));
    }

    private static Supplier<? extends ItemLike> getSupplier(@Nonnull String name, @Nullable String type) {
        return WoodDataHelper.supplier(new ResourceLocation(MODID, name + (String)(type != null ? "_" + type : "")));
    }
}

