/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.quark;

import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.datagen.util.WoodData;
import io.github.lightman314.lightmanscurrency.datagen.util.WoodDataHelper;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.MaterialColor;
import vazkii.quark.base.handler.WoodSetHandler;
import vazkii.quark.content.building.module.BambooBackportModule;
import vazkii.quark.content.world.module.AncientWoodModule;
import vazkii.quark.content.world.module.AzaleaWoodModule;
import vazkii.quark.content.world.module.BlossomTreesModule;

public class QuarkCustomWoodTypes {
    private static final String MODID = "quark";
    public static final WoodType ANCIENT = WoodType.builder("ancient", "quark").ofColor(MaterialColor.f_76372_).ofName("Ancient").build();
    public static final WoodType AZALEA = WoodType.builder("azalea", "quark").ofColor(MaterialColor.f_76417_).ofName("Azalea").build();
    public static final WoodType BLOSSOM = WoodType.builder("blossom", "quark").ofColor(MaterialColor.f_76364_).ofName("Blossom").build();
    public static final WoodType BAMBOO = WoodType.builder("bamboo", "quark").ofColor(MaterialColor.f_76416_).ofName("Bamboo").build();

    public static void setupWoodTypes() {
        QuarkCustomWoodTypes.registerSet(ANCIENT, () -> AncientWoodModule.woodSet);
        QuarkCustomWoodTypes.registerSet(AZALEA, () -> AzaleaWoodModule.woodSet);
        QuarkCustomWoodTypes.registerSet(BLOSSOM, () -> BlossomTreesModule.woodSet);
        QuarkCustomWoodTypes.registerBamboo(() -> BambooBackportModule.woodSet);
    }

    private static void registerSet(@Nonnull WoodType type, @Nonnull Supplier<WoodSetHandler.WoodSet> set) {
        WoodDataHelper.register(type, WoodData.of2(QuarkCustomWoodTypes.log(set), QuarkCustomWoodTypes.plank(set), QuarkCustomWoodTypes.slab(type), "quark:block/" + type.id + "_log", "quark:block/" + type.id + "_log_top", "quark:block/" + type.id + "_planks"));
    }

    private static void registerBamboo(@Nonnull Supplier<WoodSetHandler.WoodSet> set) {
        WoodDataHelper.register(BAMBOO, WoodData.of2(WoodDataHelper.supplier(new ResourceLocation(MODID, "bamboo_block")), QuarkCustomWoodTypes.plank(set), QuarkCustomWoodTypes.slab(BAMBOO), "quark:block/bamboo_block", "quark:block/bamboo_block_top", "quark:block/bamboo_planks"));
    }

    private static Supplier<ItemLike> log(@Nonnull Supplier<WoodSetHandler.WoodSet> set) {
        return () -> {
            WoodSetHandler.WoodSet s = (WoodSetHandler.WoodSet)set.get();
            if (s == null) {
                return null;
            }
            return s.log;
        };
    }

    private static Supplier<ItemLike> plank(@Nonnull Supplier<WoodSetHandler.WoodSet> set) {
        return () -> {
            WoodSetHandler.WoodSet s = (WoodSetHandler.WoodSet)set.get();
            if (s == null) {
                return null;
            }
            return s.planks;
        };
    }

    private static Supplier<? extends ItemLike> slab(@Nonnull WoodType type) {
        return WoodDataHelper.supplier(new ResourceLocation(MODID, type.id + "_planks_slab"));
    }
}

