/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.jeiplugin;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.crafting.CoinMintRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.RecipeValidator;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.menus.MintMenu;
import io.github.lightman314.lightmanscurrency.common.menus.TicketStationMenu;
import io.github.lightman314.lightmanscurrency.integration.jeiplugin.CoinMintCategory;
import io.github.lightman314.lightmanscurrency.integration.jeiplugin.TicketStationCategory;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class LCJeiPlugin
implements IModPlugin {
    public static final RecipeType<CoinMintRecipe> COIN_MINT_TYPE = RecipeType.create((String)"lightmanscurrency", (String)"coin_mint", CoinMintRecipe.class);
    public static final RecipeType<TicketStationRecipe> TICKET_TYPE = RecipeType.create((String)"lightmanscurrency", (String)"ticket_station", TicketStationRecipe.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("lightmanscurrency", "lightmanscurrency");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CoinMintCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new TicketStationCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<CoinMintRecipe> mintRecipes = RecipeValidator.getAllMintRecipes((Level)Minecraft.m_91087_().f_91073_);
        registration.addRecipes(COIN_MINT_TYPE, mintRecipes);
        List<TicketStationRecipe> ticketRecipes = RecipeValidator.getValidTicketStationRecipes((Level)Minecraft.m_91087_().f_91073_);
        registration.addRecipes(TICKET_TYPE, ticketRecipes);
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.TICKET_STUB.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{EasyText.translatable("lightmanscurrency.jei.info.ticket_stub", new Object[0])});
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.COIN_MINT.get()), new RecipeType[]{COIN_MINT_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.TICKET_STATION.get()), new RecipeType[]{TICKET_TYPE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(MintMenu.class, (MenuType)ModMenus.MINT.get(), COIN_MINT_TYPE, 0, 1, 2, 36);
        registration.addRecipeTransferHandler(TicketStationMenu.class, (MenuType)ModMenus.TICKET_MACHINE.get(), TICKET_TYPE, 0, 2, 3, 36);
    }
}

