/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.byg;

import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.datagen.util.WoodData;
import io.github.lightman314.lightmanscurrency.datagen.util.WoodDataHelper;
import java.util.function.Supplier;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.MaterialColor;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.block.BYGWoodTypes;

public class BYGCustomWoodTypes {
    private static final String MODID = "byg";
    public static final WoodType ASPEN = WoodType.builder("aspen", "byg").ofName("Aspen").ofColor(MaterialColor.f_76376_).build();
    public static final WoodType BAOBAB = WoodType.builder("baobab", "byg").ofName("Baobab").ofColor(MaterialColor.f_76385_).build();
    public static final WoodType IMBUED_BLUE_ENCHANTED = WoodType.builder("imbued_blue_enchanted", "byg").ofName("Imbued Blue Enchanted").ofColor(MaterialColor.f_76361_).withAttributes(WoodType.Attributes.LOG_ONLY).build();
    public static final WoodType BLUE_ENCHANTED = WoodType.builder("blue_enchanted", "byg").ofName("Blue Enchanted").ofColor(MaterialColor.f_76361_).build();
    public static final WoodType BULBIS = WoodType.builder("bulbis", "byg").ofName("Bulbis").ofColor(MaterialColor.f_76361_).build();
    public static final WoodType CHERRY = WoodType.builder("cherry", "byg").ofName("Cherry").ofColor(MaterialColor.f_76411_).build();
    public static final WoodType CIKA = WoodType.builder("cika", "byg").ofName("Cika").ofColor(MaterialColor.f_76373_).build();
    public static final WoodType CYPRESS = WoodType.builder("cypress", "byg").ofName("Cypress").ofColor(MaterialColor.f_76377_).build();
    public static final WoodType EBONY = WoodType.builder("ebony", "byg").ofName("Ebony").ofColor(MaterialColor.f_76363_).build();
    public static final WoodType ETHER = WoodType.builder("ether", "byg").ofName("Ether").ofColor(MaterialColor.f_76421_).build();
    public static final WoodType FIR = WoodType.builder("fir", "byg").ofName("Fir").ofColor(MaterialColor.f_76363_).build();
    public static final WoodType IMBUED_GREEN_ENCHANTED = WoodType.builder("imbued_green_enchanted", "byg").ofName("Imbued Green Enchanted").ofColor(MaterialColor.f_76363_).withAttributes(WoodType.Attributes.LOG_ONLY).build();
    public static final WoodType GREEN_ENCHANTED = WoodType.builder("green_enchanted", "byg").ofName("Green Enchanted").ofColor(MaterialColor.f_76363_).build();
    public static final WoodType HOLLY = WoodType.builder("holly", "byg").ofName("Holly").ofColor(MaterialColor.f_76385_).build();
    public static final WoodType FUNGAL_IMPARIUS = WoodType.builder("fungal_imparius", "byg").ofName("Fungal Imparius").ofColor(MaterialColor.f_76361_).withAttributes(WoodType.Attributes.LOG_ONLY).build();
    public static final WoodType IMPARIUS = WoodType.builder("imparius", "byg").ofName("Imparius").ofColor(MaterialColor.f_76361_).build();
    public static final WoodType LAMENT = WoodType.builder("lament", "byg").ofName("Lament").ofColor(MaterialColor.f_76414_).build();
    public static final WoodType JACARANDA = WoodType.builder("jacaranda", "byg").ofName("Jacaranda").ofColor(MaterialColor.f_76382_).build();
    public static final WoodType MAHOGANY = WoodType.builder("mahogany", "byg").ofName("Mahogany").ofColor(MaterialColor.f_76363_).build();
    public static final WoodType WHITE_MANGROVE = WoodType.builder("white_mangrove", "byg").ofName("White Mangrove").ofColor(MaterialColor.f_76363_).build();
    public static final WoodType MAPLE = WoodType.builder("maple", "byg").ofName("Maple").ofColor(MaterialColor.f_76363_).build();
    public static final WoodType IMBUED_NIGHTSHADE = WoodType.builder("imbued_nightshade", "byg").ofName("Imbued Nightshade").ofColor(MaterialColor.f_76413_).withAttributes(WoodType.Attributes.LOG_ONLY).build();
    public static final WoodType NIGHTSHADE = WoodType.builder("nightshade", "byg").ofName("Nightshade").ofColor(MaterialColor.f_76413_).build();
    public static final WoodType PALM = WoodType.builder("palm", "byg").ofName("Palm").ofColor(MaterialColor.f_76363_).build();
    public static final WoodType PALO_VERDE = WoodType.builder("palo_verde", "byg").ofName("Palo Verde").ofColor(MaterialColor.f_76363_).withAttributes(WoodType.Attributes.LOG_ONLY).build();
    public static final WoodType PINE = WoodType.builder("pine", "byg").ofName("Pine").ofColor(MaterialColor.f_76385_).build();
    public static final WoodType RAINBOW_EUCALYPTUS = WoodType.builder("rainbow_eucalyptus", "byg").ofName("Rainbow Eucalyptus").ofColor(MaterialColor.f_76363_).build();
    public static final WoodType REDWOOD = WoodType.builder("redwood", "byg").ofName("Redwood").ofColor(MaterialColor.f_76363_).build();
    public static final WoodType SKYRIS = WoodType.builder("skyris", "byg").ofName("Skyris").ofColor(MaterialColor.f_76418_).build();
    public static final WoodType WILLOW = WoodType.builder("willow", "byg").ofName("Willow").ofColor(MaterialColor.f_76385_).build();
    public static final WoodType WITCH_HAZEL = WoodType.builder("witch_hazel", "byg").ofName("Witch Hazel").ofColor(MaterialColor.f_76413_).build();
    public static final WoodType ZELKOVA = WoodType.builder("zelkova", "byg").ofName("Zelkova").ofColor(MaterialColor.f_76386_).build();
    public static final WoodType SYTHIAN = WoodType.builder("sythian", "byg").ofName("Sythian").ofColor(MaterialColor.f_76411_).build();
    public static final WoodType EMBUR = WoodType.builder("embur", "byg").ofName("Embur").ofColor(MaterialColor.f_76411_).build();
    public static final WoodType WITHERING_OAK = WoodType.builder("withering_oak", "byg").ofName("Withering Oak").ofColor(MaterialColor.f_76411_).withAttributes(WoodType.Attributes.LOG_ONLY).build();

    public static void setupWoodTypes() {
        BYGCustomWoodTypes.setupWoodType(ASPEN, BYGWoodTypes.ASPEN, "byg:block/aspen/log", "byg:block/aspen/log_top", "byg:block/aspen/planks");
        BYGCustomWoodTypes.setupWoodType(BAOBAB, BYGWoodTypes.BAOBAB, "byg:block/baobab/log", "byg:block/baobab/log_top", "byg:block/baobab/planks");
        BYGCustomWoodTypes.setupWoodTypeWithLog(IMBUED_BLUE_ENCHANTED, BYGWoodTypes.BLUE_ENCHANTED, () -> BYGBlocks.IMBUED_BLUE_ENCHANTED_LOG, "byg:block/blue_enchanted/log2", "byg:block/blue_enchanted/log_top", "byg:block/blue_enchanted/planks");
        BYGCustomWoodTypes.setupWoodType(BLUE_ENCHANTED, BYGWoodTypes.BLUE_ENCHANTED, "byg:block/blue_enchanted/log", "byg:block/blue_enchanted/log_top", "byg:block/blue_enchanted/planks");
        BYGCustomWoodTypes.setupWoodType(BULBIS, BYGWoodTypes.BULBIS, "byg:block/bulbis/log", "byg:block/bulbis/log_top", "byg:block/bulbis/planks");
        BYGCustomWoodTypes.setupWoodType(CHERRY, BYGWoodTypes.CHERRY, "byg:block/cherry/log", "byg:block/cherry/log_top", "byg:block/cherry/planks");
        BYGCustomWoodTypes.setupWoodType(CIKA, BYGWoodTypes.CIKA, "byg:block/cika/log", "byg:block/cika/log_top", "byg:block/cika/planks");
        BYGCustomWoodTypes.setupWoodType(CYPRESS, BYGWoodTypes.CYPRESS, "byg:block/cypress/log", "byg:block/cypress/log_top", "byg:block/cypress/planks");
        BYGCustomWoodTypes.setupWoodType(EBONY, BYGWoodTypes.EBONY, "byg:block/ebony/log", "byg:block/ebony/log_top", "byg:block/ebony/planks");
        BYGCustomWoodTypes.setupWoodType(ETHER, BYGWoodTypes.ETHER, "byg:block/ether/log", "byg:block/ether/log_top", "byg:block/ether/planks");
        BYGCustomWoodTypes.setupWoodType(FIR, BYGWoodTypes.FIR, "byg:block/fir/log", "byg:block/fir/log_top", "byg:block/fir/planks");
        BYGCustomWoodTypes.setupWoodTypeWithLog(IMBUED_GREEN_ENCHANTED, BYGWoodTypes.GREEN_ENCHANTED, () -> BYGBlocks.IMBUED_GREEN_ENCHANTED_LOG, "byg:block/green_enchanted/log2", "byg:block/green_enchanted/log_top", "byg:block/green_enchanted/planks");
        BYGCustomWoodTypes.setupWoodType(GREEN_ENCHANTED, BYGWoodTypes.GREEN_ENCHANTED, "byg:block/green_enchanted/log", "byg:block/green_enchanted/log_top", "byg:block/green_enchanted/planks");
        BYGCustomWoodTypes.setupWoodType(HOLLY, BYGWoodTypes.HOLLY, "byg:block/holly/log", "byg:block/holly/log_top", "byg:block/holly/planks");
        BYGCustomWoodTypes.setupWoodTypeWithLog(FUNGAL_IMPARIUS, BYGWoodTypes.IMPARIUS, () -> BYGBlocks.FUNGAL_IMPARIUS_STEM, "byg:block/fungal_imparius_stem", "byg:block/fungal_imparius_stem_top", "byg:block/imparius/planks");
        BYGCustomWoodTypes.setupWoodType(IMPARIUS, BYGWoodTypes.IMPARIUS, "byg:block/imparius/log", "byg:block/imparius/log_top", "byg:block/imparius/planks");
        BYGCustomWoodTypes.setupWoodType(LAMENT, BYGWoodTypes.LAMENT, "byg:block/lament/log", "byg:block/lament/log_top", "byg:block/lament/planks");
        BYGCustomWoodTypes.setupWoodType(JACARANDA, BYGWoodTypes.JACARANDA, "byg:block/jacaranda/log", "byg:block/jacaranda/log_top", "byg:block/jacaranda/planks");
        BYGCustomWoodTypes.setupWoodType(MAHOGANY, BYGWoodTypes.MAHOGANY, "byg:block/mahogany/log", "byg:block/mahogany/log_top", "byg:block/mahogany/planks");
        BYGCustomWoodTypes.setupWoodType(WHITE_MANGROVE, BYGWoodTypes.WHITE_MANGROVE, "byg:block/white_mangrove/log", "byg:block/white_mangrove/log_top", "byg:block/white_mangrove/planks");
        BYGCustomWoodTypes.setupWoodType(MAPLE, BYGWoodTypes.MAPLE, "byg:block/maple/log", "byg:block/maple/log_top", "byg:block/maple/planks");
        BYGCustomWoodTypes.setupWoodTypeWithLog(IMBUED_NIGHTSHADE, BYGWoodTypes.NIGHTSHADE, () -> BYGBlocks.IMBUED_NIGHTSHADE_LOG, "byg:block/imbued_nightshade_log", "byg:block/nightshade/log_top", "byg:block/nightshade/planks");
        BYGCustomWoodTypes.setupWoodType(NIGHTSHADE, BYGWoodTypes.NIGHTSHADE, "byg:block/nightshade/log", "byg:block/nightshade/log_top", "byg:block/nightshade/planks");
        BYGCustomWoodTypes.setupWoodType(PALM, BYGWoodTypes.PALM, "byg:block/palm/log", "byg:block/palm/log_top", "byg:block/palm/planks");
        WoodDataHelper.register(PALO_VERDE, WoodData.of2(() -> BYGBlocks.PALO_VERDE_LOG, () -> Items.f_42753_, () -> Items.f_41916_, "byg:block/palo_verde_log", "byg:block/palo_verde_log_top", "minecraft:block/birch_planks"));
        BYGCustomWoodTypes.setupWoodType(PINE, BYGWoodTypes.PINE, "byg:block/pine/log", "byg:block/pine/log_top", "byg:block/pine/planks");
        BYGCustomWoodTypes.setupWoodType(RAINBOW_EUCALYPTUS, BYGWoodTypes.RAINBOW_EUCALYPTUS, "byg:block/rainbow_eucalyptus/log", "byg:block/rainbow_eucalyptus/log_top", "byg:block/rainbow_eucalyptus/planks");
        BYGCustomWoodTypes.setupWoodType(REDWOOD, BYGWoodTypes.REDWOOD, "byg:block/redwood/log", "byg:block/redwood/log_top", "byg:block/redwood/planks");
        BYGCustomWoodTypes.setupWoodType(SKYRIS, BYGWoodTypes.SKYRIS, "byg:block/skyris/log", "byg:block/skyris/log_top", "byg:block/skyris/planks");
        BYGCustomWoodTypes.setupWoodType(WILLOW, BYGWoodTypes.WILLOW, "byg:block/willow/log", "byg:block/willow/log_top", "byg:block/willow/planks");
        BYGCustomWoodTypes.setupWoodType(WITCH_HAZEL, BYGWoodTypes.WITCH_HAZEL, "byg:block/witch_hazel/log", "byg:block/witch_hazel/log_top", "byg:block/witch_hazel/planks");
        BYGCustomWoodTypes.setupWoodType(ZELKOVA, BYGWoodTypes.ZELKOVA, "byg:block/zelkova/log", "byg:block/zelkova/log_top", "byg:block/zelkova/planks");
        BYGCustomWoodTypes.setupWoodType(SYTHIAN, BYGWoodTypes.SYTHIAN, "byg:block/sythian/log", "byg:block/sythian/log_top", "byg:block/sythian/planks");
        BYGCustomWoodTypes.setupWoodType(EMBUR, BYGWoodTypes.EMBUR, "byg:block/embur/log", "byg:block/embur/log_top", "byg:block/embur/planks");
        WoodDataHelper.register(WITHERING_OAK, WoodData.of2(() -> BYGBlocks.WITHERING_OAK_LOG, () -> Items.f_42647_, () -> Items.f_41914_, "byg:block/withering_oak_log", "byg:block/withering_oak_log_top", "minecraft:block/oak_planks"));
    }

    private static void setupWoodType(WoodType type, BYGWoodTypes bygType, String logSideTexture, String logTopTexture, String plankTexture) {
        WoodDataHelper.register(type, WoodData.of2(() -> ((BYGWoodTypes)bygType).log(), () -> ((BYGWoodTypes)bygType).planks(), () -> ((BYGWoodTypes)bygType).slab(), logSideTexture, logTopTexture, plankTexture));
    }

    private static void setupWoodTypeWithLog(WoodType type, BYGWoodTypes bygType, Supplier<ItemLike> customLog, String logSideTexture, String logTopTexture, String plankTexture) {
        WoodDataHelper.register(type, WoodData.of2(customLog, () -> ((BYGWoodTypes)bygType).planks(), () -> ((BYGWoodTypes)bygType).slab(), logSideTexture, logTopTexture, plankTexture));
    }
}

