/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.util;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.datagen.util.WoodData;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class WoodDataHelper {
    private static final Map<WoodType, WoodData> registeredData = new HashMap<WoodType, WoodData>();

    public static void register(@Nonnull WoodType type, @Nonnull WoodData data) {
        if (registeredData.containsKey(type)) {
            LightmansCurrency.LogError("Attempted to register a duplicate WoodData for type '" + type.id + "'!");
            return;
        }
        registeredData.put(type, Objects.requireNonNull(data));
    }

    @Nullable
    public static WoodData get(WoodType type) {
        return registeredData.get(type);
    }

    public static Supplier<? extends ItemLike> supplier(@Nonnull ResourceLocation itemID) {
        return () -> {
            ItemLike result = (ItemLike)ForgeRegistries.ITEMS.getValue(itemID);
            if (result == Items.f_41852_) {
                LightmansCurrency.LogError("Could not find " + itemID);
                return null;
            }
            return result;
        };
    }

    static {
        WoodDataHelper.register(WoodType.OAK, WoodData.of((ItemLike)Items.f_41837_, (ItemLike)Items.f_42647_, (ItemLike)Items.f_41914_, "minecraft:block/oak_log", "minecraft:block/oak_log_top", "minecraft:block/oak_planks"));
        WoodDataHelper.register(WoodType.SPRUCE, WoodData.of((ItemLike)Items.f_41838_, (ItemLike)Items.f_42700_, (ItemLike)Items.f_41915_, "minecraft:block/spruce_log", "minecraft:block/spruce_log_top", "minecraft:block/spruce_planks"));
        WoodDataHelper.register(WoodType.BIRCH, WoodData.of((ItemLike)Items.f_41839_, (ItemLike)Items.f_42753_, (ItemLike)Items.f_41916_, "minecraft:block/birch_log", "minecraft:block/birch_log_top", "minecraft:block/birch_planks"));
        WoodDataHelper.register(WoodType.JUNGLE, WoodData.of((ItemLike)Items.f_41840_, (ItemLike)Items.f_42794_, (ItemLike)Items.f_41917_, "minecraft:block/jungle_log", "minecraft:block/jungle_log_top", "minecraft:block/jungle_planks"));
        WoodDataHelper.register(WoodType.ACACIA, WoodData.of((ItemLike)Items.f_41841_, (ItemLike)Items.f_42795_, (ItemLike)Items.f_41918_, "minecraft:block/acacia_log", "minecraft:block/acacia_log_top", "minecraft:block/acacia_planks"));
        WoodDataHelper.register(WoodType.DARK_OAK, WoodData.of((ItemLike)Items.f_41842_, (ItemLike)Items.f_42796_, (ItemLike)Items.f_41919_, "minecraft:block/dark_oak_log", "minecraft:block/dark_oak_log_top", "minecraft:block/dark_oak_planks"));
        WoodDataHelper.register(WoodType.MANGROVE, WoodData.of((ItemLike)Items.f_220179_, (ItemLike)Items.f_220174_, (ItemLike)Items.f_220183_, "minecraft:block/mangrove_log", "minecraft:block/mangrove_log_top", "minecraft:block/mangrove_planks"));
        WoodDataHelper.register(WoodType.CRIMSON, WoodData.of((ItemLike)Items.f_41843_, (ItemLike)Items.f_42797_, (ItemLike)Items.f_41920_, "minecraft:block/crimson_stem", "minecraft:block/crimson_stem_top", "minecraft:block/crimson_planks"));
        WoodDataHelper.register(WoodType.WARPED, WoodData.of((ItemLike)Items.f_41844_, (ItemLike)Items.f_42798_, (ItemLike)Items.f_41921_, "minecraft:block/warped_stem", "minecraft:block/warped_stem_top", "minecraft:block/warped_planks"));
    }
}

