/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.mods;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.common.config.VillagerTradeModsOption;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.mods.ConfiguredTradeMod;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.mods.VillagerTradeMod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ForgeRegistries;

public class VillagerTradeMods {
    private final Map<String, ConfiguredTradeMod> modMap;

    private VillagerTradeMods(@Nonnull Builder builder) {
        HashMap temp = new HashMap();
        builder.dataMap.forEach((key, subBuilder) -> temp.put(key, subBuilder.build()));
        this.modMap = ImmutableMap.copyOf(temp);
    }

    public VillagerTradeMods(@Nonnull List<String> parseableData) {
        HashMap<String, ConfiguredTradeMod> temp = new HashMap<String, ConfiguredTradeMod>();
        for (String data : parseableData) {
            try {
                Pair<String, ConfiguredTradeMod> results = this.tryParseEntry(data);
                if (temp.containsKey(results.getFirst())) {
                    throw new ConfigParsingException("Duplicate profession type '" + (String)results.getFirst() + "' modded!");
                }
                temp.put((String)results.getFirst(), (ConfiguredTradeMod)results.getSecond());
            }
            catch (ConfigParsingException e) {
                LightmansCurrency.LogError("Error parsing '" + data + "' as a villager trade modification.", e);
            }
        }
        this.modMap = ImmutableMap.copyOf(temp);
    }

    public final List<String> writeToConfig() {
        ArrayList<String> data = new ArrayList<String>();
        this.modMap.forEach((key, entry) -> {
            StringBuilder builder = new StringBuilder((String)key).append("-");
            entry.write(builder);
            data.add(builder.toString());
        });
        return data;
    }

    private Pair<String, ConfiguredTradeMod> tryParseEntry(@Nonnull String entry) throws ConfigParsingException {
        String[] split = entry.split("-", 2);
        if (split.length < 2) {
            throw new ConfigParsingException("Missing '-' dividers!");
        }
        String profession = split[0];
        LightmansCurrency.LogDebug("Attempting to parse entries for '" + profession + "' profession.");
        ConfiguredTradeMod mod = ConfiguredTradeMod.tryParse(split[1], false);
        return Pair.of((Object)profession, (Object)mod);
    }

    public final VillagerTradeMod getModFor(@Nonnull String trader) {
        if (this.modMap.containsKey(trader)) {
            return this.modMap.get(trader);
        }
        return (VillagerTradeMod)LCConfig.COMMON.defaultEmeraldReplacementMod.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, ConfiguredTradeMod.ModBuilder> dataMap = new HashMap<String, ConfiguredTradeMod.ModBuilder>();

        private Builder() {
        }

        @Nonnull
        public ConfiguredTradeMod.ModBuilder forProfession(@Nonnull VillagerProfession profession) {
            return this.forProfession(ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)profession));
        }

        public ConfiguredTradeMod.ModBuilder forProfession(@Nonnull ResourceLocation profession) {
            return this.forProfession(profession.toString());
        }

        @Nonnull
        public ConfiguredTradeMod.ModBuilder forProfession(@Nonnull String profession) {
            if (!this.dataMap.containsKey(profession)) {
                this.dataMap.put(profession, ConfiguredTradeMod.builder(this));
            }
            return this.dataMap.get(profession);
        }

        @Nonnull
        public VillagerTradeMods build() {
            return new VillagerTradeMods(this);
        }

        @Nonnull
        public VillagerTradeModsOption buildOption() {
            return VillagerTradeModsOption.create((NonNullSupplier<VillagerTradeMods>)((NonNullSupplier)this::build));
        }
    }
}

