/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.villager_merchant.listings;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.ItemListingSerializer;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SimpleTrade
implements VillagerTrades.ItemListing {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "simple");
    public static final Serializer SERIALIZER = new Serializer();
    protected final ItemStack price;
    protected final ItemStack price2;
    protected final ItemStack forSale;
    protected final int maxTrades;
    protected final int xp;
    protected final float priceMult;
    protected static final int MAX_TRADES = 12;
    protected static final float PRICE_MULT = 0.05f;

    public SimpleTrade(ItemLike priceItem, int priceCount, ItemLike forsaleItem) {
        this(1, priceItem, priceCount, forsaleItem);
    }

    public SimpleTrade(ItemLike priceItem, int priceCount, ItemLike forsaleItem, int forsaleCount) {
        this(1, priceItem, priceCount, forsaleItem, forsaleCount);
    }

    public SimpleTrade(int xpValue, ItemLike priceItem, int priceCount, ItemLike forsaleItem) {
        this(xpValue, priceItem, priceCount, forsaleItem, 1);
    }

    public SimpleTrade(int xpValue, ItemLike priceItem, int priceCount, ItemLike forsaleItem, int forsaleCount) {
        this(new ItemStack(priceItem, priceCount), ItemStack.f_41583_, new ItemStack(forsaleItem, forsaleCount), 12, xpValue, 0.05f);
    }

    public SimpleTrade(ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem) {
        this(1, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem);
    }

    public SimpleTrade(ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem, int forsaleCount) {
        this(1, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem, forsaleCount);
    }

    public SimpleTrade(int xpValue, ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem) {
        this(xpValue, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem, 1);
    }

    public SimpleTrade(int xpValue, ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem, int forsaleCount) {
        this(new ItemStack(priceItem1, priceCount1), new ItemStack(priceItem2, priceCount2), new ItemStack(forsaleItem, forsaleCount), 12, xpValue, 0.05f);
    }

    public SimpleTrade(int xpValue, ItemLike priceItem1, int priceCount1, ItemStack forSaleItem) {
        this(new ItemStack(priceItem1, priceCount1), ItemStack.f_41583_, forSaleItem, 12, xpValue, 0.05f);
    }

    public SimpleTrade(int xpValue, ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemStack forSaleItem) {
        this(new ItemStack(priceItem1, priceCount1), new ItemStack(priceItem2, priceCount2), forSaleItem, 12, xpValue, 0.05f);
    }

    public SimpleTrade(ItemStack price, ItemStack forSale, int xp) {
        this(price, ItemStack.f_41583_, forSale, 12, xp, 0.05f);
    }

    public SimpleTrade(ItemStack price, ItemStack price2, ItemStack forSale, int maxTrades, int xp, float priceMult) {
        this.price = price;
        this.price2 = price2;
        this.forSale = forSale;
        this.maxTrades = maxTrades;
        this.xp = xp;
        this.priceMult = priceMult;
    }

    public static ItemStack createSuspiciousStew(MobEffect effect, int duration) {
        ItemStack stew = new ItemStack((ItemLike)Items.f_42718_, 1);
        SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)effect, (int)duration);
        return stew;
    }

    @Nullable
    public MerchantOffer m_213663_(@NotNull Entity villager, @NotNull RandomSource random) {
        return new MerchantOffer(this.price, this.price2, this.forSale, this.maxTrades, this.xp, this.priceMult);
    }

    public static class Serializer
    implements ItemListingSerializer.IItemListingSerializer,
    ItemListingSerializer.IItemListingDeserializer {
        private Serializer() {
        }

        @Override
        public ResourceLocation getType() {
            return TYPE;
        }

        @Override
        public JsonObject serializeInternal(JsonObject json, VillagerTrades.ItemListing trade) {
            if (trade instanceof SimpleTrade) {
                SimpleTrade t = (SimpleTrade)trade;
                json.add("Price", (JsonElement)FileUtil.convertItemStack(t.price));
                if (!t.price2.m_41619_()) {
                    json.add("Price2", (JsonElement)FileUtil.convertItemStack(t.price2));
                }
                json.add("Sell", (JsonElement)FileUtil.convertItemStack(t.forSale));
                json.addProperty("MaxTrades", (Number)t.maxTrades);
                json.addProperty("XP", (Number)t.xp);
                json.addProperty("PriceMult", (Number)Float.valueOf(t.priceMult));
                return json;
            }
            return null;
        }

        @Override
        public VillagerTrades.ItemListing deserialize(JsonObject json) throws JsonSyntaxException, ResourceLocationException {
            ItemStack price = FileUtil.parseItemStack(GsonHelper.m_13930_((JsonObject)json, (String)"Price"));
            ItemStack price2 = json.has("Price2") ? FileUtil.parseItemStack(GsonHelper.m_13930_((JsonObject)json, (String)"Price2")) : ItemStack.f_41583_;
            ItemStack forSale = FileUtil.parseItemStack(GsonHelper.m_13930_((JsonObject)json, (String)"Sell"));
            int maxTrades = GsonHelper.m_13927_((JsonObject)json, (String)"MaxTrades");
            int xp = GsonHelper.m_13927_((JsonObject)json, (String)"XP");
            float priceMult = GsonHelper.m_13915_((JsonObject)json, (String)"PriceMult");
            return new SimpleTrade(price, price2, forSale, maxTrades, xp, priceMult);
        }
    }
}

