/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.villager_merchant.listings;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.ItemListingSerializer;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class ItemsForMapTrade
implements VillagerTrades.ItemListing {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "items_for_map");
    public static final Serializer SERIALIZER = new Serializer();
    protected final ItemStack price1;
    protected final ItemStack price2;
    protected final TagKey<Structure> destination;
    protected final String displayName;
    protected final MapDecoration.Type mapDecorationType;
    protected final int maxTrades;
    protected final int xp;
    protected final float priceMult;

    public ItemsForMapTrade(ItemStack price, TagKey<Structure> destination, String displayName, MapDecoration.Type mapDecorationType, int maxUses, int xpValue) {
        this(price, ItemStack.f_41583_, destination, displayName, mapDecorationType, maxUses, xpValue, 0.05f);
    }

    public ItemsForMapTrade(ItemStack price1, ItemStack price2, TagKey<Structure> destination, String displayName, MapDecoration.Type mapDecorationType, int maxUses, int xpValue, float priceMult) {
        this.price1 = price1;
        this.price2 = price2;
        this.destination = destination;
        this.displayName = displayName;
        this.mapDecorationType = mapDecorationType;
        this.maxTrades = maxUses;
        this.xp = xpValue;
        this.priceMult = priceMult;
    }

    public MerchantOffer m_213663_(@Nonnull Entity trader, @Nonnull RandomSource rand) {
        Level level;
        if (trader == null || !((level = trader.f_19853_) instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverworld = (ServerLevel)level;
        BlockPos blockPos = serverworld.m_215011_(this.destination, trader.m_20183_(), 100, true);
        if (blockPos != null) {
            ItemStack itemstack = MapItem.m_42886_((Level)serverworld, (int)blockPos.m_123341_(), (int)blockPos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
            MapItem.m_42897_((Level)serverworld, (ItemStack)itemstack);
            MapItemSavedData.m_77925_((ItemStack)itemstack, (BlockPos)blockPos, (String)"+", (MapDecoration.Type)this.mapDecorationType);
            itemstack.m_41714_((Component)Component.m_237115_((String)this.displayName));
            return new MerchantOffer(this.price1, this.price2, itemstack, this.maxTrades, this.xp, this.priceMult);
        }
        return null;
    }

    public static class Serializer
    implements ItemListingSerializer.IItemListingSerializer,
    ItemListingSerializer.IItemListingDeserializer {
        private Serializer() {
        }

        @Override
        public ResourceLocation getType() {
            return TYPE;
        }

        @Override
        public JsonObject serializeInternal(JsonObject json, VillagerTrades.ItemListing trade) {
            if (trade instanceof ItemsForMapTrade) {
                ItemsForMapTrade t = (ItemsForMapTrade)trade;
                json.add("Price", (JsonElement)FileUtil.convertItemStack(t.price1));
                if (!t.price2.m_41619_()) {
                    json.add("Price2", (JsonElement)FileUtil.convertItemStack(t.price2));
                }
                json.addProperty("Destination", t.destination.f_203868_().toString());
                json.addProperty("MapName", t.displayName);
                json.addProperty("Decoration", t.mapDecorationType.toString());
                json.addProperty("MaxTrades", (Number)t.maxTrades);
                json.addProperty("XP", (Number)t.xp);
                json.addProperty("PriceMult", (Number)Float.valueOf(t.priceMult));
                return json;
            }
            return null;
        }

        @Override
        public VillagerTrades.ItemListing deserialize(JsonObject json) throws JsonSyntaxException, ResourceLocationException {
            ItemStack price1 = FileUtil.parseItemStack(GsonHelper.m_13930_((JsonObject)json, (String)"Price"));
            ItemStack price2 = json.has("Price2") ? FileUtil.parseItemStack(GsonHelper.m_13930_((JsonObject)json, (String)"Price2")) : ItemStack.f_41583_;
            TagKey destination = TagKey.m_203882_((ResourceKey)Registry.f_235725_, (ResourceLocation)new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"Destination")));
            String displayName = GsonHelper.m_13906_((JsonObject)json, (String)"MapName");
            MapDecoration.Type mapDecorationType = (MapDecoration.Type)EnumUtil.enumFromString((String)GsonHelper.m_13906_((JsonObject)json, (String)"Decoration"), (Enum[])MapDecoration.Type.values(), (Enum)MapDecoration.Type.FRAME);
            int maxTrades = GsonHelper.m_13927_((JsonObject)json, (String)"MaxTrades");
            int xp = GsonHelper.m_13927_((JsonObject)json, (String)"XP");
            float priceMult = GsonHelper.m_13915_((JsonObject)json, (String)"PriceMult");
            return new ItemsForMapTrade(price1, price2, (TagKey<Structure>)destination, displayName, mapDecorationType, maxTrades, xp, priceMult);
        }
    }
}

