/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.villager_merchant;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModEnchantments;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.CustomProfessions;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.CustomVillagerTradeData;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.EnchantedBookForCoinsTrade;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.EnchantedItemForCoinsTrade;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.ItemsForMapTrade;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.RandomTrade;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.SimpleTrade;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.configured.ConfiguredItemListing;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class VillagerTradeManager {
    public static final ResourceLocation BANKER_ID = new ResourceLocation("lightmanscurrency", "banker");
    public static final ResourceLocation CASHIER_ID = new ResourceLocation("lightmanscurrency", "cashier");
    public static final String WANDERING_TRADER_ID = "minecraft:wandering_trader";
    private static final float ENCHANTMENT_PRICE_MODIFIER = 0.25f;

    public static void registerDefaultTrades() {
        CustomVillagerTradeData.registerDefaultFile(BANKER_ID, (Map<Integer, List<VillagerTrades.ItemListing>>)ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)new SimpleTrade(2, (ItemLike)ModItems.COIN_IRON.get(), 5, (ItemLike)ModBlocks.COIN_MINT.get()), (Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_GOLD.get()), LCTags.Items.NETWORK_TERMINAL, 12, 1, 0.05f), (Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 8), LCTags.Items.ATM, 12, 1, 0.05f), (Object)new SimpleTrade(1, (ItemLike)ModItems.COIN_IRON.get(), 5, (ItemLike)ModBlocks.CASH_REGISTER.get()), (Object)new SimpleTrade(1, (ItemLike)ModItems.COIN_IRON.get(), 4, (ItemLike)ModItems.COIN_COPPER.get(), 8, (ItemLike)ModItems.TRADING_CORE.get())), (Object)2, (Object)ImmutableList.of((Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), LCTags.Items.TRADER_SHELF, 12, 5, 0.05f), (Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 14), LCTags.Items.TRADER_SHELF_2x2, 12, 5, 0.05f), (Object)new SimpleTrade(5, (ItemLike)ModItems.COIN_IRON.get(), 15, (ItemLike)ModBlocks.COIN_CHEST.get()), (Object)new SimpleTrade(5, (ItemLike)ModItems.COIN_IRON.get(), 10, (ItemLike)ModBlocks.DISPLAY_CASE.get())), (Object)3, (Object)ImmutableList.of((Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 15), LCTags.Items.TRADER_CARD_DISPLAY, 12, 10, 0.05f), (Object)new SimpleTrade(10, (ItemLike)ModItems.COIN_IRON.get(), 20, (ItemLike)ModBlocks.ARMOR_DISPLAY.get()), (Object)new SimpleTrade(10, (ItemLike)ModItems.COIN_IRON.get(), 20, (ItemLike)ModBlocks.TICKET_KIOSK.get()), (Object)new SimpleTrade(10, (ItemLike)ModItems.COIN_IRON.get(), 15, (ItemLike)ModBlocks.ITEM_NETWORK_TRADER_1.get()), (Object)new SimpleTrade(10, (ItemLike)ModItems.COIN_IRON.get(), 10, (ItemLike)ModBlocks.TERMINAL.get())), (Object)4, (Object)ImmutableList.of((Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 25), LCTags.Items.TRADER_VENDING_MACHINE, 12, 15, 0.05f), (Object)new SimpleTrade(15, (ItemLike)ModItems.COIN_IRON.get(), 30, (ItemLike)ModBlocks.ITEM_NETWORK_TRADER_2.get()), (Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 30), LCTags.Items.TRADER_FREEZER, 12, 20, 0.05f), (Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 30), LCTags.Items.TRADER_SPECIALTY_BOOKSHELF, 12, 20, 0.05f), (Object)new SimpleTrade(20, (ItemLike)ModItems.COIN_DIAMOND.get(), 15, EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)ModEnchantments.MONEY_MENDING.get(), 1)))), (Object)5, (Object)ImmutableList.of((Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 25), LCTags.Items.TRADER_LARGE_VENDING_MACHINE, 12, 30, 0.05f), (Object)new SimpleTrade(30, (ItemLike)ModItems.COIN_GOLD.get(), 6, (ItemLike)ModBlocks.ITEM_NETWORK_TRADER_3.get()), (Object)new SimpleTrade(30, (ItemLike)ModItems.COIN_GOLD.get(), 10, (ItemLike)ModBlocks.ITEM_NETWORK_TRADER_4.get()), (Object)new SimpleTrade(30, (ItemLike)ModItems.COIN_GOLD.get(), 10, (ItemLike)ModBlocks.SLOT_MACHINE.get()), (Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 5), LCTags.Items.TRADER_INTERFACE, 12, 30, 0.05f), (Object)new SimpleTrade(30, (ItemLike)ModItems.COIN_DIAMOND.get(), 10, EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)ModEnchantments.MONEY_MENDING.get(), 1))))));
        CustomVillagerTradeData.registerDefaultFile(CASHIER_ID, (Map<Integer, List<VillagerTrades.ItemListing>>)ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 4), new ItemStack((ItemLike)ModItems.COIN_COPPER.get(), 5), new ItemStack((ItemLike)Items.f_42406_, 6), 16, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 7), new ItemStack((ItemLike)Items.f_42458_), 16, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 4), new ItemStack((ItemLike)Items.f_42574_), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 8), new ItemStack((ItemLike)Items.f_42412_, 16), 12, 1, 0.05f), (Object)new EnchantedBookForCoinsTrade(1), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 2), new ItemStack((ItemLike)Blocks.f_50078_), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get()), new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 5), new ItemStack((ItemLike)Items.f_42676_), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get()), new ItemStack((ItemLike)Items.f_42451_), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), new ItemStack((ItemLike)Items.f_42470_), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)Items.f_42471_), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 3), new ItemStack((ItemLike)Items.f_42468_), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 2), new ItemStack((ItemLike)Items.f_42469_), 12, 1, 0.05f), (Object[])new VillagerTrades.ItemListing[]{new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), new ItemStack((ItemLike)Items.f_42386_), 12, 1, 0.05f), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 3, (ItemLike)Items.f_42383_, 12, 1, 0.05f, 0.25), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get()), new ItemStack((ItemLike)Items.f_42428_), 12, 1, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get()), new ItemStack((ItemLike)Items.f_42426_), 12, 1, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get()), new ItemStack((ItemLike)Items.f_42427_), 12, 1, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get()), new ItemStack((ItemLike)Items.f_42429_), 12, 1, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Items.f_42699_), 12, 1, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Items.f_42460_, 10), 16, 1, 0.05f)}), (Object)2, (Object)ImmutableList.of((Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)Items.f_42687_, 4), 12, 5, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), new ItemStack((ItemLike)Items.f_42410_, 4), 16, 5, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 3), new ItemStack((ItemLike)Items.f_42526_, 15), 16, 10, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.f_50683_), 12, 5, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.f_50041_), 16, 5, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 4), new ItemStack((ItemLike)Items.f_42411_), 12, 5, 0.05f), (Object)new EnchantedBookForCoinsTrade(5), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.f_50681_), 12, 5, 0.05f), (Object)new ItemsForMapTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 3), (TagKey<Structure>)StructureTags.f_215885_, "filled_map.monument", MapDecoration.Type.MONUMENT, 12, 5), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Items.f_42534_), 12, 5, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 4), new ItemStack((ItemLike)Blocks.f_50680_), 12, 5, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 9), new ItemStack((ItemLike)ModItems.COIN_COPPER.get(), 5), new ItemStack((ItemLike)Items.f_42466_), 12, 5, 0.05f), (Object[])new VillagerTrades.ItemListing[]{new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), new ItemStack((ItemLike)ModItems.COIN_COPPER.get(), 3), new ItemStack((ItemLike)Items.f_42467_), 12, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 3), new ItemStack((ItemLike)Items.f_42485_, 6), 16, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 3), new ItemStack((ItemLike)Items.f_42582_, 8), 16, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.f_50225_, 4), 16, 5, 0.05f)}), (Object)3, (Object)ImmutableList.of((Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)Items.f_42572_, 18), 18, 10, 0.05f), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 2, (ItemLike)Items.f_42523_, 3, 10, 0.05f, 0.25), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 7), new ItemStack((ItemLike)Items.f_42717_), 12, 10, 0.05f), (Object)new EnchantedBookForCoinsTrade(10), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 3), new ItemStack((ItemLike)Blocks.f_50058_, 4), 12, 10, 0.05f), (Object)new ItemsForMapTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 4), (TagKey<Structure>)StructureTags.f_215884_, "filled_map.mansion", MapDecoration.Type.MANSION, 12, 10), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get()), new ItemStack((ItemLike)Blocks.f_50141_), 12, 10, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 7), new ItemStack((ItemLike)ModItems.COIN_COPPER.get(), 4), new ItemStack((ItemLike)Items.f_42464_), 12, 10, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 10), new ItemStack((ItemLike)ModItems.COIN_COPPER.get(), 5), new ItemStack((ItemLike)Items.f_42465_), 12, 10, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), new ItemStack((ItemLike)Items.f_42740_), 12, 10, 0.05f), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 5, (ItemLike)Items.f_42386_, 3, 12, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 4, (ItemLike)Items.f_42384_, 3, 12, 0.05f, 0.25), (Object[])new VillagerTrades.ItemListing[]{new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 6, (ItemLike)Items.f_42385_, 3, 12, 0.05f, 0.25), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_DIAMOND.get(), 2), new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 1), new ItemStack((ItemLike)Items.f_42392_), 3, 10, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.f_50387_, 4), 16, 10, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.f_50281_, 4), 16, 10, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.f_50175_, 4), 16, 10, 0.05f)}), (Object)4, (Object)ImmutableList.of((Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 2), new ItemStack((ItemLike)Blocks.f_50145_), 12, 15, 0.05f), (Object)new SimpleTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), SimpleTrade.createSuspiciousStew(MobEffects.f_19611_, 100), 15), (Object)new SimpleTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), SimpleTrade.createSuspiciousStew(MobEffects.f_19603_, 160), 15), (Object)new SimpleTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), SimpleTrade.createSuspiciousStew(MobEffects.f_19613_, 100), 15), (Object)new SimpleTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), SimpleTrade.createSuspiciousStew(MobEffects.f_19610_, 120), 15), (Object)new SimpleTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), SimpleTrade.createSuspiciousStew(MobEffects.f_19614_, 100), 15), (Object)new SimpleTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), SimpleTrade.createSuspiciousStew(MobEffects.f_19618_, 7), 15), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 5, (ItemLike)Items.f_42411_, 3, 15, 0.05f, 0.25), (Object)new EnchantedBookForCoinsTrade(15), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 5), new ItemStack((ItemLike)Items.f_42524_), 12, 15, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 2), new ItemStack((ItemLike)Items.f_42522_), 12, 15, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get()), new ItemStack((ItemLike)Items.f_42617_), 12, 15, 0.05f), (Object[])new VillagerTrades.ItemListing[]{new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get()), new ItemStack((ItemLike)Items.f_42584_), 12, 15, 0.05f), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 7, (ItemLike)Items.f_42474_, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 5, (ItemLike)Items.f_42475_, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 4, (ItemLike)Items.f_42391_, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 3, (ItemLike)Items.f_42391_, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 2, (ItemLike)Items.f_42389_, 3, 15, 0.05f, 0.25), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.f_50352_, 1), 16, 15, 0.05f)}), (Object)5, (Object)ImmutableList.of((Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 15), new ItemStack((ItemLike)Items.f_42677_), 12, 30, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 2), new ItemStack((ItemLike)Items.f_42546_), 12, 30, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 5), new ItemStack((ItemLike)Items.f_42487_), 12, 30, 0.05f), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 10, (ItemLike)Items.f_42717_, 3, 15, 0.05f, 0.25), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)Items.f_42656_), 12, 30, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)Items.f_186364_), 12, 30, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), new ItemStack((ItemLike)Blocks.f_50200_, 12), 12, 30, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 5), new ItemStack((ItemLike)Items.f_42612_), 12, 30, 0.05f), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 8, (ItemLike)Items.f_42473_, 3, 30, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 6, (ItemLike)Items.f_42472_, 3, 30, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 4, (ItemLike)Items.f_42388_, 3, 30, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 4, (ItemLike)Items.f_42390_, 3, 30, 0.05f, 0.25), (Object[])new VillagerTrades.ItemListing[]{new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)Items.f_42450_), 12, 30, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.f_50333_), 12, 30, 0.05f)})));
        CustomVillagerTradeData.registerDefaultWanderingTrades((List<VillagerTrades.ItemListing>)ImmutableList.of((Object)new SimpleTrade((ItemLike)ModItems.COIN_GOLD.get(), 1, (ItemLike)ModBlocks.ATM.get()), (Object)new SimpleTrade((ItemLike)ModItems.COIN_IRON.get(), 5, (ItemLike)ModBlocks.CASH_REGISTER.get()), (Object)new SimpleTrade((ItemLike)ModItems.COIN_IRON.get(), 5, (ItemLike)ModBlocks.TERMINAL.get())), (List<VillagerTrades.ItemListing>)ImmutableList.of((Object)new SimpleTrade((ItemLike)ModItems.COIN_GOLD.get(), 2, (ItemLike)ModItems.COIN_IRON.get(), 4, (ItemLike)ModBlocks.DISPLAY_CASE.get()), (Object)new SimpleTrade((ItemLike)ModItems.COIN_GOLD.get(), 4, (ItemLike)ModBlocks.ARMOR_DISPLAY.get())));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void OnVillagerTradeSetup(VillagerTradesEvent event) {
        if (event.getType() == CustomProfessions.BANKER.get()) {
            if (!((Boolean)LCConfig.COMMON.addBankerVillager.get()).booleanValue()) {
                return;
            }
            LightmansCurrency.LogInfo("Registering banker trades.");
            Map<Integer, List<VillagerTrades.ItemListing>> bankerTrades = CustomVillagerTradeData.getVillagerData(BANKER_ID);
            for (int i = 1; i <= 5; ++i) {
                List currentTrades = (List)event.getTrades().get(i);
                List<VillagerTrades.ItemListing> newTrades = bankerTrades.get(i);
                if (newTrades != null) {
                    currentTrades.addAll(newTrades);
                    continue;
                }
                LightmansCurrency.LogWarning("Banker Trades have no listings for trade level " + i);
            }
        } else if (event.getType() == CustomProfessions.CASHIER.get()) {
            if (!((Boolean)LCConfig.COMMON.addCashierVillager.get()).booleanValue()) {
                return;
            }
            LightmansCurrency.LogInfo("Registering cashier trades.");
            Map<Integer, List<VillagerTrades.ItemListing>> cashierTrades = CustomVillagerTradeData.getVillagerData(CASHIER_ID);
            for (int i = 1; i <= 5; ++i) {
                List currentTrades = (List)event.getTrades().get(i);
                List<VillagerTrades.ItemListing> newTrades = cashierTrades.get(i);
                if (newTrades != null) {
                    currentTrades.addAll(newTrades);
                    continue;
                }
                LightmansCurrency.LogWarning("Cashier Trades have no listings for trade level " + i);
            }
        } else {
            ResourceLocation type = ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)event.getType());
            assert (type != null);
            if (type.m_135827_().equals("minecraft")) {
                if (!((Boolean)LCConfig.COMMON.changeVanillaTrades.get()).booleanValue()) {
                    return;
                }
                LightmansCurrency.LogInfo("Replacing Emeralds for villager type '" + type + "'.");
                VillagerTradeManager.replaceExistingTrades(type.toString(), (Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
            } else if (((Boolean)LCConfig.COMMON.changeModdedTrades.get()).booleanValue()) {
                LightmansCurrency.LogInfo("Replacing Emeralds for villager type '" + type + "'.");
                VillagerTradeManager.replaceExistingTrades(type.toString(), (Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
            }
        }
    }

    public static void replaceExistingTrades(String trader, Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
        trades.forEach((i, list) -> VillagerTradeManager.replaceExistingTrades(trader, list));
    }

    public static void replaceExistingTrades(String trader, List<VillagerTrades.ItemListing> trades) {
        trades.replaceAll(t -> {
            if (t instanceof ConfiguredItemListing) {
                return t;
            }
            return new ConfiguredItemListing((VillagerTrades.ItemListing)t, LCConfig.COMMON.getVillagerMod(trader));
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void OnWandererTradeSetup(WandererTradesEvent event) {
        if (((Boolean)LCConfig.COMMON.changeWanderingTrades.get()).booleanValue()) {
            VillagerTradeManager.replaceExistingTrades(WANDERING_TRADER_ID, event.getGenericTrades());
            VillagerTradeManager.replaceExistingTrades(WANDERING_TRADER_ID, event.getRareTrades());
        }
        if (((Boolean)LCConfig.COMMON.addCustomWanderingTrades.get()).booleanValue()) {
            Pair<List<VillagerTrades.ItemListing>, List<VillagerTrades.ItemListing>> pair = CustomVillagerTradeData.getWanderingTraderData();
            event.getGenericTrades().addAll((Collection)pair.getFirst());
            event.getRareTrades().addAll((Collection)pair.getSecond());
        }
    }
}

