/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.player.OwnerData;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_chest.SecurityUpgradeTab;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinChestBlockEntity;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionSaveData;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.IDumpable;
import io.github.lightman314.lightmanscurrency.common.menus.CoinChestMenu;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CoinChestSecurityUpgrade
extends CoinChestUpgrade {
    @Override
    public void HandleMenuMessage(@Nonnull CoinChestMenu menu, @Nonnull CoinChestUpgradeData data, @Nonnull LazyPacketData message) {
        PlayerReference player;
        if (message.contains("SetTeamOwner")) {
            Team team = TeamSaveData.GetTeam(false, message.getLong("SetTeamOwner"));
            if (team != null) {
                OwnerData owner = this.parseOwnerData(menu.be, data);
                owner.SetOwner(team);
                this.saveOwnerData(data, owner);
            }
        } else if (message.contains("SetPlayerOwner")) {
            PlayerReference player2 = PlayerReference.of(false, message.getString("SetPlayerOwner"));
            if (player2 != null) {
                OwnerData owner = this.parseOwnerData(menu.be, data);
                owner.SetOwner(player2);
                this.saveOwnerData(data, owner);
            }
        } else if (message.contains("SetSelfOwner") && (player = PlayerReference.of(menu.player)) != null) {
            OwnerData owner = this.parseOwnerData(menu.be, data);
            owner.SetOwner(player);
            this.saveOwnerData(data, owner);
        }
    }

    public boolean isAdmin(CoinChestBlockEntity be, CoinChestUpgradeData data, Player player) {
        OwnerData owner = this.parseOwnerData(be, data);
        if (owner.hasOwner()) {
            return owner.isAdmin(player);
        }
        return true;
    }

    public boolean isMember(CoinChestBlockEntity be, CoinChestUpgradeData data, Player player) {
        OwnerData owner = this.parseOwnerData(be, data);
        if (owner.hasOwner()) {
            return owner.isMember(player);
        }
        return true;
    }

    @Nonnull
    public OwnerData parseOwnerData(CoinChestBlockEntity be, CoinChestUpgradeData data) {
        OwnerData owner = new OwnerData(be, o -> {});
        CompoundTag compound = data.getItemTag();
        if (compound.m_128441_("Owner")) {
            owner.load(compound.m_128469_("Owner"));
        }
        return owner;
    }

    public void saveOwnerData(CoinChestUpgradeData data, OwnerData newOwner) {
        CompoundTag compound = data.getItemTag();
        compound.m_128365_("Owner", (Tag)newOwner.save());
        data.setItemTag(compound);
    }

    @Override
    public boolean BlockAccess(@Nonnull CoinChestBlockEntity be, @Nonnull CoinChestUpgradeData data, @Nonnull Player player) {
        return !this.isMember(be, data, player);
    }

    @Override
    public void OnEquip(@Nonnull CoinChestBlockEntity be, @Nonnull CoinChestUpgradeData data) {
        data.getItemTag().m_128473_("BreakIsValid");
    }

    @Override
    public void OnValidBlockRemoval(@Nonnull CoinChestBlockEntity be, @Nonnull CoinChestUpgradeData data) {
        CompoundTag compound = data.getItemTag();
        compound.m_128379_("BreakIsValid", true);
        data.setItemTag(compound);
    }

    @Override
    public void OnBlockRemoval(@Nonnull CoinChestBlockEntity be, @Nonnull CoinChestUpgradeData data) {
        if (data.getItemTag().m_128471_("BreakIsValid")) {
            return;
        }
        OwnerData owner = this.parseOwnerData(be, data);
        if (owner.hasOwner()) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(be.getStorage().m_19195_());
            items.addAll(be.getUpgrades().m_19195_());
            EjectionSaveData.HandleEjectionData(be.m_58904_(), be.m_58899_(), EjectionData.create(be.m_58904_(), be.m_58899_(), be.m_58900_(), IDumpable.preCollected(items, be.getDisplayName(), owner), false));
        }
    }

    @Override
    public void addClientTabs(@Nonnull CoinChestUpgradeData data, @Nonnull Object screen, @Nonnull Consumer<Object> consumer) {
        consumer.accept(new SecurityUpgradeTab(data, screen));
    }

    @Override
    @Nonnull
    public List<Component> getTooltip(@Nonnull UpgradeData data) {
        ArrayList tooltip = Lists.newArrayList((Object[])new Component[]{EasyText.translatable("tooltip.lightmanscurrency.upgrade.coin_chest.protection.1", new Object[0]), EasyText.translatable("tooltip.lightmanscurrency.upgrade.coin_chest.protection.2", new Object[0])});
        if (LCConfig.SERVER.isLoaded() && ((Boolean)LCConfig.SERVER.anarchyMode.get()).booleanValue()) {
            tooltip.add(EasyText.translatable("tooltip.lightmanscurrency.ownable.anarchy_warning", new Object[0]).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.RED));
        }
        return tooltip;
    }

    @Override
    public boolean clearDataFromStack(@Nonnull CompoundTag itemTag) {
        return this.clearTags(itemTag, "Owner", "BreakIsValid");
    }
}

