/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeData;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinChestBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.menus.CoinChestMenu;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.TickableCoinChestUpgrade;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class CoinChestMagnetUpgrade
extends TickableCoinChestUpgrade {
    public static final String RANGE = "magnet_range";

    @Override
    public void HandleMenuMessage(@Nonnull CoinChestMenu menu, @Nonnull CoinChestUpgradeData data, @Nonnull LazyPacketData message) {
    }

    @Override
    public void addClientTabs(@Nonnull CoinChestUpgradeData data, @Nonnull Object screen, @Nonnull Consumer<Object> consumer) {
    }

    public int getRadius(CoinChestUpgradeData data) {
        return data.getUpgradeData().getIntValue(RANGE);
    }

    @Override
    public void OnServerTick(@Nonnull CoinChestBlockEntity be, @Nonnull CoinChestUpgradeData data) {
        int radius = this.getRadius(data);
        Vector3f pos = new Vector3f((float)be.m_58899_().m_123341_() + 0.5f, (float)be.m_58899_().m_123342_() + 0.5f, (float)be.m_58899_().m_123343_() + 0.5f);
        AABB searchBox = new AABB((double)(pos.m_122239_() - (float)radius), (double)(pos.m_122260_() - (float)radius), (double)(pos.m_122269_() - (float)radius), (double)(pos.m_122239_() + (float)radius), (double)(pos.m_122260_() + (float)radius), (double)(pos.m_122269_() + (float)radius));
        boolean playSound = false;
        for (Entity e2 : be.m_58904_().m_6249_((Entity)null, searchBox, e -> {
            ItemEntity item;
            return e instanceof ItemEntity && CoinAPI.API.IsCoin((item = (ItemEntity)e).m_32055_(), true);
        })) {
            ItemEntity ie = (ItemEntity)e2;
            ItemStack coinStack = ie.m_32055_();
            ItemStack leftovers = InventoryUtil.TryPutItemStack((Container)be.getStorage(), coinStack);
            if (leftovers.m_41613_() == coinStack.m_41613_()) continue;
            playSound = true;
            if (leftovers.m_41619_()) {
                ie.m_146870_();
                continue;
            }
            ie.m_32045_(leftovers);
        }
        if (playSound) {
            be.m_58904_().m_5594_(null, be.m_58899_(), (SoundEvent)ModSounds.COINS_CLINKING.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
        }
    }

    @Override
    @Nonnull
    protected List<String> getDataTags() {
        return ImmutableList.of((Object)RANGE);
    }

    @Override
    protected Object defaultTagValue(String tag) {
        if (Objects.equals(tag, RANGE)) {
            return 1;
        }
        return null;
    }

    @Override
    @Nonnull
    public List<Component> getTooltip(@Nonnull UpgradeData data) {
        return ImmutableList.of((Object)EasyText.translatable("tooltip.lightmanscurrency.upgrade.coin_chest.magnet", data.getIntValue(RANGE)));
    }
}

