/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.atm.ATMAPI;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_chest.ExchangeUpgradeTab;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinChestBlockEntity;
import io.github.lightman314.lightmanscurrency.common.menus.CoinChestMenu;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgradeData;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;

public class CoinChestExchangeUpgrade
extends CoinChestUpgrade {
    @Override
    public void HandleMenuMessage(@Nonnull CoinChestMenu menu, @Nonnull CoinChestUpgradeData data, @Nonnull LazyPacketData message) {
        if (message.contains("SetExchangeWhileOpen")) {
            this.setExchangeWhileOpen(data, message.getBoolean("SetExchangeWhileOpen"));
        }
        if (message.contains("SetExchangeCommand")) {
            String oldCommand;
            String newCommand = message.getString("SetExchangeCommand");
            if (Objects.equals(newCommand, oldCommand = this.getExchangeCommand(data))) {
                this.setExchangeCommand(data, "");
            } else {
                this.setExchangeCommand(data, newCommand);
            }
        }
    }

    @Override
    public void OnStorageChanged(@Nonnull CoinChestBlockEntity be, @Nonnull CoinChestUpgradeData data) {
        this.ExecuteExchangeCommand(be, data);
    }

    @Override
    public void OnEquip(@Nonnull CoinChestBlockEntity be, @Nonnull CoinChestUpgradeData data) {
        this.ExecuteExchangeCommand(be, data);
    }

    public boolean getExchangeWhileOpen(CoinChestUpgradeData data) {
        CompoundTag compound = data.getItemTag();
        if (compound.m_128441_("ExchangeWhileOpen")) {
            return compound.m_128471_("ExchangeWhileOpen");
        }
        return true;
    }

    public void setExchangeWhileOpen(CoinChestUpgradeData data, boolean newValue) {
        CompoundTag compound = data.getItemTag();
        compound.m_128379_("ExchangeWhileOpen", newValue);
        data.setItemTag(compound);
    }

    public String getExchangeCommand(CoinChestUpgradeData data) {
        CompoundTag compound = data.getItemTag();
        if (compound.m_128441_("ExchangeCommand")) {
            return compound.m_128461_("ExchangeCommand");
        }
        return "";
    }

    public void setExchangeCommand(CoinChestUpgradeData data, String newValue) {
        CompoundTag compound = data.getItemTag();
        compound.m_128359_("ExchangeCommand", newValue);
        data.setItemTag(compound);
    }

    public void ExecuteExchangeCommand(CoinChestBlockEntity be, CoinChestUpgradeData data) {
        String command;
        boolean executeWhileOpen = this.getExchangeWhileOpen(data);
        if ((executeWhileOpen || be.getOpenerCount() <= 0) && (command = this.getExchangeCommand(data)) != null && !command.isBlank() && ATMAPI.ExecuteATMExchangeCommand((Container)be.getStorage(), command)) {
            CoinAPI.API.SortCoinsByValue((Container)be.getStorage());
        }
    }

    @Override
    public void addClientTabs(@Nonnull CoinChestUpgradeData data, @Nonnull Object screen, @Nonnull Consumer<Object> consumer) {
        consumer.accept(new ExchangeUpgradeTab(data, screen));
    }

    @Override
    @Nonnull
    public List<Component> getTooltip(@Nonnull UpgradeData data) {
        return Lists.newArrayList((Object[])new Component[]{EasyText.translatable("tooltip.lightmanscurrency.upgrade.coin_chest.exchange", new Object[0])});
    }

    @Override
    public boolean clearDataFromStack(@Nonnull CompoundTag itemTag) {
        return this.clearTags(itemTag, "ExchangeCommand", "ExchangeWhileOpen");
    }
}

