/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.rules.TradeRuleType;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs.FreeSampleTab;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import io.github.lightman314.lightmanscurrency.common.traders.rules.PriceTweakingTradeRule;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class FreeSample
extends PriceTweakingTradeRule {
    public static final TradeRuleType<FreeSample> TYPE = new TradeRuleType(new ResourceLocation("lightmanscurrency", "free_sample"), FreeSample::new);
    List<UUID> memory = new ArrayList<UUID>();

    public int getSampleCount() {
        return this.memory.size();
    }

    private FreeSample() {
        super(TYPE);
    }

    @Override
    protected boolean canActivate(@Nullable ITradeRuleHost host) {
        TradeData trade;
        if (host instanceof TradeData && (trade = (TradeData)host).getTradeDirection() != TradeData.TradeDirection.SALE) {
            return false;
        }
        return super.canActivate(host);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.giveDiscount(event)) {
            event.addHelpful(EasyText.translatable("traderule.lightmanscurrency.free_sample.alert", new Object[0]));
        }
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        if (this.giveDiscount(event)) {
            event.makeFree();
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        if (this.giveDiscount(event)) {
            this.addToMemory(event.getPlayerReference().id);
            event.markDirty();
        }
    }

    private boolean giveDiscount(TradeEvent event) {
        return this.giveDiscount(event.getPlayerReference().id) && event.getTrade().getTradeDirection() == TradeData.TradeDirection.SALE;
    }

    private void addToMemory(UUID playerID) {
        if (!this.memory.contains(playerID)) {
            this.memory.add(playerID);
        }
    }

    public boolean giveDiscount(UUID playerID) {
        return !this.givenFreeSample(playerID);
    }

    private boolean givenFreeSample(UUID playerID) {
        return this.memory.contains(playerID);
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound) {
        ListTag memoryList = new ListTag();
        for (UUID entry : this.memory) {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("ID", entry);
            memoryList.add((Object)tag);
        }
        compound.m_128365_("Memory", (Tag)memoryList);
    }

    @Override
    public JsonObject saveToJson(@Nonnull JsonObject json) {
        return json;
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound) {
        if (compound.m_128425_("Memory", 9)) {
            this.memory.clear();
            ListTag memoryList = compound.m_128437_("Memory", 10);
            for (int i = 0; i < memoryList.size(); ++i) {
                CompoundTag tag = memoryList.m_128728_(i);
                if (tag.m_128441_("ID")) {
                    this.memory.add(tag.m_128342_("ID"));
                    continue;
                }
                if (!tag.m_128441_("id")) continue;
                this.memory.add(tag.m_128342_("id"));
            }
        }
    }

    @Override
    public CompoundTag savePersistentData() {
        CompoundTag data = new CompoundTag();
        ListTag memoryList = new ListTag();
        for (UUID entry : this.memory) {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("ID", entry);
            memoryList.add((Object)tag);
        }
        data.m_128365_("Memory", (Tag)memoryList);
        return data;
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
        if (data.m_128425_("Memory", 9)) {
            this.memory.clear();
            ListTag memoryList = data.m_128437_("Memory", 10);
            for (int i = 0; i < memoryList.size(); ++i) {
                CompoundTag tag = memoryList.m_128728_(i);
                if (tag.m_128441_("ID")) {
                    this.memory.add(tag.m_128342_("ID"));
                    continue;
                }
                if (!tag.m_128441_("id")) continue;
                this.memory.add(tag.m_128342_("id"));
            }
        }
    }

    @Override
    public void loadFromJson(@Nonnull JsonObject json) {
    }

    @Override
    protected void handleUpdateMessage(@Nonnull LazyPacketData updateInfo) {
        if (updateInfo.contains("ClearData")) {
            this.memory.clear();
        }
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TradeRulesClientSubTab createTab(TradeRulesClientTab<?> parent) {
        return new FreeSampleTab(parent);
    }
}

