/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.rules.TradeRuleType;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TradeRule {
    public final TradeRuleType<?> type;
    private ITradeRuleHost host = null;
    private boolean isActive = false;

    public static MutableComponent nameOfType(ResourceLocation ruleType) {
        return EasyText.translatable("traderule." + ruleType.m_135827_() + "." + ruleType.m_135815_(), new Object[0]);
    }

    public final MutableComponent getName() {
        return TradeRule.nameOfType(this.type.type);
    }

    public boolean isActive() {
        return this.canActivate(this.host) && this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    protected boolean allowHost(@Nonnull ITradeRuleHost host) {
        if (this.onlyAllowOnTraders() && !host.isTrader()) {
            return false;
        }
        return !this.onlyAllowOnTrades() || host.isTrade();
    }

    public boolean canActivate() {
        return this.canActivate(this.host);
    }

    protected boolean canActivate(@Nullable ITradeRuleHost host) {
        return this.allowHost(host);
    }

    protected boolean onlyAllowOnTraders() {
        return false;
    }

    protected boolean onlyAllowOnTrades() {
        return false;
    }

    public void beforeTrade(TradeEvent.PreTradeEvent event) {
    }

    public void tradeCost(TradeEvent.TradeCostEvent event) {
    }

    public void afterTrade(TradeEvent.PostTradeEvent event) {
    }

    protected TradeRule(@Nonnull TradeRuleType<?> type) {
        this.type = type;
    }

    @Nonnull
    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("Type", this.type.toString());
        compound.m_128379_("Active", this.isActive);
        this.saveAdditional(compound);
        return compound;
    }

    protected abstract void saveAdditional(@Nonnull CompoundTag var1);

    public final void load(@Nonnull CompoundTag compound) {
        this.isActive = compound.m_128471_("Active");
        this.loadAdditional(compound);
    }

    protected abstract void loadAdditional(@Nonnull CompoundTag var1);

    public abstract JsonObject saveToJson(@Nonnull JsonObject var1);

    public abstract void loadFromJson(@Nonnull JsonObject var1) throws JsonSyntaxException, ResourceLocationException;

    public abstract CompoundTag savePersistentData();

    public abstract void loadPersistentData(CompoundTag var1);

    public final void receiveUpdateMessage(@Nonnull LazyPacketData data) {
        if (data.contains("SetActive")) {
            this.isActive = data.getBoolean("SetActive");
        }
        this.handleUpdateMessage(data);
    }

    protected abstract void handleUpdateMessage(@Nonnull LazyPacketData var1);

    public static void saveRules(@Nonnull CompoundTag compound, @Nonnull List<TradeRule> rules, @Nonnull String tag) {
        ListTag ruleData = new ListTag();
        for (TradeRule rule : rules) {
            ruleData.add((Object)rule.save());
        }
        compound.m_128365_(tag, (Tag)ruleData);
    }

    public static boolean savePersistentData(@Nonnull CompoundTag compound, @Nonnull List<TradeRule> rules, @Nonnull String tag) {
        ListTag ruleData = new ListTag();
        for (TradeRule rule : rules) {
            CompoundTag thisRuleData = rule.savePersistentData();
            if (thisRuleData == null) continue;
            thisRuleData.m_128359_("Type", rule.type.toString());
            ruleData.add((Object)thisRuleData);
        }
        if (ruleData.size() == 0) {
            return false;
        }
        compound.m_128365_(tag, (Tag)ruleData);
        return true;
    }

    public static JsonArray saveRulesToJson(@Nonnull List<TradeRule> rules) {
        JsonArray ruleData = new JsonArray();
        for (TradeRule rule : rules) {
            JsonObject thisRuleData;
            if (!rule.isActive || (thisRuleData = rule.saveToJson(new JsonObject())) == null) continue;
            thisRuleData.addProperty("Type", rule.type.toString());
            ruleData.add((JsonElement)thisRuleData);
        }
        return ruleData;
    }

    public static List<TradeRule> loadRules(@Nonnull CompoundTag compound, @Nonnull String tag, @Nullable ITradeRuleHost host) {
        ArrayList<TradeRule> rules = new ArrayList<TradeRule>();
        if (compound.m_128425_(tag, 9)) {
            ListTag ruleData = compound.m_128437_(tag, 10);
            for (int i = 0; i < ruleData.size(); ++i) {
                CompoundTag thisRuleData = ruleData.m_128728_(i);
                TradeRule thisRule = TradeRule.Deserialize(thisRuleData);
                if (thisRule == null) continue;
                rules.add(thisRule);
                thisRule.host = host;
            }
        }
        return rules;
    }

    public static void loadPersistentData(@Nonnull CompoundTag compound, @Nonnull List<TradeRule> tradeRules, @Nonnull String tag) {
        if (compound.m_128425_(tag, 9)) {
            ListTag ruleData = compound.m_128437_(tag, 10);
            for (int i = 0; i < ruleData.size(); ++i) {
                CompoundTag thisRuleData = ruleData.m_128728_(i);
                boolean query = true;
                for (int r = 0; query && r < tradeRules.size(); ++r) {
                    if (!tradeRules.get((int)r).type.toString().contentEquals(thisRuleData.m_128461_("Type"))) continue;
                    tradeRules.get(r).loadPersistentData(thisRuleData);
                    query = false;
                }
            }
        }
    }

    public static List<TradeRule> Parse(@Nonnull JsonArray tradeRuleData, @Nullable ITradeRuleHost host) {
        ArrayList<TradeRule> rules = new ArrayList<TradeRule>();
        for (int i = 0; i < tradeRuleData.size(); ++i) {
            try {
                JsonObject thisRuleData = tradeRuleData.get(i).getAsJsonObject();
                TradeRule thisRule = TradeRule.Deserialize(thisRuleData);
                thisRule.host = host;
                rules.add(thisRule);
                continue;
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error loading Trade Rule at index " + i + ".", t);
            }
        }
        return rules;
    }

    public static boolean ValidateTradeRuleList(@Nonnull List<TradeRule> rules, @Nonnull ITradeRuleHost host) {
        boolean changed = false;
        for (TradeRuleType<?> ruleType : TraderAPI.getTradeRuleTypes()) {
            Object rule = ruleType.createNew();
            if (rule == null || !host.allowTradeRule((TradeRule)rule) || !((TradeRule)rule).allowHost(host) || TradeRule.HasTradeRule(rules, ((TradeRule)rule).type.type)) continue;
            rules.add((TradeRule)rule);
            ((TradeRule)rule).host = host;
            changed = true;
        }
        for (int i = 0; i < rules.size(); ++i) {
            TradeRule r1 = rules.get(i);
            for (int j = i + 1; j < rules.size(); ++j) {
                if (rules.get((int)j).type != r1.type) continue;
                rules.remove(j--);
                changed = true;
            }
        }
        return changed;
    }

    public static boolean ValidateTradeRuleActiveStates(@Nonnull List<TradeRule> rules) {
        boolean changed = false;
        for (TradeRule rule : rules) {
            if (!rule.isActive || rule.canActivate()) continue;
            rule.isActive = false;
            changed = true;
        }
        return changed;
    }

    public static boolean HasTradeRule(@Nonnull List<TradeRule> rules, @Nonnull ResourceLocation type) {
        return TradeRule.GetTradeRule(rules, type) != null;
    }

    @Nullable
    public static TradeRule GetTradeRule(@Nonnull List<TradeRule> rules, @Nonnull ResourceLocation type) {
        for (TradeRule rule : rules) {
            if (!rule.type.type.equals((Object)type)) continue;
            return rule;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public abstract TradeRulesClientSubTab createTab(TradeRulesClientTab<?> var1);

    @Nonnull
    public static TradeRule CreateRule(@Nonnull ResourceLocation type) {
        TradeRuleType<?> ruleType = TraderAPI.getTradeRuleType(type);
        if (ruleType != null) {
            return ruleType.createNew();
        }
        LightmansCurrency.LogError("Could not find a TradeRuleType of type '" + type + "'. Unable to create the Trade Rule.");
        return null;
    }

    @Nonnull
    public static TradeRule Deserialize(@Nonnull CompoundTag compound) {
        String thisType = compound.m_128441_("Type") ? compound.m_128461_("Type") : compound.m_128461_("type");
        TradeRuleType<?> ruleType = TraderAPI.getTradeRuleType(new ResourceLocation(thisType));
        if (ruleType != null) {
            return ruleType.load(compound);
        }
        LightmansCurrency.LogError("Could not find a TradeRuleType of type '" + thisType + "'. Unable to load the Trade Rule.");
        return null;
    }

    @Nonnull
    public static TradeRule Deserialize(@Nonnull JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        String thisType = GsonHelper.m_13906_((JsonObject)json, (String)"Type");
        TradeRuleType<?> ruleType = TraderAPI.getTradeRuleType(new ResourceLocation(thisType));
        if (ruleType != null) {
            Object rule = ruleType.loadFromJson(json);
            ((TradeRule)rule).loadFromJson(json);
            ((TradeRule)rule).setActive(true);
            return rule;
        }
        throw new JsonSyntaxException("Could not find a deserializer of type '" + thisType + "'.");
    }

    @Nullable
    public static TradeRule getRule(@Nonnull ResourceLocation type, @Nonnull List<TradeRule> rules) {
        for (TradeRule rule : rules) {
            if (!rule.type.type.equals((Object)type)) continue;
            return rule;
        }
        return null;
    }

    public static CompoundTag CreateRuleMessage() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("Create", true);
        return tag;
    }

    public static CompoundTag RemoveRuleMessage() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("Remove", true);
        return tag;
    }

    public static boolean isCreateMessage(CompoundTag tag) {
        return tag.m_128441_("Create") && tag.m_128471_("Create");
    }

    public static boolean isRemoveMessage(CompoundTag tag) {
        return tag.m_128441_("Remove") && tag.m_128471_("Remove");
    }
}

