/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules;

import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;

public interface ITradeRuleHost {
    default public boolean allowTradeRule(@Nonnull TradeRule rule) {
        return true;
    }

    public boolean isTrader();

    public boolean isTrade();

    default public boolean canMoneyBeRelevant() {
        return true;
    }

    default public boolean isMoneyRelevant() {
        return this.canMoneyBeRelevant();
    }

    public void markTradeRulesDirty();

    @Nonnull
    public List<TradeRule> getRules();

    default public TradeRule getRuleOfType(@Nonnull ResourceLocation ruleType) {
        return TradeRule.GetTradeRule(this.getRules(), ruleType);
    }

    default public void validateRuleStates() {
        TradeRule.ValidateTradeRuleActiveStates(this.getRules());
    }

    default public void HandleRuleUpdate(@Nonnull ResourceLocation type, @Nonnull LazyPacketData updateData) {
        TradeRule rule = this.getRuleOfType(type);
        if (rule != null) {
            rule.receiveUpdateMessage(updateData);
            this.markTradeRulesDirty();
        }
    }
}

