/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.client;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreenHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

@OnlyIn(value=Dist.CLIENT)
public class ItemTradeButtonRenderer
extends TradeRenderManager<ItemTradeData> {
    public static final ResourceLocation NBT_SLOT = new ResourceLocation("lightmanscurrency", "item/empty_nbt_highlight");
    public static final Pair<ResourceLocation, ResourceLocation> NBT_BACKGROUND = Pair.of((Object)InventoryMenu.f_39692_, (Object)NBT_SLOT);

    public ItemTradeButtonRenderer(ItemTradeData trade) {
        super(trade);
    }

    @Override
    public int tradeButtonWidth(TradeContext context) {
        return 94;
    }

    @Override
    public LazyOptional<ScreenPosition> arrowPosition(TradeContext context) {
        return ScreenPosition.ofOptional(36, 1);
    }

    @Override
    public DisplayData inputDisplayArea(TradeContext context) {
        return new DisplayData(1, 1, 34, 16);
    }

    @Override
    public List<DisplayEntry> getInputDisplays(TradeContext context) {
        if (((ItemTradeData)this.trade).isSale()) {
            return Lists.newArrayList((Object[])new DisplayEntry[]{DisplayEntry.of(((ItemTradeData)this.trade).getCost(context), context.isStorageMode ? Lists.newArrayList((Object[])new Component[]{EasyText.translatable("tooltip.lightmanscurrency.trader.price_edit", new Object[0])}) : null)});
        }
        if (((ItemTradeData)this.trade).isPurchase()) {
            return this.getSaleItemEntries(context);
        }
        if (((ItemTradeData)this.trade).isBarter()) {
            return this.getBarterItemEntries(context);
        }
        return new ArrayList<DisplayEntry>();
    }

    @Override
    public DisplayData outputDisplayArea(TradeContext context) {
        return new DisplayData(59, 1, 34, 16);
    }

    @Override
    public List<DisplayEntry> getOutputDisplays(TradeContext context) {
        if (((ItemTradeData)this.trade).isSale() || ((ItemTradeData)this.trade).isBarter()) {
            return this.getSaleItemEntries(context);
        }
        if (((ItemTradeData)this.trade).isPurchase()) {
            return Lists.newArrayList((Object[])new DisplayEntry[]{DisplayEntry.of(((ItemTradeData)this.trade).getCost(context))});
        }
        return new ArrayList<DisplayEntry>();
    }

    private List<DisplayEntry> getSaleItemEntries(TradeContext context) {
        ArrayList<DisplayEntry> entries = new ArrayList<DisplayEntry>();
        for (int i = 0; i < 2; ++i) {
            ItemStack item = ((ItemTradeData)this.trade).getSellItem(i);
            if (!item.m_41619_()) {
                entries.add(DisplayEntry.of(item, item.m_41613_(), this.getSaleItemTooltip(item, ((ItemTradeData)this.trade).getCustomName(i), ((ItemTradeData)this.trade).getEnforceNBT(i), context), this.getNBTHightlight(((ItemTradeData)this.trade).getEnforceNBT(i))));
                continue;
            }
            if (!context.isStorageMode) continue;
            entries.add(DisplayEntry.of(((ItemTradeData)this.trade).getRestriction().getEmptySlotBG(), (List<Component>)Lists.newArrayList((Object[])new Component[]{EasyText.translatable("tooltip.lightmanscurrency.trader.item_edit", new Object[0])})));
        }
        return entries;
    }

    private List<Component> getSaleItemTooltip(ItemStack stack, String customName, boolean enforceNBT, TradeContext context) {
        TraderData traderData;
        if (stack.m_41619_()) {
            if (context.isStorageMode) {
                return Lists.newArrayList((Object[])new Component[]{EasyText.translatable("tooltip.lightmanscurrency.trader.item_edit", new Object[0])});
            }
            return null;
        }
        List<Component> tooltips = this.getTooltipFromItem(stack, ((ItemTradeData)this.trade).isPurchase(), enforceNBT);
        Component originalName = null;
        if (!customName.isEmpty() && (((ItemTradeData)this.trade).isSale() || ((ItemTradeData)this.trade).isBarter())) {
            originalName = tooltips.get(0);
            tooltips.set(0, (Component)EasyText.literal(customName).m_130940_(ChatFormatting.GOLD));
        }
        if (context.isStorageMode && originalName == null) {
            return tooltips;
        }
        tooltips.add((Component)EasyText.translatable("tooltip.lightmanscurrency.trader.info", new Object[0]).m_130940_(ChatFormatting.GOLD));
        if (originalName != null) {
            tooltips.add((Component)EasyText.translatable("tooltip.lightmanscurrency.trader.originalname", originalName).m_130940_(ChatFormatting.GOLD));
        }
        if (context.hasTrader() && context.hasPlayerReference() && (traderData = context.getTrader()) instanceof ItemTraderData) {
            ItemTraderData trader = (ItemTraderData)traderData;
            tooltips.add((Component)EasyText.translatable("tooltip.lightmanscurrency.trader.stock", trader.isCreative() ? EasyText.translatable("tooltip.lightmanscurrency.trader.stock.infinite", new Object[0]).m_130940_(ChatFormatting.GOLD) : EasyText.literal(String.valueOf(((ItemTradeData)this.trade).stockCount(context))).m_130940_(ChatFormatting.GOLD)).m_130940_(ChatFormatting.GOLD));
        }
        return tooltips;
    }

    private List<DisplayEntry> getBarterItemEntries(TradeContext context) {
        ArrayList<DisplayEntry> entries = new ArrayList<DisplayEntry>();
        for (int i = 0; i < 2; ++i) {
            ItemStack item = ((ItemTradeData)this.trade).getBarterItem(i);
            if (!item.m_41619_()) {
                entries.add(DisplayEntry.of(item, item.m_41613_(), this.getTooltipFromItem(item, true, ((ItemTradeData)this.trade).getEnforceNBT(i + 2)), this.getNBTHightlight(((ItemTradeData)this.trade).getEnforceNBT(i + 2))));
                continue;
            }
            if (!context.isStorageMode) continue;
            entries.add(DisplayEntry.of(EasySlot.BACKGROUND, (List<Component>)Lists.newArrayList((Object[])new Component[]{EasyText.translatable("tooltip.lightmanscurrency.trader.item_edit", new Object[0])})));
        }
        return entries;
    }

    private Pair<ResourceLocation, ResourceLocation> getNBTHightlight(boolean enforceNBT) {
        return enforceNBT ? null : NBT_BACKGROUND;
    }

    private List<Component> getTooltipFromItem(ItemStack item, boolean purchase, boolean enforceNBT) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (!enforceNBT) {
            tooltip.add((Component)EasyText.translatable(purchase ? "gui.lightmanscurrency.warning.nbt.buying" : "gui.lightmanscurrency.warning.nbt.selling", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.BOLD}));
        }
        tooltip.addAll(EasyScreenHelper.getTooltipFromItem(item));
        return tooltip;
    }

    @Override
    protected void getAdditionalAlertData(TradeContext context, List<AlertData> alerts) {
        TraderData traderData;
        if (context.hasTrader() && (traderData = context.getTrader()) instanceof ItemTraderData) {
            ItemTraderData trader = (ItemTraderData)traderData;
            if (!trader.isCreative()) {
                if (((ItemTradeData)this.trade).stockCount(context) <= 0) {
                    alerts.add(AlertData.warn(EasyText.translatable("tooltip.lightmanscurrency.outofstock", new Object[0])));
                }
                if (((ItemTradeData)this.trade).isPurchase() && !((ItemTradeData)this.trade).hasSpace(trader, context.getCollectableItems(((ItemTradeData)this.trade).getItemRequirement(0), ((ItemTradeData)this.trade).getItemRequirement(1)))) {
                    alerts.add(AlertData.warn(EasyText.translatable("tooltip.lightmanscurrency.outofspace", new Object[0])));
                }
                if (((ItemTradeData)this.trade).isBarter() && !((ItemTradeData)this.trade).hasSpace(trader, context.getCollectableItems(((ItemTradeData)this.trade).getItemRequirement(2), ((ItemTradeData)this.trade).getItemRequirement(3)))) {
                    alerts.add(AlertData.warn(EasyText.translatable("tooltip.lightmanscurrency.outofspace", new Object[0])));
                }
            }
            if (!((ItemTradeData)this.trade).canAfford(context)) {
                alerts.add(AlertData.warn(EasyText.translatable("tooltip.lightmanscurrency.cannotafford", new Object[0])));
            }
        }
    }
}

