/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item.tradedata;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.IBarterTrade;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.api.traders.trade.comparison.ProductComparisonResult;
import io.github.lightman314.lightmanscurrency.api.traders.trade.comparison.TradeComparisonResult;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.client.ItemTradeButtonRenderer;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.ItemRequirement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemTradeData
extends TradeData
implements IBarterTrade {
    ItemTradeRestriction restriction = ItemTradeRestriction.NONE;
    SimpleContainer items = new SimpleContainer(4);
    final List<Boolean> enforceNBT = Lists.newArrayList((Object[])new Boolean[]{true, true, true, true});
    ItemTradeType tradeType = ItemTradeType.SALE;
    String customName1 = "";
    String customName2 = "";

    public ItemTradeData(boolean validateRules) {
        super(validateRules);
        this.resetNBTList();
    }

    private void resetNBTList() {
        for (int i = 0; i < 4; ++i) {
            this.enforceNBT.set(i, true);
        }
    }

    public ItemStack getSellItem(int index) {
        if (index >= 0 && index < 2) {
            return this.restriction.modifySellItem(this.items.m_8020_(index).m_41777_(), this.getCustomName(index), this);
        }
        return ItemStack.f_41583_;
    }

    public List<ItemStack> getRandomSellItems(ItemTraderData trader) {
        return this.restriction.getRandomSellItems(trader, this);
    }

    public ItemStack getBarterItem(int index) {
        if (index >= 0 && index < 2) {
            return this.items.m_8020_(index + 2).m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getItem(int index) {
        if (index >= 0 && index < 2) {
            return this.getSellItem(index);
        }
        if (index >= 2 && index < 4) {
            return this.getBarterItem(index - 2);
        }
        return ItemStack.f_41583_;
    }

    public void setItem(ItemStack itemStack, int index) {
        if (index >= 0 && index < 4) {
            if (index < 2) {
                if (this.restriction.allowSellItem(itemStack) || itemStack.m_41619_()) {
                    this.items.m_6836_(index, this.restriction.filterSellItem(itemStack).m_41777_());
                }
            } else {
                this.items.m_6836_(index, itemStack.m_41777_());
            }
        } else {
            LightmansCurrency.LogError("Cannot define the item trades item at index " + index + ". Must be between 0-3!");
        }
    }

    public boolean alwaysEnforcesNBT(int slot) {
        return this.restriction.alwaysEnforceNBT(slot);
    }

    public boolean getEnforceNBT(int slot) {
        if (slot >= 0 && slot < 4) {
            return this.enforceNBT.get(slot) != false || this.alwaysEnforcesNBT(slot);
        }
        return true;
    }

    public void setEnforceNBT(int slot, boolean newValue) {
        if (slot >= 0 && slot < 4) {
            this.enforceNBT.set(slot, newValue || this.alwaysEnforcesNBT(slot));
        }
    }

    public ItemRequirement getItemRequirement(int slot) {
        if (slot >= 0 && slot < 4) {
            if (this.getEnforceNBT(slot)) {
                return ItemRequirement.of(this.getItem(slot));
            }
            return ItemRequirement.ofItemNoNBT(this.getItem(slot));
        }
        return ItemRequirement.NULL;
    }

    public boolean allowItemInStorage(ItemStack item) {
        for (int i = 0; i < (this.isBarter() ? 4 : 2); ++i) {
            if (!this.getItemRequirement(i).test(item)) continue;
            return true;
        }
        return this.restriction.allowExtraItemInStorage(item);
    }

    public boolean shouldStorageItemBeSaved(ItemStack item) {
        if ((this.isSale() || this.isBarter()) && this.isValid()) {
            for (int i = 0; i < 2; ++i) {
                if (this.getEnforceNBT(i) || !this.getItemRequirement(i).test(item)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasCustomName(int index) {
        return !this.getCustomName(index).isEmpty();
    }

    public String getCustomName(int index) {
        return switch (index) {
            case 0 -> this.customName1;
            case 1 -> this.customName2;
            default -> "";
        };
    }

    public void setCustomName(int index, String customName) {
        switch (index) {
            case 0: {
                this.customName1 = customName;
                break;
            }
            case 1: {
                this.customName2 = customName;
            }
        }
    }

    @Override
    public TradeData.TradeDirection getTradeDirection() {
        return switch (this.tradeType) {
            case ItemTradeType.SALE -> TradeData.TradeDirection.SALE;
            case ItemTradeType.PURCHASE -> TradeData.TradeDirection.PURCHASE;
            default -> TradeData.TradeDirection.NONE;
        };
    }

    public ItemTradeType getTradeType() {
        return this.tradeType;
    }

    public boolean isSale() {
        return this.tradeType == ItemTradeType.SALE;
    }

    public boolean isPurchase() {
        return this.tradeType == ItemTradeType.PURCHASE;
    }

    @Override
    public boolean isBarter() {
        return this.tradeType == ItemTradeType.BARTER;
    }

    public void setTradeType(ItemTradeType tradeDirection) {
        this.tradeType = tradeDirection;
        this.validateRuleStates();
    }

    @Nonnull
    public ItemTradeRestriction getRestriction() {
        return this.restriction;
    }

    public void setRestriction(ItemTradeRestriction restriction) {
        this.restriction = restriction;
    }

    @Override
    public boolean isValid() {
        if (this.tradeType == ItemTradeType.BARTER) {
            return this.sellItemsDefined() && this.barterItemsDefined();
        }
        return super.isValid() && this.sellItemsDefined();
    }

    public boolean sellItemsDefined() {
        return !this.getSellItem(0).m_41619_() || !this.getSellItem(1).m_41619_();
    }

    public boolean barterItemsDefined() {
        return !this.getBarterItem(0).m_41619_() || !this.getBarterItem(1).m_41619_();
    }

    public boolean hasStock(ItemTraderData trader) {
        if (!this.sellItemsDefined()) {
            return false;
        }
        return this.stockCount(trader) > 0;
    }

    public boolean hasStock(TradeContext context) {
        if (!this.sellItemsDefined()) {
            return false;
        }
        return this.stockCount(context) > 0;
    }

    public boolean hasSpace(ItemTraderData trader, List<ItemStack> collectableItems) {
        return switch (this.tradeType) {
            case ItemTradeType.PURCHASE, ItemTradeType.BARTER -> trader.getStorage().canFitItems(collectableItems);
            default -> true;
        };
    }

    public int stockCount(ItemTraderData trader) {
        if (!this.sellItemsDefined()) {
            return 0;
        }
        if (this.tradeType == ItemTradeType.PURCHASE) {
            return this.stockCountOfCost(trader);
        }
        if (this.tradeType == ItemTradeType.SALE || this.tradeType == ItemTradeType.BARTER) {
            return this.restriction.getSaleStock(trader.getStorage(), this);
        }
        return 0;
    }

    public int stockCount(TradeContext context) {
        TraderData traderData;
        if (!this.sellItemsDefined()) {
            return 0;
        }
        if (!context.hasTrader() || !((traderData = context.getTrader()) instanceof ItemTraderData)) {
            return 0;
        }
        ItemTraderData trader = (ItemTraderData)traderData;
        if (trader.isCreative()) {
            return 1;
        }
        if (this.tradeType == ItemTradeType.PURCHASE) {
            return this.stockCountOfCost(context);
        }
        if (this.tradeType == ItemTradeType.SALE || this.tradeType == ItemTradeType.BARTER) {
            return this.restriction.getSaleStock(trader.getStorage(), this);
        }
        return 0;
    }

    public boolean canAfford(TradeContext context) {
        if (this.isSale()) {
            return context.hasFunds(this.getCost(context));
        }
        if (this.isPurchase()) {
            return context.hasItems(this.getItemRequirement(0), this.getItemRequirement(1));
        }
        if (this.isBarter()) {
            return context.hasItems(this.getItemRequirement(2), this.getItemRequirement(3));
        }
        return false;
    }

    public void RemoveItemsFromStorage(TraderItemStorage storage, List<ItemStack> soldItems) {
        this.restriction.removeItemsFromStorage(storage, InventoryUtil.combineQueryItems(soldItems));
    }

    @Override
    public CompoundTag getAsNBT() {
        CompoundTag tradeNBT = super.getAsNBT();
        InventoryUtil.saveAllItems("Items", tradeNBT, (Container)this.items);
        tradeNBT.m_128359_("TradeDirection", this.tradeType.name());
        tradeNBT.m_128359_("CustomName1", this.customName1);
        tradeNBT.m_128359_("CustomName2", this.customName2);
        ArrayList<Integer> ignoreNBTSlots = new ArrayList<Integer>();
        for (int i = 0; i < 4; ++i) {
            if (this.getEnforceNBT(i)) continue;
            ignoreNBTSlots.add(i);
        }
        if (ignoreNBTSlots.size() > 0) {
            tradeNBT.m_128408_("IgnoreNBT", ignoreNBTSlots);
        }
        return tradeNBT;
    }

    public static void saveAllData(CompoundTag nbt, List<ItemTradeData> data) {
        ItemTradeData.saveAllData(nbt, data, "Trades");
    }

    public static void saveAllData(CompoundTag nbt, List<ItemTradeData> data, String key) {
        ListTag listNBT = new ListTag();
        for (ItemTradeData datum : data) {
            listNBT.add((Object)datum.getAsNBT());
        }
        nbt.m_128365_(key, (Tag)listNBT);
    }

    public static ItemTradeData loadData(CompoundTag compound, boolean validateRules) {
        ItemTradeData trade = new ItemTradeData(validateRules);
        trade.loadFromNBT(compound);
        return trade;
    }

    public static List<ItemTradeData> loadAllData(CompoundTag nbt, boolean validateRules) {
        return ItemTradeData.loadAllData("Trades", nbt, validateRules);
    }

    public static List<ItemTradeData> loadAllData(String key, CompoundTag compound, boolean validateRules) {
        ArrayList<ItemTradeData> data = new ArrayList<ItemTradeData>();
        ListTag listNBT = compound.m_128437_(key, 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            data.add(ItemTradeData.loadData(listNBT.m_128728_(i), validateRules));
        }
        return data;
    }

    @Override
    public void loadFromNBT(CompoundTag nbt) {
        super.loadFromNBT(nbt);
        if (nbt.m_128425_("Items", 9)) {
            this.items = InventoryUtil.loadAllItems("Items", nbt, 4);
        } else {
            this.items = new SimpleContainer(4);
            if (nbt.m_128425_("SellItem", 10)) {
                this.items.m_6836_(0, ItemStack.m_41712_((CompoundTag)nbt.m_128469_("SellItem")));
            } else {
                this.items.m_6836_(0, ItemStack.m_41712_((CompoundTag)nbt));
            }
            if (nbt.m_128425_("BarterItem", 10)) {
                this.items.m_6836_(2, ItemStack.m_41712_((CompoundTag)nbt.m_128469_("BarterItem")));
            } else {
                this.items.m_6836_(2, ItemStack.f_41583_);
            }
        }
        this.tradeType = nbt.m_128425_("TradeDirection", 8) ? ItemTradeData.loadTradeType(nbt.m_128461_("TradeDirection")) : ItemTradeType.SALE;
        this.customName1 = nbt.m_128441_("CustomName1") ? nbt.m_128461_("CustomName1") : (nbt.m_128441_("CustomName") ? nbt.m_128461_("CustomName") : "");
        this.customName2 = nbt.m_128441_("CustomName2") ? nbt.m_128461_("CustomName2") : "";
        this.resetNBTList();
        if (nbt.m_128441_("IgnoreNBT")) {
            for (int i : nbt.m_128465_("IgnoreNBT")) {
                if (i < 0 || i >= this.enforceNBT.size()) continue;
                this.enforceNBT.set(i, false);
            }
        }
    }

    public static ItemTradeType loadTradeType(String name) {
        ItemTradeType value = ItemTradeType.SALE;
        try {
            value = ItemTradeType.valueOf(name);
        }
        catch (IllegalArgumentException exception) {
            LightmansCurrency.LogError("Could not load '" + name + "' as a TradeDirection.");
        }
        return value;
    }

    public static List<ItemTradeData> listOfSize(int tradeCount, boolean validateRules) {
        ArrayList data = Lists.newArrayList();
        while (data.size() < tradeCount) {
            data.add(new ItemTradeData(validateRules));
        }
        return data;
    }

    @Override
    public TradeComparisonResult compare(TradeData otherTrade) {
        TradeComparisonResult result = new TradeComparisonResult();
        if (otherTrade instanceof ItemTradeData) {
            ItemTradeData otherItemTrade = (ItemTradeData)otherTrade;
            result.setCompatible();
            result.addProductResults(ProductComparisonResult.CompareTwoItems(this.getSellItem(0), this.getSellItem(1), otherItemTrade.getSellItem(0), otherItemTrade.getSellItem(1), this.compareNBT(otherItemTrade, 0)));
            if (this.isBarter()) {
                result.addProductResults(ProductComparisonResult.CompareTwoItems(this.getBarterItem(0), this.getBarterItem(1), otherItemTrade.getBarterItem(0), otherItemTrade.getBarterItem(1), this.compareNBT(otherItemTrade, 2)));
            }
            if (!this.isBarter()) {
                result.comparePrices(this.getCost(), otherTrade.getCost());
            }
            result.setTypeResult(this.tradeType == otherItemTrade.tradeType);
        }
        return result;
    }

    private boolean compareNBT(@Nonnull ItemTradeData otherItemTrade, int startingSlot) {
        for (int i = startingSlot; i < startingSlot + 2; ++i) {
            ItemStack true1 = this.getItem(i);
            ItemStack expected1 = otherItemTrade.getItem(i);
            if (true1.m_41619_() && expected1.m_41619_() || !this.enforceNBT.get(i).booleanValue() && !otherItemTrade.enforceNBT.get(i).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean AcceptableDifferences(TradeComparisonResult result) {
        int i;
        if (!result.TypeMatches() || !result.isCompatible()) {
            return false;
        }
        if (result.getProductResultCount() < 2) {
            return false;
        }
        for (i = 0; i < 2; ++i) {
            ProductComparisonResult sellResult = result.getProductResult(i);
            if (sellResult.SameProductType() && sellResult.SameProductNBT()) {
                if (!(this.isSale() || this.isBarter() ? sellResult.ProductQuantityDifference() < 0 : this.isPurchase() && sellResult.ProductQuantityDifference() > 0)) continue;
                return false;
            }
            return false;
        }
        if (this.isBarter()) {
            if (result.getProductResultCount() < 4) {
                return false;
            }
            for (i = 0; i < 2; ++i) {
                ProductComparisonResult barterResult = result.getProductResult(i + 2);
                if (barterResult.SameProductType() && barterResult.SameProductNBT()) {
                    if (barterResult.ProductQuantityDifference() <= 0) continue;
                    return false;
                }
                return false;
            }
        }
        if (this.isSale() && result.isPriceExpensive()) {
            return false;
        }
        return !this.isPurchase() || !result.isPriceCheaper();
    }

    @Override
    public List<Component> GetDifferenceWarnings(TradeComparisonResult differences) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (!differences.PriceMatches()) {
            if (differences.PriceIncompatible()) {
                list.add((Component)EasyText.translatable("gui.lightmanscurrency.interface.difference.different", new Object[0]).m_130940_(ChatFormatting.RED));
            }
            if (this.isPurchase()) {
                if (differences.isPriceCheaper()) {
                    list.add((Component)EasyText.translatable("gui.lightmanscurrency.interface.difference.purchase.cheaper", differences.priceDifference().getText()).m_130940_(ChatFormatting.RED));
                } else {
                    list.add((Component)EasyText.translatable("gui.lightmanscurrency.interface.difference.purchase.expensive", differences.priceDifference().getText()).m_130940_(ChatFormatting.GOLD));
                }
            } else if (differences.isPriceExpensive()) {
                list.add((Component)EasyText.translatable("gui.lightmanscurrency.interface.difference.expensive", differences.priceDifference().getText()).m_130940_(ChatFormatting.RED));
            } else {
                list.add((Component)EasyText.translatable("gui.lightmanscurrency.interface.difference.cheaper", differences.priceDifference().getText()).m_130940_(ChatFormatting.GOLD));
            }
        }
        for (int i = 0; i < differences.getProductResultCount(); ++i) {
            int slot = this.isPurchase() ? i + 2 : i;
            ChatFormatting moreColor = slot >= 2 ? ChatFormatting.RED : ChatFormatting.GOLD;
            ChatFormatting lessColor = slot >= 2 ? ChatFormatting.GOLD : ChatFormatting.RED;
            MutableComponent slotName = EasyText.translatable("gui.lightmanscurrency.interface.item.difference.product." + slot, new Object[0]);
            ProductComparisonResult productCheck = differences.getProductResult(i);
            if (!productCheck.SameProductType()) {
                list.add((Component)EasyText.translatable("gui.lightmanscurrency.interface.item.difference.itemtype", slotName).m_130940_(ChatFormatting.RED));
                continue;
            }
            if (!productCheck.SameProductNBT()) {
                list.add((Component)EasyText.translatable("gui.lightmanscurrency.interface.item.difference.itemnbt", new Object[0]).m_130940_(ChatFormatting.RED));
                continue;
            }
            if (productCheck.SameProductQuantity()) continue;
            int quantityDifference = productCheck.ProductQuantityDifference();
            if (quantityDifference > 0) {
                list.add((Component)EasyText.translatable("gui.lightmanscurrency.interface.item.difference.quantity.more", slotName, quantityDifference).m_130940_(moreColor));
                continue;
            }
            list.add((Component)EasyText.translatable("gui.lightmanscurrency.interface.item.difference.quantity.less", slotName, -quantityDifference).m_130940_(lessColor));
        }
        return list;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TradeRenderManager<?> getButtonRenderer() {
        return new ItemTradeButtonRenderer(this);
    }

    @Override
    public void OnInputDisplayInteraction(@Nonnull BasicTradeEditTab tab, Consumer<LazyPacketData.Builder> clientHandler, int index, int button, @Nonnull ItemStack heldItem) {
        TraderData traderData = tab.menu.getTrader();
        if (traderData instanceof ItemTraderData) {
            ItemTraderData it = (ItemTraderData)traderData;
            int tradeIndex = it.indexOfTrade(this);
            if (tradeIndex < 0) {
                return;
            }
            if (this.isSale()) {
                tab.sendOpenTabMessage(2, LazyPacketData.builder().setInt("TradeIndex", tradeIndex).setInt("StartingSlot", -1));
            }
            if (this.isPurchase() && index >= 0 && index < 2) {
                ItemStack sellItem = this.getSellItem(index);
                if (sellItem.m_41619_() && heldItem.m_41619_()) {
                    tab.sendOpenTabMessage(2, LazyPacketData.builder().setInt("TradeIndex", tradeIndex).setInt("StartingSlot", index));
                } else if (InventoryUtil.ItemMatches(sellItem, heldItem) && button == 1) {
                    sellItem.m_41764_(Math.min(sellItem.m_41613_() + 1, sellItem.m_41741_()));
                    this.setItem(sellItem, index);
                } else {
                    ItemStack setItem = heldItem.m_41777_();
                    if (button == 1) {
                        setItem.m_41764_(1);
                    }
                    this.setItem(setItem, index);
                }
                if (tab.menu.isClient()) {
                    tab.sendInputInteractionMessage(tradeIndex, index, button, heldItem);
                }
            } else if (this.isBarter() && index >= 0 && index < 2) {
                ItemStack barterItem = this.getBarterItem(index);
                if (barterItem.m_41619_() && heldItem.m_41619_()) {
                    tab.sendOpenTabMessage(2, LazyPacketData.builder().setInt("TradeIndex", tradeIndex).setInt("StartingSlot", index + 2));
                }
                if (InventoryUtil.ItemMatches(barterItem, heldItem) && button == 1) {
                    barterItem.m_41764_(Math.min(barterItem.m_41613_() + 1, barterItem.m_41741_()));
                    this.setItem(barterItem, index + 2);
                } else {
                    ItemStack setItem = heldItem.m_41777_();
                    if (button == 1) {
                        setItem.m_41764_(1);
                    }
                    this.setItem(setItem, index + 2);
                }
                if (tab.menu.isClient()) {
                    tab.sendInputInteractionMessage(tradeIndex, index, button, heldItem);
                }
            }
        }
    }

    public void onSlotInteraction(int index, ItemStack heldItem, int button) {
        ItemStack setItem;
        if (index < 2) {
            ItemStack sellItem = this.getSellItem(index);
            if (sellItem.m_41619_() && heldItem.m_41619_()) {
                return;
            }
            if (InventoryUtil.ItemMatches(sellItem, heldItem) && button == 1) {
                sellItem.m_41764_(Math.min(sellItem.m_41613_() + 1, sellItem.m_41741_()));
                this.setItem(sellItem, index);
            } else {
                setItem = heldItem.m_41777_();
                if (button == 1) {
                    setItem.m_41764_(1);
                }
                this.setItem(setItem, index);
            }
        }
        if (this.isBarter() && index >= 2 && index < 4) {
            ItemStack barterItem = this.getItem(index);
            if (barterItem.m_41619_() && heldItem.m_41619_()) {
                return;
            }
            if (InventoryUtil.ItemMatches(barterItem, heldItem) && button == 1) {
                barterItem.m_41764_(Math.min(barterItem.m_41613_() + 1, barterItem.m_41741_()));
                this.setItem(barterItem, index);
            } else {
                setItem = heldItem.m_41777_();
                if (button == 1) {
                    setItem.m_41764_(1);
                }
                this.setItem(setItem, index);
            }
        }
    }

    @Override
    public void OnOutputDisplayInteraction(@Nonnull BasicTradeEditTab tab, Consumer<LazyPacketData.Builder> clientHandler, int index, int button, @Nonnull ItemStack heldItem) {
        TraderData traderData = tab.menu.getTrader();
        if (traderData instanceof ItemTraderData) {
            ItemTraderData it = (ItemTraderData)traderData;
            int tradeIndex = it.indexOfTrade(this);
            if (tradeIndex < 0) {
                return;
            }
            if ((this.isSale() || this.isBarter()) && index >= 0 && index < 2) {
                ItemStack sellItem = this.getSellItem(index);
                if (sellItem.m_41619_() && heldItem.m_41619_()) {
                    tab.sendOpenTabMessage(2, LazyPacketData.builder().setInt("TradeIndex", tradeIndex).setInt("StartingSlot", index));
                }
                if (InventoryUtil.ItemMatches(sellItem, heldItem) && button == 1) {
                    sellItem.m_41764_(Math.min(sellItem.m_41613_() + 1, sellItem.m_41741_()));
                    this.setItem(sellItem, index);
                } else {
                    ItemStack setItem = heldItem.m_41777_();
                    if (button == 1) {
                        setItem.m_41764_(1);
                    }
                    this.setItem(setItem, index);
                }
                if (tab.menu.isClient()) {
                    tab.sendOutputInteractionMessage(tradeIndex, index, button, heldItem);
                }
            } else if (this.isPurchase()) {
                tab.sendOpenTabMessage(2, LazyPacketData.builder().setInt("TradeIndex", tradeIndex).setInt("StartingSlot", -1));
            }
        }
    }

    @Override
    public void OnInteraction(@Nonnull BasicTradeEditTab tab, Consumer<LazyPacketData.Builder> clientHandler, int mouseX, int mouseY, int button, @Nonnull ItemStack heldItem) {
        TraderData traderData = tab.menu.getTrader();
        if (traderData instanceof ItemTraderData) {
            ItemTraderData it = (ItemTraderData)traderData;
            int tradeIndex = it.indexOfTrade(this);
            if (tradeIndex < 0) {
                return;
            }
            tab.sendOpenTabMessage(2, LazyPacketData.simpleInt("TradeIndex", tradeIndex));
        }
    }

    @Override
    protected void collectRelevantInventorySlots(TradeContext context, List<Slot> slots, List<Integer> results) {
        if (this.isPurchase()) {
            context.hightlightItems(Lists.newArrayList((Object[])new ItemRequirement[]{this.getItemRequirement(0), this.getItemRequirement(1)}), slots, results);
        } else if (this.isBarter()) {
            context.hightlightItems(Lists.newArrayList((Object[])new ItemRequirement[]{this.getItemRequirement(2), this.getItemRequirement(3)}), slots, results);
        }
    }

    @Override
    public boolean isMoneyRelevant() {
        return !this.isBarter();
    }

    public static enum ItemTradeType {
        SALE(0, 1),
        PURCHASE(1, 2),
        BARTER(2, 0);

        public final int index;
        private final int nextIndex;

        public final ItemTradeType next() {
            return ItemTradeType.fromIndex(this.nextIndex);
        }

        private ItemTradeType(int index, int nextIndex) {
            this.index = index;
            this.nextIndex = nextIndex;
        }

        public static ItemTradeType fromIndex(int index) {
            for (ItemTradeType type : ItemTradeType.values()) {
                if (type.index != index) continue;
                return type;
            }
            return SALE;
        }
    }
}

