/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.auction;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public class PersistentAuctionData {
    public final String id;
    public final long duration;
    private final List<ItemStack> items;
    private final MoneyValue startBid;
    private final MoneyValue minBid;

    public final List<ItemStack> getAuctionItems() {
        ArrayList<ItemStack> copy = new ArrayList<ItemStack>();
        for (ItemStack stack : this.items) {
            copy.add(stack.m_41777_());
        }
        return copy;
    }

    public final MoneyValue getStartingBid() {
        return this.startBid;
    }

    public final MoneyValue getMinimumBidDifference() {
        return this.minBid;
    }

    private PersistentAuctionData(String id, long duration, List<ItemStack> items, MoneyValue startBid, MoneyValue minBid) {
        this.id = id;
        this.duration = duration;
        this.items = items;
        this.startBid = startBid;
        this.minBid = minBid;
    }

    public AuctionTradeData createAuction() {
        return new AuctionTradeData(this);
    }

    public static PersistentAuctionData load(JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        MoneyValue startingBid;
        String id = json.has("id") ? GsonHelper.m_13906_((JsonObject)json, (String)"id") : GsonHelper.m_13906_((JsonObject)json, (String)"ID");
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (json.has("Item1")) {
            items.add(FileUtil.parseItemStack(GsonHelper.m_13930_((JsonObject)json, (String)"Item1")));
        }
        if (json.has("Item2")) {
            items.add(FileUtil.parseItemStack(GsonHelper.m_13930_((JsonObject)json, (String)"Item2")));
        }
        if (items.size() == 0) {
            throw new JsonSyntaxException("Auction has no 'Item1' or 'Item2' entry!");
        }
        long duration = Math.max(GsonHelper.m_13828_((JsonObject)json, (String)"Duration", (long)AuctionTradeData.GetDefaultDuration()), AuctionTradeData.GetMinimumDuration());
        if (json.has("StartingBid")) {
            startingBid = MoneyValue.loadFromJson(json.get("StartingBid"));
            if (startingBid.isEmpty() || startingBid.isFree()) {
                throw new JsonSyntaxException("StartingBid cannot be empty and/or free!");
            }
        } else {
            throw new JsonSyntaxException("Missing 'StartingBid' entry!");
        }
        MoneyValue minimumBid = startingBid.getSmallestValue();
        if (json.has("MinimumBid")) {
            minimumBid = MoneyValue.loadFromJson(json.get("MinimumBid"));
        }
        if (!startingBid.getUniqueName().equals(minimumBid.getUniqueName())) {
            throw new JsonSyntaxException("StartingBid and MinimumBid are not compatible money values!");
        }
        return new PersistentAuctionData(id, duration, items, startingBid, minimumBid);
    }
}

