/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.auction;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.events.AuctionHouseEvent;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.IEasyTickable;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TradeResult;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderType;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.permissions.PermissionOption;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.menus.TraderMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.auction.AuctionCreateTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.auction.AuctionStorageTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.auction.AuctionTradeCancelTab;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionPlayerStorage;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.network.message.auction.SPacketStartBid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class AuctionHouseTrader
extends TraderData
implements IEasyTickable {
    public static final TraderType<AuctionHouseTrader> TYPE = new TraderType(new ResourceLocation("lightmanscurrency", "auction_house"), AuctionHouseTrader::new);
    public static final IconData ICON = IconData.of(new ResourceLocation("lightmanscurrency", "textures/gui/icons.png"), 96, 16);
    private final List<AuctionTradeData> trades = new ArrayList<AuctionTradeData>();
    Map<UUID, AuctionPlayerStorage> storage = new HashMap<UUID, AuctionPlayerStorage>();

    public static boolean isEnabled() {
        return (Boolean)LCConfig.SERVER.auctionHouseEnabled.get();
    }

    public static boolean shouldShowOnTerminal() {
        return AuctionHouseTrader.isEnabled() && (Boolean)LCConfig.SERVER.auctionHouseOnTerminal.get() != false;
    }

    @Override
    public boolean showOnTerminal() {
        return AuctionHouseTrader.shouldShowOnTerminal();
    }

    @Override
    public boolean isCreative() {
        return true;
    }

    private AuctionHouseTrader() {
        super(TYPE);
        this.getOwner().SetCustomOwner(EasyText.translatable("gui.lightmanscurrency.universaltrader.auction.owner", new Object[0]));
    }

    @Override
    @Nonnull
    public MutableComponent getName() {
        return EasyText.translatable("gui.lightmanscurrency.universaltrader.auction", new Object[0]);
    }

    @Override
    public int getTradeCount() {
        return this.trades.size();
    }

    @Override
    public AuctionTradeData getTrade(int tradeIndex) {
        try {
            return this.trades.get(tradeIndex);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasPersistentAuction(String id) {
        for (AuctionTradeData trade : this.trades) {
            if (!trade.isPersistentID(id) || !trade.isValid()) continue;
            return true;
        }
        return false;
    }

    public int getTradeIndex(AuctionTradeData trade) {
        return this.trades.indexOf(trade);
    }

    @Override
    public void markTradesDirty() {
        this.markDirty(this::saveTrades);
    }

    public AuctionPlayerStorage getStorage(Player player) {
        return this.getStorage(PlayerReference.of(player));
    }

    public AuctionPlayerStorage getStorage(PlayerReference player) {
        if (player == null) {
            return null;
        }
        if (!this.storage.containsKey(player.id)) {
            this.storage.put(player.id, new AuctionPlayerStorage(player));
            this.markStorageDirty();
        }
        return this.storage.get(player.id);
    }

    public void markStorageDirty() {
        this.markDirty(this::saveStorage);
    }

    @Override
    public void tick() {
        long currentTime = System.currentTimeMillis();
        boolean changed = false;
        boolean canDelete = this.getUserCount() <= 0;
        for (int i = 0; i < this.trades.size(); ++i) {
            AuctionTradeData trade = this.trades.get(i);
            if (trade.hasExpired(currentTime)) {
                trade.ExecuteTrade(this);
                changed = true;
            }
            if (!canDelete || trade.isValid()) continue;
            this.trades.remove(i);
            --i;
        }
        if (changed) {
            this.markDirty(this::saveTrades);
            this.markDirty(this::saveStorage);
        }
    }

    @Override
    public int getPermissionLevel(PlayerReference player, String permission) {
        if (Objects.equals(permission, "openStorage") || Objects.equals(permission, "editTrades")) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getPermissionLevel(Player player, String permission) {
        if (Objects.equals(permission, "openStorage") || Objects.equals(permission, "editTrades")) {
            return 1;
        }
        return 0;
    }

    @Override
    public void saveAdditional(CompoundTag compound) {
        this.saveTrades(compound);
        this.saveStorage(compound);
    }

    @Override
    protected final void saveTrades(CompoundTag compound) {
        ListTag list = new ListTag();
        for (AuctionTradeData trade : this.trades) {
            list.add((Object)trade.getAsNBT());
        }
        compound.m_128365_("Trades", (Tag)list);
    }

    protected final void saveStorage(CompoundTag compound) {
        ListTag list = new ListTag();
        this.storage.forEach((player, storage) -> list.add((Object)storage.save(new CompoundTag())));
        compound.m_128365_("StorageData", (Tag)list);
    }

    @Override
    public void loadAdditional(CompoundTag compound) {
        int i;
        if (compound.m_128441_("Trades")) {
            this.trades.clear();
            ListTag tradeList = compound.m_128437_("Trades", 10);
            for (i = 0; i < tradeList.size(); ++i) {
                this.trades.add(new AuctionTradeData(tradeList.m_128728_(i)));
            }
        }
        if (compound.m_128441_("StorageData")) {
            this.storage.clear();
            ListTag storageList = compound.m_128437_("StorageData", 10);
            for (i = 0; i < storageList.size(); ++i) {
                AuctionPlayerStorage storageEntry = new AuctionPlayerStorage(storageList.m_128728_(i));
                if (storageEntry.getOwner() == null) continue;
                this.storage.put(storageEntry.getOwner().id, storageEntry);
            }
        }
        if (!this.getOwner().hasOwner()) {
            this.getOwner().SetCustomOwner(Component.m_237115_((String)"gui.lightmanscurrency.universaltrader.auction.owner"));
        }
    }

    @Override
    public void addTrade(Player requestor) {
    }

    @Override
    public void removeTrade(Player requestor) {
    }

    public void addTrade(AuctionTradeData trade, boolean persistent) {
        AuctionHouseEvent.AuctionEvent.CreateAuctionEvent.Pre e1 = new AuctionHouseEvent.AuctionEvent.CreateAuctionEvent.Pre(this, trade, persistent);
        if (MinecraftForge.EVENT_BUS.post((Event)e1)) {
            return;
        }
        trade = e1.getAuction();
        trade.startTimer();
        if (trade.isValid()) {
            this.trades.add(trade);
            this.markTradesDirty();
            AuctionHouseEvent.AuctionEvent.CreateAuctionEvent.Post e2 = new AuctionHouseEvent.AuctionEvent.CreateAuctionEvent.Post(this, trade, persistent);
            MinecraftForge.EVENT_BUS.post((Event)e2);
        } else {
            LightmansCurrency.LogError("Auction Trade is not fully valid. Unable to add it to the list.");
        }
    }

    @Override
    public TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        if (!context.hasPlayer()) {
            return TradeResult.FAIL_NOT_SUPPORTED;
        }
        new SPacketStartBid(this.getID(), tradeIndex).sendTo(context.getPlayer());
        return TradeResult.SUCCESS;
    }

    public void makeBid(Player player, TraderMenu menu, int tradeIndex, MoneyValue bidAmount) {
        AuctionTradeData trade = this.getTrade(tradeIndex);
        if (trade == null) {
            return;
        }
        if (trade.hasExpired(System.currentTimeMillis())) {
            return;
        }
        AuctionHouseEvent.AuctionEvent.AuctionBidEvent.Pre e1 = new AuctionHouseEvent.AuctionEvent.AuctionBidEvent.Pre(this, trade, player, bidAmount);
        if (MinecraftForge.EVENT_BUS.post((Event)e1)) {
            return;
        }
        bidAmount = e1.getBidAmount();
        TradeContext tradeContext = menu.getContext(this);
        MoneyView funds = tradeContext.getAvailableFunds();
        if (funds.containsValue(bidAmount) && trade.tryMakeBid(this, player, bidAmount)) {
            tradeContext.getPayment(bidAmount);
            this.markDirty(this::saveTrades);
            this.markDirty(this::saveStorage);
            AuctionHouseEvent.AuctionEvent.AuctionBidEvent.Post e2 = new AuctionHouseEvent.AuctionEvent.AuctionBidEvent.Post(this, trade, player, bidAmount);
            MinecraftForge.EVENT_BUS.post((Event)e2);
        }
    }

    @Override
    @Nonnull
    public List<? extends TradeData> getTradeData() {
        return this.trades == null ? new ArrayList() : this.trades;
    }

    @Override
    public IconData getIcon() {
        return ICON;
    }

    @Override
    public boolean canMakePersistent() {
        return false;
    }

    @Override
    public void saveAdditionalPersistentData(CompoundTag compound) {
    }

    @Override
    public void loadAdditionalPersistentData(CompoundTag data) {
    }

    @Override
    public Function<TradeData, Boolean> getStorageDisplayFilter(@Nonnull ITraderStorageMenu menu) {
        return trade -> {
            AuctionTradeData at;
            return trade instanceof AuctionTradeData && (at = (AuctionTradeData)trade).isOwner(menu.getPlayer()) && at.isValid();
        };
    }

    @Override
    public void initStorageTabs(@Nonnull ITraderStorageMenu menu) {
        menu.setTab(1, new AuctionStorageTab(menu));
        menu.setTab(2, new AuctionTradeCancelTab(menu));
        menu.setTab(3, new AuctionCreateTab(menu));
        menu.clearTab(10);
        menu.clearTab(11);
        menu.clearTab(50);
        menu.clearTab(100);
        menu.clearTab(101);
    }

    @Override
    public boolean shouldRemove(MinecraftServer server) {
        return false;
    }

    @Override
    public void getAdditionalContents(List<ItemStack> contents) {
    }

    @Override
    protected MutableComponent getDefaultName() {
        return this.getName();
    }

    @Override
    public boolean hasValidTrade() {
        return true;
    }

    @Override
    protected void saveAdditionalToJson(JsonObject json) {
    }

    @Override
    protected void loadAdditionalFromJson(JsonObject json) {
    }

    @Override
    protected boolean allowAdditionalUpgradeType(UpgradeType type) {
        return false;
    }

    @Override
    public int getTradeStock(int tradeIndex) {
        return 0;
    }

    @Override
    protected void addPermissionOptions(List<PermissionOption> options) {
    }

    @Override
    protected void modifyDefaultAllyPermissions(Map<String, Integer> defaultValues) {
        defaultValues.clear();
    }

    @Override
    protected void appendTerminalInfo(@Nonnull List<Component> list, @Nullable Player player) {
        int auctionCount = 0;
        for (AuctionTradeData auction : this.trades) {
            if (!auction.isValid() || !auction.isActive()) continue;
            ++auctionCount;
        }
        list.add((Component)EasyText.translatable("tooltip.lightmanscurrency.terminal.info.auction_house", auctionCount));
    }
}

