/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.events.TraderEvent;
import io.github.lightman314.lightmanscurrency.api.misc.IEasyTickable;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.client.data.ClientTraderData;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionSaveData;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.PersistentAuctionData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.data.trader.SPacketClearClientTraders;
import io.github.lightman314.lightmanscurrency.network.message.data.trader.SPacketMessageRemoveClientTrader;
import io.github.lightman314.lightmanscurrency.network.message.data.trader.SPacketUpdateClientTrader;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="lightmanscurrency")
public class TraderSaveData
extends SavedData {
    public static final String PERSISTENT_TRADER_FILENAME = "config/lightmanscurrency/PersistentTraders.json";
    public static final String PERSISTENT_TRADER_SECTION = "Traders";
    public static final String PERSISTENT_AUCTION_SECTION = "Auctions";
    private int cleanTick = 0;
    private long nextID = 0L;
    private final Map<Long, TraderData> traderData = new HashMap<Long, TraderData>();
    private final Map<String, PersistentData> persistentTraderData = new HashMap<String, PersistentData>();
    private final List<PersistentAuctionData> persistentAuctionData = new ArrayList<PersistentAuctionData>();
    private final List<IEasyTickable> tickers = new ArrayList<IEasyTickable>();
    private JsonObject persistentTraderJson = new JsonObject();

    private void validateAuctionHouse() {
        if (!((Boolean)LCConfig.SERVER.auctionHouseEnabled.get()).booleanValue()) {
            LightmansCurrency.LogInfo("Will not create or validate the auction house as the auction house is disabled.");
            return;
        }
        AtomicBoolean hasAuctionHouse = new AtomicBoolean(false);
        this.traderData.forEach((id, data) -> {
            if (data instanceof AuctionHouseTrader) {
                hasAuctionHouse.set(true);
            }
        });
        if (!hasAuctionHouse.get()) {
            AuctionHouseTrader ah = AuctionHouseTrader.TYPE.create();
            ah.setCreative(null, true);
            long traderID = this.getNextID();
            ah.setID(traderID);
            LightmansCurrency.LogInfo("Successfully created an auction house trader with id '" + traderID + "'!");
            this.AddTraderInternal(traderID, ah);
        }
    }

    private long getNextID() {
        long id = this.nextID++;
        this.m_77762_();
        return id;
    }

    public TraderSaveData() {
        this.validateAuctionHouse();
        this.loadPersistentTraders();
    }

    public TraderSaveData(CompoundTag compound) {
        this.nextID = compound.m_128454_("NextID");
        LightmansCurrency.LogInfo("Loaded NextID (" + this.nextID + ") from tag.");
        ListTag traderData = compound.m_128437_("TraderData", 10);
        for (int i = 0; i < traderData.size(); ++i) {
            try {
                CompoundTag traderTag = traderData.m_128728_(i);
                TraderData trader = TraderData.Deserialize(false, traderTag);
                if (trader != null) {
                    this.AddTraderInternal(trader.getID(), trader);
                    continue;
                }
                LightmansCurrency.LogError("Error loading TraderData entry at index " + i);
                continue;
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error loading TraderData", t);
            }
        }
        ListTag persistentData = compound.m_128437_("PersistentData", 10);
        for (int i = 0; i < persistentData.size(); ++i) {
            try {
                CompoundTag c = persistentData.m_128728_(i);
                String name = c.m_128461_("Name");
                long id = c.m_128454_("ID");
                CompoundTag tag = c.m_128469_("Tag");
                this.persistentTraderData.put(name, new PersistentData(id, tag));
                continue;
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error loading Persistent Data", t);
            }
        }
        this.validateAuctionHouse();
        this.loadPersistentTraders();
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128356_("NextID", this.nextID);
        ListTag traderData = new ListTag();
        this.traderData.forEach((id, trader) -> {
            if (trader.isPersistent()) {
                try {
                    this.putPersistentTag(trader.getPersistentID(), trader.savePersistentData());
                }
                catch (Throwable t) {
                    LightmansCurrency.LogError("Error saving persistent trader data:", t);
                }
            } else {
                try {
                    traderData.add((Object)trader.save());
                }
                catch (Throwable t) {
                    LightmansCurrency.LogError("Error saving trader data:", t);
                }
            }
        });
        compound.m_128365_("TraderData", (Tag)traderData);
        ListTag persistentData = new ListTag();
        this.persistentTraderData.forEach((id, data) -> {
            try {
                CompoundTag c = new CompoundTag();
                c.m_128359_("Name", id);
                c.m_128356_("ID", data.id);
                c.m_128365_("Tag", (Tag)data.tag);
                persistentData.add((Object)c);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error saving Persistent Data:", t);
            }
        });
        compound.m_128365_("PersistentData", (Tag)persistentData);
        return compound;
    }

    private long getPersistentID(String traderID) {
        if (this.persistentTraderData.containsKey(traderID)) {
            return this.persistentTraderData.get((Object)traderID).id;
        }
        return -1L;
    }

    private void putPersistentID(String traderID, long id) {
        if (this.persistentTraderData.containsKey(traderID)) {
            this.persistentTraderData.get((Object)traderID).id = id;
        } else {
            this.persistentTraderData.put(traderID, new PersistentData(id, new CompoundTag()));
        }
        this.m_77762_();
    }

    @Deprecated
    public static long CheckOldPersistentID(String traderID) {
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null) {
            long id = tsd.getPersistentID(traderID);
            if (id < 0L) {
                id = tsd.getNextID();
                tsd.putPersistentID(traderID, id);
            }
            return id;
        }
        return -1L;
    }

    private CompoundTag getPersistentTag(String traderID) {
        if (this.persistentTraderData.containsKey(traderID)) {
            return this.persistentTraderData.get((Object)traderID).tag;
        }
        return new CompoundTag();
    }

    private void putPersistentTag(String traderID, CompoundTag tag) {
        if (this.persistentTraderData.containsKey(traderID)) {
            this.persistentTraderData.get((Object)traderID).tag = tag == null ? new CompoundTag() : tag;
        } else {
            this.persistentTraderData.put(traderID, new PersistentData(-1L, tag == null ? new CompoundTag() : tag));
        }
        this.m_77762_();
    }

    @Deprecated
    public static void GiveOldPersistentTag(String traderID, CompoundTag tag) {
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null) {
            tsd.putPersistentTag(traderID, tag);
            for (TraderData pt : tsd.traderData.values().stream().filter(trader -> trader.isPersistent() && trader.getPersistentID().equals(traderID)).toList()) {
                pt.loadPersistentData(tsd.getPersistentTag(traderID));
                TraderSaveData.MarkTraderDirty(pt.save());
            }
        }
    }

    public static JsonObject getPersistentTraderJson() {
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null) {
            return tsd.persistentTraderJson;
        }
        return new JsonObject();
    }

    public static JsonArray getPersistentTraderJson(String section) {
        JsonObject json = TraderSaveData.getPersistentTraderJson();
        if (json != null) {
            if (!json.has(section)) {
                JsonArray newSection = new JsonArray();
                json.add(section, (JsonElement)newSection);
            }
            if (json.get(section).isJsonArray()) {
                return json.get(section).getAsJsonArray();
            }
            LightmansCurrency.LogError("Cannot get Persistent Data section '" + section + "' as it is not a JsonArray.");
        }
        return null;
    }

    public static void setPersistentTraderJson(JsonObject newData) {
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null) {
            File ptf = new File(PERSISTENT_TRADER_FILENAME);
            try {
                tsd.loadPersistentTrader(newData);
            }
            catch (Exception e) {
                LightmansCurrency.LogError("Error loading modified Persistent Trader Data. Ignoring request.", e);
                return;
            }
            tsd.persistentTraderJson = newData;
            tsd.savePersistentTraderJson(ptf);
            tsd.resendTraderData();
        }
    }

    public static void setPersistentTraderSection(String section, JsonArray newData) {
        JsonObject json = TraderSaveData.getPersistentTraderJson();
        json.add(section, (JsonElement)newData);
        TraderSaveData.setPersistentTraderJson(json);
    }

    public static void ReloadPersistentTraders() {
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null) {
            tsd.loadPersistentTraders();
            tsd.resendTraderData();
        }
    }

    private void loadPersistentTraders() {
        File ptf = new File(PERSISTENT_TRADER_FILENAME);
        if (!ptf.exists()) {
            this.persistentTraderJson = TraderSaveData.generateDefaultPersistentTraderJson();
            this.savePersistentTraderJson(ptf);
        }
        try {
            this.persistentTraderJson = GsonHelper.m_13864_((String)Files.readString(ptf.toPath()));
            LightmansCurrency.LogDebug("Loading PersistentTraders.json\n" + FileUtil.GSON.toJson((JsonElement)this.persistentTraderJson));
            this.loadPersistentTrader(this.persistentTraderJson);
        }
        catch (Throwable e) {
            LightmansCurrency.LogError("Error loading Persistent Traders.", e);
            this.persistentTraderJson = TraderSaveData.generateDefaultPersistentTraderJson();
        }
    }

    private static JsonObject generateDefaultPersistentTraderJson() {
        JsonObject fileData = new JsonObject();
        JsonArray traderList = new JsonArray();
        fileData.add(PERSISTENT_TRADER_SECTION, (JsonElement)traderList);
        JsonArray auctions = new JsonArray();
        fileData.add(PERSISTENT_AUCTION_SECTION, (JsonElement)auctions);
        return fileData;
    }

    private void loadPersistentTrader(JsonObject fileData) throws JsonSyntaxException, ResourceLocationException {
        boolean hadNone = true;
        if (fileData.has(PERSISTENT_TRADER_SECTION)) {
            hadNone = false;
            ArrayList removeTraderList = new ArrayList();
            this.traderData.forEach((id, trader) -> {
                if (trader.isPersistent()) {
                    if (trader instanceof IEasyTickable) {
                        IEasyTickable t = (IEasyTickable)((Object)trader);
                        this.tickers.remove(t);
                    }
                    this.putPersistentTag(trader.getPersistentID(), trader.savePersistentData());
                    removeTraderList.add(id);
                }
            });
            Iterator iterator = removeTraderList.iterator();
            while (iterator.hasNext()) {
                long id2 = (Long)iterator.next();
                this.traderData.remove(id2);
            }
            ArrayList<String> loadedIDs = new ArrayList<String>();
            JsonArray traderList = fileData.getAsJsonArray(PERSISTENT_TRADER_SECTION);
            for (int i = 0; i < traderList.size(); ++i) {
                try {
                    JsonObject traderTag = GsonHelper.m_13918_((JsonElement)traderList.get(i), (String)("Traders[" + i + "]"));
                    String traderID = GsonHelper.m_13851_((JsonObject)traderTag, (String)"id", (String)GsonHelper.m_13906_((JsonObject)traderTag, (String)"ID"));
                    if (loadedIDs.contains(traderID)) {
                        throw new JsonSyntaxException("Trader with id '" + traderID + "' already exists. Cannot have duplicate ids.");
                    }
                    if (traderID.isBlank()) {
                        throw new JsonSyntaxException("Trader cannot have a blank id!");
                    }
                    TraderData data = TraderData.Deserialize(traderTag);
                    data.loadPersistentData(this.getPersistentTag(traderID));
                    long id3 = this.getPersistentID(traderID);
                    if (id3 < 0L) {
                        id3 = this.getNextID();
                        this.putPersistentID(traderID, id3);
                        this.m_77762_();
                        LightmansCurrency.LogInfo("Generated new ID for persistent trader '" + traderID + "' (" + id3 + ")");
                    }
                    data.makePersistent(id3, traderID);
                    this.AddTraderInternal(id3, data);
                    loadedIDs.add(traderID);
                    LightmansCurrency.LogInfo("Successfully loaded persistent trader '" + traderID + "' with ID " + id3 + ".");
                    continue;
                }
                catch (JsonSyntaxException | ResourceLocationException e) {
                    LightmansCurrency.LogError("Error loading Persistent Trader at index " + i, e);
                }
            }
        }
        if (fileData.has(PERSISTENT_AUCTION_SECTION)) {
            hadNone = false;
            this.persistentAuctionData.clear();
            ArrayList<String> loadedIDs = new ArrayList<String>();
            JsonArray auctionList = fileData.getAsJsonArray(PERSISTENT_AUCTION_SECTION);
            for (int i = 0; i < auctionList.size(); ++i) {
                try {
                    JsonObject auctionTag = auctionList.get(i).getAsJsonObject();
                    PersistentAuctionData data = PersistentAuctionData.load(auctionTag);
                    if (loadedIDs.contains(data.id)) {
                        throw new JsonSyntaxException("Auction with id '" + data.id + "' already exists. Cannot have duplicate ids.");
                    }
                    loadedIDs.add(data.id);
                    this.persistentAuctionData.add(data);
                    LightmansCurrency.LogInfo("Successfully loaded persistent auction '" + data.id + "'");
                    continue;
                }
                catch (JsonSyntaxException | ResourceLocationException e) {
                    LightmansCurrency.LogError("Error loading Persistent Auction at index " + i, e);
                }
            }
        }
        if (hadNone) {
            throw new JsonSyntaxException("Json Data has no 'Traders' or 'Auctions' entry.");
        }
    }

    private void savePersistentTraderJson(File ptf) {
        File dir = new File(ptf.getParent());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (dir.exists()) {
            try {
                ptf.createNewFile();
                String jsonString = FileUtil.GSON.toJson((JsonElement)this.persistentTraderJson);
                FileUtil.writeStringToFile(ptf, jsonString);
                LightmansCurrency.LogInfo("PersistentTraders.json does not exist. Creating a fresh copy.");
            }
            catch (Throwable e) {
                LightmansCurrency.LogError("Error attempting to create 'persistentTraders.json' file.", e);
            }
        }
    }

    private static TraderSaveData get() {
        ServerLevel level;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && (level = server.m_129880_(Level.f_46428_)) != null) {
            return (TraderSaveData)level.m_8895_().m_164861_(TraderSaveData::new, TraderSaveData::new, "lightmanscurrency_trader_data");
        }
        return null;
    }

    public static void MarkTraderDirty(CompoundTag updateMessage) {
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null) {
            tsd.m_77762_();
            new SPacketUpdateClientTrader(updateMessage).sendToAll();
        }
    }

    @Deprecated
    public static long RegisterOldTrader(TraderData newTrader) {
        TraderSaveData tsd;
        if (newTrader instanceof AuctionHouseTrader && (tsd = TraderSaveData.get()) != null) {
            for (TraderData trader : tsd.traderData.values()) {
                if (!(trader instanceof AuctionHouseTrader)) continue;
                long id = trader.getID();
                tsd.AddTraderInternal(id, newTrader);
                return id;
            }
        }
        return TraderSaveData.RegisterTrader(newTrader, null);
    }

    public static long RegisterTrader(TraderData newTrader, @Nullable Player player) {
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null) {
            long newID = tsd.getNextID();
            tsd.AddTraderInternal(newID, newTrader);
            if (newTrader.shouldAlwaysShowOnTerminal() && player != null) {
                MinecraftForge.EVENT_BUS.post((Event)new TraderEvent.CreateNetworkTraderEvent(newID, player));
            }
            return newID;
        }
        return -1L;
    }

    private void AddTraderInternal(long traderID, TraderData trader) {
        trader.setID(traderID);
        this.traderData.put(traderID, trader.allowMarkingDirty());
        this.m_77762_();
        try {
            trader.OnRegisteredToOffice();
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error handling Trader-OnRegistration function!", t);
        }
        new SPacketUpdateClientTrader(trader.save()).sendToAll();
        if (trader instanceof IEasyTickable) {
            IEasyTickable t = (IEasyTickable)((Object)trader);
            this.tickers.add(t);
        }
    }

    public static void DeleteTrader(long traderID) {
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null && tsd.traderData.containsKey(traderID)) {
            TraderData trader = tsd.traderData.get(traderID);
            TaxSaveData.GetAllTaxEntries(false).forEach(e -> e.TaxableWasRemoved(trader));
            tsd.traderData.remove(traderID);
            if (trader instanceof IEasyTickable) {
                IEasyTickable t = (IEasyTickable)((Object)trader);
                tsd.tickers.remove(t);
            }
            tsd.m_77762_();
            new SPacketMessageRemoveClientTrader(traderID).sendToAll();
            if (trader.shouldAlwaysShowOnTerminal()) {
                MinecraftForge.EVENT_BUS.post((Event)new TraderEvent.RemoveNetworkTraderEvent(traderID, trader));
            }
        }
    }

    public static List<TraderData> GetAllTraders(boolean isClient) {
        if (isClient) {
            return ClientTraderData.GetAllTraders();
        }
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null) {
            return new ArrayList<TraderData>(tsd.traderData.values());
        }
        return new ArrayList<TraderData>();
    }

    public static List<TraderData> GetAllTerminalTraders(boolean isClient) {
        return TraderSaveData.GetAllTraders(isClient).stream().filter(TraderData::showOnTerminal).collect(Collectors.toList());
    }

    public static TraderData GetTrader(boolean isClient, long traderID) {
        if (isClient) {
            return ClientTraderData.GetTrader(traderID);
        }
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null) {
            return tsd.traderData.get(traderID);
        }
        return null;
    }

    public static TraderData GetTrader(boolean isClient, String persistentTraderID) {
        if (isClient) {
            List<TraderData> validTraders = ClientTraderData.GetAllTraders().stream().filter(t -> t.getPersistentID().equals(persistentTraderID)).toList();
            if (!validTraders.isEmpty()) {
                return validTraders.get(0);
            }
        } else {
            TraderSaveData tsd = TraderSaveData.get();
            if (tsd != null) {
                return tsd.traderData.get(tsd.getPersistentID(persistentTraderID));
            }
        }
        return null;
    }

    public static TraderData GetAuctionHouse(boolean isClient) {
        if (isClient) {
            List<TraderData> validTraders = ClientTraderData.GetAllTraders().stream().filter(t -> t instanceof AuctionHouseTrader).toList();
            if (!validTraders.isEmpty()) {
                return validTraders.get(0);
            }
        } else {
            List<TraderData> validTraders;
            TraderSaveData tsd = TraderSaveData.get();
            if (tsd != null && !(validTraders = tsd.traderData.values().stream().filter(t -> t instanceof AuctionHouseTrader).toList()).isEmpty()) {
                return validTraders.get(0);
            }
        }
        return null;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        TraderSaveData tsd;
        if (event.phase != TickEvent.Phase.START || !event.side.isServer()) {
            return;
        }
        MinecraftServer server = event.getServer();
        if (server != null && (tsd = TraderSaveData.get()) != null) {
            if (tsd.cleanTick++ >= 1200 && event.haveTime()) {
                ArrayList<TraderData> remove = new ArrayList<TraderData>();
                for (TraderData traderData : new ArrayList<TraderData>(tsd.traderData.values())) {
                    if (!traderData.shouldRemove(server)) continue;
                    remove.add(traderData);
                }
                for (TraderData traderData : remove) {
                    if (traderData instanceof IEasyTickable) {
                        IEasyTickable t = (IEasyTickable)((Object)traderData);
                        tsd.tickers.remove(t);
                    }
                    tsd.traderData.remove(traderData.getID());
                    try {
                        ServerLevel level = server.m_129880_(traderData.getLevel());
                        BlockPos pos = traderData.getPos();
                        EjectionData e = EjectionData.create((Level)level, pos, null, traderData, false);
                        EjectionSaveData.HandleEjectionData((Level)Objects.requireNonNull(level), pos, e);
                    }
                    catch (NullPointerException e) {
                        LightmansCurrency.LogError("Error deleting missing trader.", e);
                    }
                    new SPacketMessageRemoveClientTrader(traderData.getID()).sendToAll();
                }
            }
            if (server.m_129921_() % 20 == 0 && !tsd.persistentAuctionData.isEmpty()) {
                List<TraderData> traders = tsd.traderData.values().stream().toList();
                AuctionHouseTrader ah = null;
                for (int i = 0; i < traders.size() && ah == null; ++i) {
                    if (!(traders.get(i) instanceof AuctionHouseTrader)) continue;
                    ah = (AuctionHouseTrader)traders.get(i);
                }
                if (ah != null) {
                    for (PersistentAuctionData pad : tsd.persistentAuctionData) {
                        AuctionTradeData trade;
                        if (ah.hasPersistentAuction(pad.id) || (trade = pad.createAuction()) == null) continue;
                        ah.addTrade(trade, true);
                        LightmansCurrency.LogInfo("Successfully added Persistent Auction '" + pad.id + "' into the auction house.");
                    }
                }
            }
            tsd.tickers.forEach(IEasyTickable::tick);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null) {
            PacketDistributor.PacketTarget target = LightmansCurrencyPacketHandler.getTarget(event.getEntity());
            SPacketClearClientTraders.INSTANCE.sendToTarget(target);
            tsd.traderData.forEach((id, trader) -> new SPacketUpdateClientTrader(trader.save()).sendToTarget(target));
        }
    }

    private void resendTraderData() {
        PacketDistributor.PacketTarget target = PacketDistributor.ALL.noArg();
        SPacketClearClientTraders.INSTANCE.sendToTarget(target);
        this.traderData.forEach((id, trader) -> new SPacketUpdateClientTrader(trader.save()).sendToTarget(target));
    }

    private static class PersistentData {
        public long id;
        public CompoundTag tag;

        public PersistentData(long id, CompoundTag tag) {
            this.id = id;
            this.tag = tag == null ? new CompoundTag() : tag;
        }
    }
}

