/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traderinterface;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.common.traderinterface.NetworkTraderReference;
import io.github.lightman314.lightmanscurrency.util.DebugUtil;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class NetworkTradeReference
extends NetworkTraderReference {
    private final Function<CompoundTag, TradeData> tradeDeserializer;
    private int tradeIndex = -1;
    private TradeData tradeData = null;

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public boolean hasTrade() {
        return this.tradeIndex >= 0 && this.tradeData != null;
    }

    public TradeData getLocalTrade() {
        return this.tradeData;
    }

    public void setTrade(int tradeIndex) {
        this.tradeIndex = tradeIndex;
        if (tradeIndex < 0) {
            this.tradeData = null;
            return;
        }
        this.tradeData = this.copyTrade(this.getTrueTrade());
        if (this.tradeData == null) {
            LightmansCurrency.LogWarning("Trade index of '" + this.tradeIndex + "' does not result in a valid trade on the " + DebugUtil.getSideText(this.isClient()) + ". Resetting back to no trade selected.");
            this.tradeIndex = -1;
        }
    }

    public void refreshTrade() {
        if (!this.hasTrade()) {
            return;
        }
        TradeData newTrade = this.copyTrade(this.getTrueTrade());
        if (newTrade != null) {
            this.tradeData = newTrade;
        }
    }

    public TradeData copyTrade(TradeData trade) {
        if (trade == null) {
            return null;
        }
        return this.tradeDeserializer.apply(trade.getAsNBT());
    }

    public NetworkTradeReference(Supplier<Boolean> clientCheck, Function<CompoundTag, TradeData> tradeDeserializer) {
        super(clientCheck);
        this.tradeDeserializer = tradeDeserializer;
    }

    public TradeData getTrueTrade() {
        if (this.tradeIndex < 0) {
            return null;
        }
        TraderData trader = this.getTrader();
        if (trader != null) {
            return trader.getTrade(this.tradeIndex);
        }
        return null;
    }

    @Override
    public CompoundTag save() {
        CompoundTag compound = super.save();
        if (this.tradeData != null && this.tradeIndex >= 0) {
            compound.m_128405_("TradeIndex", this.tradeIndex);
            compound.m_128365_("Trade", (Tag)this.tradeData.getAsNBT());
        }
        return compound;
    }

    @Override
    public void load(CompoundTag compound) {
        super.load(compound);
        if (compound.m_128425_("tradeIndex", 3)) {
            this.tradeIndex = compound.m_128451_("tradeIndex");
        }
        if (compound.m_128425_("TradeIndex", 3)) {
            this.tradeIndex = compound.m_128451_("TradeIndex");
        }
        if (compound.m_128425_("trade", 10)) {
            this.tradeData = this.tradeDeserializer.apply(compound.m_128469_("trade"));
        } else if (compound.m_128425_("Trade", 10)) {
            this.tradeData = this.tradeDeserializer.apply(compound.m_128469_("Trade"));
        }
    }
}

