/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.teams;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.TeamBankReference;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationSaveData;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Range;

public class Team
implements ITeam {
    public static final int MAX_NAME_LENGTH = 32;
    private final long id;
    PlayerReference owner;
    String teamName;
    private boolean isClient = false;
    List<PlayerReference> admins = new ArrayList<PlayerReference>();
    List<PlayerReference> members = new ArrayList<PlayerReference>();
    int bankAccountLimit = 2;
    BankAccount bankAccount = null;

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    @Nonnull
    public PlayerReference getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.teamName;
    }

    public Team flagAsClient() {
        this.isClient = true;
        return this;
    }

    @Override
    @Nonnull
    public List<PlayerReference> getAdmins() {
        return ImmutableList.copyOf(this.admins);
    }

    @Override
    @Nonnull
    public List<PlayerReference> getMembers() {
        return ImmutableList.copyOf(this.members);
    }

    public @Range(from=0L, to=2L) int getBankLimit() {
        return this.bankAccountLimit;
    }

    @Override
    public boolean hasBankAccount() {
        return this.bankAccount != null;
    }

    @Override
    public boolean canAccessBankAccount(@Nonnull Player player) {
        if (this.bankAccountLimit < 1) {
            return this.isMember(player);
        }
        if (this.bankAccountLimit < 2) {
            return this.isAdmin(player);
        }
        return this.isOwner(player);
    }

    @Override
    @Nullable
    public IBankAccount getBankAccount() {
        return this.bankAccount;
    }

    public BankReference getBankReference() {
        if (this.hasBankAccount()) {
            return TeamBankReference.of(this.id).flagAsClient(this.isClient);
        }
        return null;
    }

    @Override
    public boolean isOwner(@Nonnull Player player) {
        return this.owner != null && this.owner.is((Entity)player) || LCAdminMode.isAdminPlayer(player);
    }

    @Override
    public boolean isOwner(@Nonnull UUID playerID) {
        return this.owner != null && this.owner.is(playerID);
    }

    @Override
    public boolean isAdmin(@Nonnull Player player) {
        return PlayerReference.isInList(this.admins, (Entity)player) || this.isOwner(player);
    }

    @Override
    public boolean isAdmin(@Nonnull UUID playerID) {
        return PlayerReference.isInList(this.admins, playerID) || this.isOwner(playerID);
    }

    @Override
    public boolean isMember(@Nonnull Player player) {
        return PlayerReference.isInList(this.members, (Entity)player) || this.isAdmin(player);
    }

    @Override
    public boolean isMember(@Nonnull UUID playerID) {
        return PlayerReference.isInList(this.members, playerID) || this.isAdmin(playerID);
    }

    public void changeAddMember(Player requestor, String name) {
        if (!this.isAdmin(requestor)) {
            return;
        }
        PlayerReference player = PlayerReference.of(false, name);
        if (player == null) {
            return;
        }
        if (this.isMember(player.id)) {
            return;
        }
        this.members.add(player);
        this.markDirty();
    }

    public void changeAddAdmin(Player requestor, String name) {
        if (!this.isAdmin(requestor)) {
            return;
        }
        PlayerReference player = PlayerReference.of(false, name);
        if (player == null) {
            return;
        }
        if (this.isAdmin(player.id)) {
            if (this.isOwner(player.id)) {
                return;
            }
            if (player.is((Entity)requestor) || this.isOwner(requestor)) {
                PlayerReference.removeFromList(this.admins, player);
                this.members.add(player);
                this.markDirty();
            }
        } else if (this.isOwner(requestor)) {
            if (this.isMember(player.id)) {
                PlayerReference.removeFromList(this.members, player);
            }
            this.admins.add(player);
            this.markDirty();
        }
    }

    public void changeRemoveMember(Player requestor, String name) {
        PlayerReference player = PlayerReference.of(false, name);
        if (player == null) {
            return;
        }
        if (!this.isAdmin(requestor) && !player.is((Entity)requestor)) {
            return;
        }
        if (!this.isMember(player.id)) {
            return;
        }
        if (this.isAdmin(player.id) && !this.isOwner(requestor) && !PlayerReference.of(requestor).is(player)) {
            return;
        }
        if (this.isOwner(player.id)) {
            return;
        }
        boolean notFound = true;
        if (this.isAdmin(player.id)) {
            PlayerReference.removeFromList(this.admins, player);
        } else {
            PlayerReference.removeFromList(this.members, player);
        }
        if (notFound) {
            return;
        }
        this.markDirty();
    }

    public void changeOwner(Player requestor, String name) {
        if (!this.isOwner(requestor)) {
            return;
        }
        PlayerReference player = PlayerReference.of(false, name);
        if (player == null) {
            return;
        }
        if (this.owner.is(player)) {
            return;
        }
        this.admins.add(this.owner);
        this.owner = player;
        PlayerReference.removeFromList(this.admins, player);
        PlayerReference.removeFromList(this.members, player);
        this.markDirty();
    }

    public void changeName(Player requestor, String newName) {
        if (this.isAdmin(requestor)) {
            this.teamName = newName;
            if (this.bankAccount != null) {
                this.bankAccount.updateOwnersName(this.teamName);
            }
            this.markDirty();
        }
    }

    public void createBankAccount(Player requestor) {
        if (this.hasBankAccount() || !this.isOwner(requestor)) {
            return;
        }
        this.bankAccount = new BankAccount(this::markDirty);
        this.bankAccount.updateOwnersName(this.teamName);
        this.bankAccount.setNotificationConsumer(this::notificationSender);
        this.markDirty();
    }

    private void notificationSender(NonNullSupplier<Notification> notification) {
        ArrayList<PlayerReference> sendTo = new ArrayList<PlayerReference>();
        if (this.bankAccountLimit < 1) {
            sendTo.addAll(this.members);
        }
        if (this.bankAccountLimit < 2) {
            sendTo.addAll(this.admins);
        }
        sendTo.add(this.owner);
        for (PlayerReference player : sendTo) {
            if (player == null || player.id == null) continue;
            NotificationSaveData.PushNotification(player.id, (Notification)notification.get());
        }
    }

    public void changeBankLimit(Player requestor, int newLimit) {
        if (this.isOwner(requestor) && this.bankAccountLimit != newLimit) {
            this.bankAccountLimit = newLimit;
            this.markDirty();
        }
    }

    public static int NextBankLimit(int currentLimit) {
        int result = currentLimit - 1;
        if (result < 0) {
            result = 2;
        }
        return result;
    }

    public final void HandleEditRequest(@Nonnull ServerPlayer requestor, @Nonnull LazyPacketData request) {
        if (request.contains("Disband") && this.isOwner((Player)requestor)) {
            TeamSaveData.RemoveTeam(this.getID());
        }
        if (request.contains("ChangeOwner", (byte)6)) {
            this.changeOwner((Player)requestor, request.getString("ChangeOwner"));
        }
        if (request.contains("AddMember", (byte)6)) {
            this.changeAddMember((Player)requestor, request.getString("AddMember"));
        }
        if (request.contains("AddAdmin", (byte)6)) {
            this.changeAddAdmin((Player)requestor, request.getString("AddAdmin"));
        }
        if (request.contains("RemoveMember", (byte)6)) {
            this.changeRemoveMember((Player)requestor, request.getString("RemoveMember"));
        }
        if (request.contains("ChangeName", (byte)6)) {
            this.changeName((Player)requestor, request.getString("ChangeName"));
        }
        if (request.contains("CreateBankAccount")) {
            this.createBankAccount((Player)requestor);
        }
        if (request.contains("ChangeBankLimit", (byte)2)) {
            this.changeBankLimit((Player)requestor, request.getInt("ChangeBankLimit"));
        }
    }

    private Team(long teamID, @Nonnull PlayerReference owner, @Nonnull String name) {
        this.id = teamID;
        this.owner = owner;
        this.teamName = name;
    }

    public void markDirty() {
        if (!this.isClient) {
            TeamSaveData.MarkTeamDirty(this.id);
        }
    }

    @Nonnull
    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128356_("ID", this.id);
        if (this.owner != null) {
            compound.m_128365_("Owner", (Tag)this.owner.save());
        }
        compound.m_128359_("Name", this.teamName);
        PlayerReference.saveList(compound, this.members, "Members");
        PlayerReference.saveList(compound, this.admins, "Admins");
        if (this.bankAccount != null) {
            compound.m_128365_("BankAccount", (Tag)this.bankAccount.save());
            compound.m_128405_("BankLimit", this.bankAccountLimit);
        }
        return compound;
    }

    public static Team load(@Nonnull CompoundTag compound) {
        PlayerReference owner = null;
        long id = -1L;
        if (compound.m_128441_("ID")) {
            id = compound.m_128454_("ID");
        }
        if (compound.m_128425_("Owner", 10)) {
            owner = PlayerReference.load(compound.m_128469_("Owner"));
        }
        String name = compound.m_128461_("Name");
        if (owner != null) {
            Team team = Team.of(id, owner, name);
            team.admins = PlayerReference.loadList(compound, "Admins");
            team.members = PlayerReference.loadList(compound, "Members");
            if (compound.m_128425_("BankAccount", 10)) {
                team.bankAccount = new BankAccount(team::markDirty, compound.m_128469_("BankAccount"));
                if (compound.m_128425_("BankLimit", 3)) {
                    team.bankAccountLimit = compound.m_128451_("BankLimit");
                }
                team.bankAccount.updateOwnersName(team.teamName);
                team.bankAccount.setNotificationConsumer(team::notificationSender);
            }
            return team;
        }
        return null;
    }

    public static Team of(long id, @Nonnull PlayerReference owner, @Nonnull String name) {
        return new Team(id, owner, name);
    }

    public static Comparator<ITeam> sorterFor(Player player) {
        return new TeamSorter(player);
    }

    private record TeamSorter(Player player) implements Comparator<ITeam>
    {
        @Override
        public int compare(ITeam o1, ITeam o2) {
            if (o1.isOwner(this.player) && !o2.isOwner(this.player)) {
                return -1;
            }
            if (!o1.isOwner(this.player) && o2.isOwner(this.player)) {
                return 1;
            }
            if (o1.isAdmin(this.player) && !o2.isAdmin(this.player)) {
                return -1;
            }
            if (!o1.isAdmin(this.player) && o2.isAdmin(this.player)) {
                return 1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }
}

