/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.taxes;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.data.ClientTaxData;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.tax.SPacketRemoveTax;
import io.github.lightman314.lightmanscurrency.network.message.tax.SPacketSyncClientTax;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="lightmanscurrency")
public class TaxSaveData
extends SavedData {
    public static final long SERVER_TAX_ID = -9L;
    private long nextID = 0L;
    private final Map<Long, TaxEntry> entries = new HashMap<Long, TaxEntry>();

    private TaxSaveData() {
    }

    private TaxSaveData(CompoundTag compound) {
        this.nextID = compound.m_128454_("NextID");
        ListTag list = compound.m_128437_("TaxEntries", 10);
        for (int i = 0; i < list.size(); ++i) {
            TaxEntry entry = new TaxEntry();
            entry.load(list.m_128728_(i));
            if (entry.getID() < 0L && !entry.isServerEntry()) continue;
            this.entries.put(entry.getID(), entry.unlock());
        }
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag compound) {
        compound.m_128356_("NextID", this.nextID);
        ListTag entryList = new ListTag();
        this.entries.forEach((id, entry) -> {
            CompoundTag entryTag = entry.save();
            if (entryTag != null) {
                entryList.add((Object)entryTag);
            }
        });
        compound.m_128365_("TaxEntries", (Tag)entryList);
        return compound;
    }

    private static TaxSaveData get() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return (TaxSaveData)server.m_129783_().m_8895_().m_164861_(TaxSaveData::new, TaxSaveData::new, "lightmanscurrency_tax_data");
        }
        return null;
    }

    public static List<TaxEntry> GetAllTaxEntries(boolean isClient) {
        if (isClient) {
            return ClientTaxData.GetAllTaxEntries();
        }
        TaxSaveData data = TaxSaveData.get();
        if (data != null) {
            return ImmutableList.copyOf(data.entries.values());
        }
        return ImmutableList.of();
    }

    @Nullable
    public static TaxEntry GetTaxEntry(long id, boolean isClient) {
        if (isClient) {
            return ClientTaxData.GetEntry(id);
        }
        TaxSaveData data = TaxSaveData.get();
        if (data != null) {
            return data.entries.get(id);
        }
        return null;
    }

    @Nullable
    public static TaxEntry GetServerTaxEntry(boolean isClient) {
        if (isClient) {
            return ClientTaxData.GetEntry(-9L);
        }
        TaxSaveData data = TaxSaveData.get();
        if (data != null) {
            TaxEntry entry = data.entries.get(-9L);
            if (entry == null) {
                entry = new TaxEntry(-9L, null, null);
                data.entries.put(-9L, entry);
                TaxSaveData.MarkTaxEntryDirty(-9L, entry.save());
            }
            return entry;
        }
        return null;
    }

    public static void MarkTaxEntryDirty(long id, CompoundTag syncData) {
        if (id < 0L && id != -9L) {
            LightmansCurrency.LogWarning("Attempted to mark a Tax Entry as changed, but is has no defined ID!");
            return;
        }
        TaxSaveData data = TaxSaveData.get();
        if (data != null) {
            data.m_77762_();
            syncData.m_128356_("ID", id);
            new SPacketSyncClientTax(syncData).sendToAll();
        }
    }

    public static long CreateAndRegister(@Nullable BlockEntity spawnBE, @Nullable Player player) {
        TaxSaveData data = TaxSaveData.get();
        if (data != null) {
            long id = data.nextID++;
            TaxEntry entry = new TaxEntry(id, spawnBE, player);
            data.entries.put(id, entry.unlock());
            TaxSaveData.MarkTaxEntryDirty(id, entry.save());
            return id;
        }
        return -1L;
    }

    public static void RemoveEntry(long id) {
        TaxSaveData data = TaxSaveData.get();
        if (data != null && data.entries.containsKey(id)) {
            data.entries.remove(id);
            data.m_77762_();
            new SPacketRemoveTax(id).sendToAll();
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        TaxSaveData data = TaxSaveData.get();
        if (data != null) {
            PacketDistributor.PacketTarget target = LightmansCurrencyPacketHandler.getTarget(event.getEntity());
            data.entries.forEach((id, entry) -> new SPacketSyncClientTax(entry.save()).sendToTarget(target));
        }
    }
}

