/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.trader;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.NonNullSupplier;

public class OutOfStockNotification
extends Notification {
    public static final NotificationType<OutOfStockNotification> TYPE = new NotificationType(new ResourceLocation("lightmanscurrency", "out_of_stock"), OutOfStockNotification::new);
    TraderCategory traderData;
    int tradeSlot;

    private OutOfStockNotification() {
    }

    protected OutOfStockNotification(TraderCategory traderData, int tradeIndex) {
        this.traderData = traderData;
        this.tradeSlot = tradeIndex + 1;
    }

    public static NonNullSupplier<Notification> create(TraderCategory trader, int tradeIndex) {
        return () -> new OutOfStockNotification(trader, tradeIndex);
    }

    @Nonnull
    protected NotificationType<OutOfStockNotification> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return this.traderData;
    }

    @Override
    @Nonnull
    public MutableComponent getMessage() {
        return this.tradeSlot > 0 ? EasyText.translatable("notifications.message.out_of_stock", this.traderData.getTooltip(), this.tradeSlot) : EasyText.translatable("notifications.message.out_of_stock.indexless", new Object[0]);
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound) {
        compound.m_128365_("TraderInfo", (Tag)this.traderData.save());
        compound.m_128405_("TradeSlot", this.tradeSlot);
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound) {
        this.traderData = new TraderCategory(compound.m_128469_("TraderInfo"));
        this.tradeSlot = compound.m_128451_("TradeSlot");
    }

    @Override
    protected boolean canMerge(@Nonnull Notification other) {
        return false;
    }
}

