/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.settings;

import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class ChangeSettingNotification
extends Notification {
    public static final NotificationType<Advanced> ADVANCED_TYPE = new NotificationType(new ResourceLocation("lightmanscurrency", "change_settings_advanced"), ChangeSettingNotification::createAdvanced);
    public static final NotificationType<Simple> SIMPLE_TYPE = new NotificationType(new ResourceLocation("lightmanscurrency", "change_settings_simple"), ChangeSettingNotification::createSimple);
    protected PlayerReference player;
    protected String setting;

    protected ChangeSettingNotification(PlayerReference player, String setting) {
        this.player = player;
        this.setting = setting;
    }

    protected ChangeSettingNotification() {
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return NullCategory.INSTANCE;
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound) {
        compound.m_128365_("Player", (Tag)this.player.save());
        compound.m_128359_("Setting", this.setting);
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound) {
        this.player = PlayerReference.load(compound.m_128469_("Player"));
        this.setting = compound.m_128461_("Setting");
    }

    private static Advanced createAdvanced() {
        return new Advanced();
    }

    private static Simple createSimple() {
        return new Simple();
    }

    public static class Advanced
    extends ChangeSettingNotification {
        String newValue;
        String oldValue;

        private Advanced() {
        }

        public Advanced(PlayerReference player, String setting, String newValue, String oldValue) {
            super(player, setting);
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        @Nonnull
        protected NotificationType<Advanced> getType() {
            return ADVANCED_TYPE;
        }

        @Override
        @Nonnull
        public MutableComponent getMessage() {
            return Component.m_237110_((String)"log.settings.change", (Object[])new Object[]{this.player.getName(true), this.setting, this.oldValue, this.newValue});
        }

        @Override
        protected void saveAdditional(@Nonnull CompoundTag compound) {
            super.saveAdditional(compound);
            compound.m_128359_("NewValue", this.newValue);
            compound.m_128359_("OldValue", this.oldValue);
        }

        @Override
        protected void loadAdditional(@Nonnull CompoundTag compound) {
            super.loadAdditional(compound);
            this.newValue = compound.m_128461_("NewValue");
            this.oldValue = compound.m_128461_("OldValue");
        }

        @Override
        protected boolean canMerge(@Nonnull Notification other) {
            if (other instanceof Advanced) {
                Advanced n = (Advanced)other;
                return n.player.is(this.player) && n.setting.equals(this.setting) && n.newValue.equals(this.newValue) && n.oldValue.equals(this.oldValue);
            }
            return false;
        }
    }

    public static class Simple
    extends ChangeSettingNotification {
        String newValue;

        private Simple() {
        }

        public Simple(PlayerReference player, String setting, String newValue) {
            super(player, setting);
            this.newValue = newValue;
        }

        @Nonnull
        protected NotificationType<Simple> getType() {
            return SIMPLE_TYPE;
        }

        @Override
        @Nonnull
        public MutableComponent getMessage() {
            return Component.m_237110_((String)"log.settings.change.simple", (Object[])new Object[]{this.player.getName(true), this.setting, this.newValue});
        }

        @Override
        protected void saveAdditional(@Nonnull CompoundTag compound) {
            super.saveAdditional(compound);
            compound.m_128359_("NewValue", this.newValue);
        }

        @Override
        protected void loadAdditional(@Nonnull CompoundTag compound) {
            super.loadAdditional(compound);
            this.newValue = compound.m_128461_("NewValue");
        }

        @Override
        protected boolean canMerge(@Nonnull Notification other) {
            if (other instanceof Simple) {
                Simple n = (Simple)other;
                return n.player.is(this.player) && n.setting.equals(this.setting) && n.newValue.equals(this.newValue);
            }
            return false;
        }
    }
}

