/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.settings;

import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class AddRemoveTradeNotification
extends Notification {
    public static final NotificationType<AddRemoveTradeNotification> TYPE = new NotificationType(new ResourceLocation("lightmanscurrency", "add_remove_trade"), AddRemoveTradeNotification::new);
    PlayerReference player;
    boolean isAdd;
    int newCount;

    public AddRemoveTradeNotification() {
    }

    public AddRemoveTradeNotification(PlayerReference player, boolean isAdd, int newCount) {
        this.player = player;
        this.isAdd = isAdd;
        this.newCount = newCount;
    }

    @Nonnull
    protected NotificationType<AddRemoveTradeNotification> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return NullCategory.INSTANCE;
    }

    @Override
    @Nonnull
    public MutableComponent getMessage() {
        return Component.m_237110_((String)"log.settings.addremovetrade", (Object[])new Object[]{this.player.getName(true), Component.m_237115_((String)(this.isAdd ? "log.settings.add" : "log.settings.remove")), this.newCount});
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound) {
        compound.m_128365_("Player", (Tag)this.player.save());
        compound.m_128379_("Add", this.isAdd);
        compound.m_128405_("NewCount", this.newCount);
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound) {
        this.player = PlayerReference.load(compound.m_128469_("Player"));
        this.isAdd = compound.m_128471_("Add");
        this.newCount = compound.m_128451_("NewCount");
    }

    @Override
    protected boolean canMerge(@Nonnull Notification other) {
        if (other instanceof AddRemoveTradeNotification) {
            AddRemoveTradeNotification n = (AddRemoveTradeNotification)other;
            return n.player.is(this.player) && this.isAdd == n.isAdd && this.newCount == n.newCount;
        }
        return false;
    }
}

