/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.ejection;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class OwnableBlockEjectedNotification
extends Notification {
    public static final NotificationType<OwnableBlockEjectedNotification> TYPE = new NotificationType(new ResourceLocation("lightmanscurrency", "block_ejected"), OwnableBlockEjectedNotification::new);
    private Component name = EasyText.empty();
    private boolean ejected = false;
    private boolean anarchy = false;

    private OwnableBlockEjectedNotification() {
    }

    public OwnableBlockEjectedNotification(@Nonnull Component name) {
        this.name = name.m_6881_();
        this.ejected = (Boolean)LCConfig.SERVER.safelyEjectMachineContents.get();
        this.anarchy = (Boolean)LCConfig.SERVER.anarchyMode.get();
    }

    @Nonnull
    public static Notification create(@Nonnull Component name) {
        return new OwnableBlockEjectedNotification(name);
    }

    @Override
    @Nonnull
    protected NotificationType<?> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return NullCategory.INSTANCE;
    }

    @Override
    @Nonnull
    public MutableComponent getMessage() {
        return EasyText.translatable(this.getTranslationKey(), this.name);
    }

    private String getTranslationKey() {
        if (this.anarchy) {
            return "notifications.ejection.block_destroyed.anarchy";
        }
        if (this.ejected) {
            return "notifications.ejection.block_destroyed.ejected";
        }
        return "notifications.ejection.block_destroyed.dropped";
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound) {
        compound.m_128359_("Name", Component.Serializer.m_130703_((Component)this.name));
        if (this.ejected) {
            compound.m_128379_("Ejected", this.ejected);
        }
        if (this.anarchy) {
            compound.m_128379_("Anarchy", this.anarchy);
        }
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound) {
        this.name = Component.Serializer.m_130701_((String)compound.m_128461_("Name"));
        if (compound.m_128441_("Ejected")) {
            this.ejected = compound.m_128471_("Ejected");
        }
        if (compound.m_128441_("Anarchy")) {
            this.anarchy = compound.m_128471_("Anarchy");
        }
    }

    @Override
    protected boolean canMerge(@Nonnull Notification other) {
        return false;
    }
}

