/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.bank;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class DepositWithdrawNotification
extends Notification {
    public static final NotificationType<Player> PLAYER_TYPE = new NotificationType(new ResourceLocation("lightmanscurrency", "bank_deposit_player"), DepositWithdrawNotification::createPlayer);
    public static final NotificationType<Trader> TRADER_TYPE = new NotificationType(new ResourceLocation("lightmanscurrency", "bank_deposit_trader"), DepositWithdrawNotification::createTrader);
    public static final NotificationType<Server> SERVER_TYPE = new NotificationType(new ResourceLocation("lightmanscurrency", "bank_deposit_server"), DepositWithdrawNotification::createServer);
    protected MutableComponent accountName;
    protected boolean isDeposit;
    protected MoneyValue amount = MoneyValue.empty();

    protected DepositWithdrawNotification(MutableComponent accountName, boolean isDeposit, MoneyValue amount) {
        this.accountName = accountName;
        this.isDeposit = isDeposit;
        this.amount = amount;
    }

    protected DepositWithdrawNotification() {
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return new BankCategory(this.accountName);
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound) {
        compound.m_128359_("Name", Component.Serializer.m_130703_((Component)this.accountName));
        compound.m_128379_("Deposit", this.isDeposit);
        compound.m_128365_("Amount", (Tag)this.amount.save());
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound) {
        this.accountName = Component.Serializer.m_130701_((String)compound.m_128461_("Name"));
        this.isDeposit = compound.m_128471_("Deposit");
        this.amount = MoneyValue.safeLoad(compound, "Amount");
    }

    protected abstract MutableComponent getName();

    @Override
    @Nonnull
    public MutableComponent getMessage() {
        return EasyText.translatable("log.bank", this.getName(), Component.m_237115_((String)(this.isDeposit ? "log.bank.deposit" : "log.bank.withdraw")), this.amount.getText());
    }

    private static Player createPlayer() {
        return new Player();
    }

    private static Trader createTrader() {
        return new Trader();
    }

    private static Server createServer() {
        return new Server();
    }

    public static class Player
    extends DepositWithdrawNotification {
        PlayerReference player;

        private Player() {
        }

        public Player(PlayerReference player, MutableComponent accountName, boolean isDeposit, MoneyValue amount) {
            super(accountName, isDeposit, amount);
            this.player = player;
        }

        @Override
        protected MutableComponent getName() {
            return this.player.getNameComponent(true);
        }

        @Nonnull
        protected NotificationType<Player> getType() {
            return PLAYER_TYPE;
        }

        @Override
        protected void saveAdditional(@Nonnull CompoundTag compound) {
            super.saveAdditional(compound);
            compound.m_128365_("Player", (Tag)this.player.save());
        }

        @Override
        protected void loadAdditional(@Nonnull CompoundTag compound) {
            super.loadAdditional(compound);
            this.player = PlayerReference.load(compound.m_128469_("Player"));
        }

        @Override
        protected boolean canMerge(@Nonnull Notification other) {
            if (other instanceof Player) {
                Player n = (Player)other;
                return n.accountName.equals((Object)this.accountName) && n.isDeposit == this.isDeposit && n.amount.equals(this.amount) && n.player.is(this.player);
            }
            return false;
        }
    }

    public static class Trader
    extends DepositWithdrawNotification {
        MutableComponent traderName;

        private Trader() {
        }

        public Trader(MutableComponent traderName, MutableComponent accountName, boolean isDeposit, MoneyValue amount) {
            super(accountName, isDeposit, amount);
            this.traderName = traderName;
        }

        @Override
        protected MutableComponent getName() {
            return this.traderName;
        }

        @Nonnull
        protected NotificationType<Trader> getType() {
            return TRADER_TYPE;
        }

        @Override
        protected void saveAdditional(@Nonnull CompoundTag compound) {
            super.saveAdditional(compound);
            compound.m_128359_("Trader", Component.Serializer.m_130703_((Component)this.traderName));
        }

        @Override
        protected void loadAdditional(@Nonnull CompoundTag compound) {
            super.loadAdditional(compound);
            this.traderName = Component.Serializer.m_130701_((String)compound.m_128461_("Trader"));
        }

        @Override
        protected boolean canMerge(@Nonnull Notification other) {
            if (other instanceof Trader) {
                Trader n = (Trader)other;
                return n.accountName.equals((Object)this.accountName) && n.isDeposit == this.isDeposit && n.amount.equals(this.amount) && n.traderName.equals((Object)this.traderName);
            }
            return false;
        }
    }

    public static class Server
    extends DepositWithdrawNotification {
        private Server() {
        }

        public Server(MutableComponent accountName, boolean isDeposit, MoneyValue amount) {
            super(accountName, isDeposit, amount);
        }

        @Override
        protected MutableComponent getName() {
            return EasyText.translatable("notifications.bank.server", new Object[0]);
        }

        @Nonnull
        protected NotificationType<Server> getType() {
            return SERVER_TYPE;
        }

        @Override
        protected boolean canMerge(@Nonnull Notification other) {
            return false;
        }
    }
}

