/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.bank;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.NonNullSupplier;

public class BankInterestNotification
extends Notification {
    public static final NotificationType<BankInterestNotification> TYPE = new NotificationType(new ResourceLocation("lightmanscurrency", "bank_interest"), BankInterestNotification::new);
    protected MutableComponent accountName;
    protected MoneyValue amount;

    protected BankInterestNotification() {
    }

    protected BankInterestNotification(@Nonnull MutableComponent accountName, @Nonnull MoneyValue amount) {
        this.accountName = accountName;
        this.amount = amount;
    }

    public static NonNullSupplier<Notification> create(@Nonnull MutableComponent accountName, @Nonnull MoneyValue amount) {
        return () -> new BankInterestNotification(accountName, amount);
    }

    @Nonnull
    protected NotificationType<BankInterestNotification> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return new BankCategory(this.accountName);
    }

    @Override
    @Nonnull
    public MutableComponent getMessage() {
        return EasyText.translatable("notifications.bank.interest", this.amount.getText("ERROR"));
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound) {
        compound.m_128359_("Name", Component.Serializer.m_130703_((Component)this.accountName));
        compound.m_128365_("Amount", (Tag)this.amount.save());
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound) {
        this.accountName = Component.Serializer.m_130701_((String)compound.m_128461_("Name"));
        this.amount = MoneyValue.safeLoad(compound, "Amount");
    }

    @Override
    protected boolean canMerge(@Nonnull Notification other) {
        return false;
    }
}

