/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.categories;

import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategoryType;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class TraderCategory
extends NotificationCategory {
    public static final NotificationCategoryType<TraderCategory> TYPE = new NotificationCategoryType(new ResourceLocation("lightmanscurrency", "trader"), TraderCategory::new);
    private final Item trader;
    private final long traderID;
    private final MutableComponent traderName;

    public TraderCategory(ItemLike trader, MutableComponent traderName, long traderID) {
        this.trader = trader.m_5456_();
        this.traderName = traderName;
        this.traderID = traderID;
    }

    public TraderCategory(CompoundTag compound) {
        this.trader = compound.m_128441_("Icon") ? (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.m_128461_("Icon"))) : (Item)ModItems.TRADING_CORE.get();
        this.traderName = compound.m_128441_("TraderName") ? Component.Serializer.m_130701_((String)compound.m_128461_("TraderName")) : Component.m_237115_((String)"gui.lightmanscurrency.universaltrader.default");
        this.traderID = compound.m_128441_("TraderID") ? compound.m_128454_("TraderID") : -1L;
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemLike)this.trader);
    }

    @Override
    @Nonnull
    public MutableComponent getName() {
        return this.traderName;
    }

    @Nonnull
    public NotificationCategoryType<TraderCategory> getType() {
        return TYPE;
    }

    @Override
    public boolean matches(NotificationCategory other) {
        if (other instanceof TraderCategory) {
            TraderCategory otherTrader = (TraderCategory)other;
            if (this.traderID >= 0L && this.traderID == otherTrader.traderID) {
                return true;
            }
            return this.traderName.getString().contentEquals(otherTrader.traderName.getString()) && this.trader.equals(otherTrader.trader);
        }
        return false;
    }

    @Override
    public void saveAdditional(CompoundTag compound) {
        compound.m_128359_("Icon", ForgeRegistries.ITEMS.getKey((Object)this.trader).toString());
        compound.m_128359_("TraderName", Component.Serializer.m_130703_((Component)this.traderName));
        compound.m_128356_("TraderID", this.traderID);
    }
}

