/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.validation.types;

import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidatorType;
import io.github.lightman314.lightmanscurrency.common.util.TagUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BlockEntityValidator
extends MenuValidator {
    public static final MenuValidatorType TYPE = new Type();
    private static final MenuValidator NULL = new BlockEntityValidator((BlockEntity)null);
    private BlockEntity be;
    private BlockPos bePos;

    private void validateBE(@Nonnull Player player) {
        if (this.bePos != null) {
            this.be = player.f_19853_.m_7702_(this.bePos);
            this.bePos = null;
        }
    }

    protected BlockEntityValidator(BlockEntity be) {
        super(TYPE);
        this.be = be;
        this.bePos = null;
    }

    protected BlockEntityValidator(BlockPos pos) {
        super(TYPE);
        this.be = null;
        this.bePos = pos;
    }

    public static MenuValidator of(@Nullable BlockEntity be) {
        return be == null ? NULL : new BlockEntityValidator(be);
    }

    @Override
    protected void encodeAdditional(@Nonnull FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.be != null);
        if (this.be != null) {
            buffer.m_130064_(this.be.m_58899_());
        }
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag tag) {
        if (this.be != null) {
            tag.m_128365_("Position", (Tag)TagUtil.saveBlockPos(this.be.m_58899_()));
        }
    }

    @Override
    public boolean stillValid(@Nonnull Player player) {
        this.validateBE(player);
        return this.be != null && BlockEntityValidator.stillValidBlockEntity(this.be, player);
    }

    private static boolean stillValidBlockEntity(@Nonnull BlockEntity blockEntity, @Nonnull Player player) {
        Level level = blockEntity.m_58904_();
        BlockPos blockpos = blockEntity.m_58899_();
        if (level == null) {
            return false;
        }
        if (level.m_7702_(blockpos) != blockEntity) {
            return false;
        }
        return player.m_20275_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5) <= 64.0;
    }

    private static class Type
    extends MenuValidatorType {
        protected Type() {
            super(new ResourceLocation("lightmanscurrency", "block_entity"));
        }

        @Override
        @Nonnull
        public MenuValidator decode(@Nonnull FriendlyByteBuf buffer) {
            if (buffer.readBoolean()) {
                return new BlockEntityValidator(buffer.m_130135_());
            }
            return NULL;
        }

        @Override
        @Nonnull
        public MenuValidator load(@Nonnull CompoundTag tag) {
            if (tag.m_128441_("Position")) {
                return new BlockEntityValidator(TagUtil.loadBlockPos(tag.m_128469_("Position")));
            }
            return NULL;
        }
    }
}

