/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.IMoneyCollectionMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menus.LazyMessageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TaxInfoTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.logs.TraderLogTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.settings.TraderSettingsTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.trade_rules.TradeRulesTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.menus.validation.IValidatedMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.NotNull;

public class TraderStorageMenu
extends LazyMessageMenu
implements IValidatedMenu,
ITraderStorageMenu,
IMoneyCollectionMenu {
    private final Supplier<TraderData> traderSource;
    public static final int SLOT_OFFSET = 15;
    private final IMoneyHandler coinSlotHandler;
    private final Container coinSlotContainer;
    private boolean coinSlotsVisible = true;
    List<CoinSlot> coinSlots = new ArrayList<CoinSlot>();
    private boolean canEditTabs;
    Map<Integer, TraderStorageTab> availableTabs = new HashMap<Integer, TraderStorageTab>();
    int currentTab = 0;
    private final List<Consumer<LazyPacketData>> listeners = new ArrayList<Consumer<LazyPacketData>>();
    private TradeContext context = null;
    private final MenuValidator validator;

    @Override
    @Nonnull
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public final TraderData getTrader() {
        return this.traderSource.get();
    }

    public boolean areCoinSlotsVisible() {
        return this.coinSlotsVisible;
    }

    public List<CoinSlot> getCoinSlots() {
        return this.coinSlots;
    }

    public Map<Integer, TraderStorageTab> getAllTabs() {
        return this.availableTabs;
    }

    @Override
    public void setTab(int key, @Nonnull TraderStorageTab tab) {
        if (this.canEditTabs && tab != null) {
            this.availableTabs.put(key, tab);
        } else if (tab == null) {
            LightmansCurrency.LogError("Attempted to set a null storage tab in slot " + key);
        } else {
            LightmansCurrency.LogError("Attempted to define the tab in " + key + " but the tabs have been locked.");
        }
    }

    @Override
    public void clearTab(int key) {
        if (this.canEditTabs) {
            if (key == 0) {
                LightmansCurrency.LogError("Attempted to clear the basic trade tab!\nTabs at this index cannot be removed, as there must be one present at all times.\nIf you wish to replace this tab with your own use setTab!");
            } else {
                this.availableTabs.remove(key);
            }
        } else {
            LightmansCurrency.LogError("Attempted to clear the tab in " + key + " but the tabs have been locked.");
        }
    }

    public int getCurrentTabIndex() {
        return this.currentTab;
    }

    public TraderStorageTab getCurrentTab() {
        return this.availableTabs.get(this.currentTab);
    }

    @Override
    @Nonnull
    public TradeContext getContext() {
        TraderData trader = this.traderSource.get();
        if (this.context == null || this.context.getTrader() != trader) {
            if (this.context != null) {
                this.context.clearCache();
            }
            this.context = TradeContext.createStorageMode(trader);
        }
        return this.context;
    }

    @Override
    @Nonnull
    public ItemStack getHeldItem() {
        return this.m_142621_();
    }

    @Override
    public void setHeldItem(@Nonnull ItemStack stack) {
        this.m_142503_(stack);
    }

    @Override
    @Nonnull
    public MenuValidator getValidator() {
        return this.validator;
    }

    public TraderStorageMenu(int windowID, Inventory inventory, long traderID, @Nonnull MenuValidator validator) {
        this((MenuType)ModMenus.TRADER_STORAGE.get(), windowID, inventory, () -> TraderSaveData.GetTrader(inventory.f_35978_.f_19853_.f_46443_, traderID), validator);
    }

    protected TraderStorageMenu(MenuType<?> type, int windowID, Inventory inventory, Supplier<TraderData> traderSource, @Nonnull MenuValidator validator) {
        super(type, windowID, inventory);
        int x;
        this.validator = validator;
        this.traderSource = traderSource;
        this.coinSlotContainer = new SimpleContainer(5);
        this.coinSlotHandler = MoneyAPI.API.GetContainersMoneyHandler(this.coinSlotContainer, inventory.f_35978_);
        this.addValidator((NonNullSupplier<Boolean>)((NonNullSupplier)() -> this.hasPermission("openStorage")));
        this.addValidator(this.validator);
        this.canEditTabs = true;
        TraderData trader = this.traderSource.get();
        this.setTab(0, new BasicTradeEditTab(this));
        this.setTab(10, new TraderLogTab(this));
        this.setTab(11, new TraderSettingsTab(this));
        this.setTab(100, new TradeRulesTab.Trader(this));
        this.setTab(101, new TradeRulesTab.Trade(this));
        this.setTab(50, new TaxInfoTab(this));
        if (trader != null) {
            trader.initStorageTabs(this);
        }
        this.canEditTabs = false;
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.m_38897_(new Slot((Container)inventory, x2 + y * 9 + 9, 23 + x2 * 18, 154 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 23 + x * 18, 212));
        }
        for (x = 0; x < this.coinSlotContainer.m_6643_(); ++x) {
            CoinSlot newSlot = new CoinSlot(this.coinSlotContainer, x, 23 + (x + 4) * 18, 122);
            this.coinSlots.add(newSlot);
            this.m_38897_(newSlot);
        }
        this.availableTabs.forEach((key, tab) -> tab.addStorageMenuSlots(x$0 -> this.m_38897_((Slot)x$0)));
        try {
            this.getCurrentTab().onTabOpen();
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error opening storage tab.", t);
        }
        this.getTrader().userOpen(this.player);
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        this.m_150411_(player, this.coinSlotContainer);
        this.availableTabs.forEach((key, tab) -> tab.onMenuClose());
        TraderData trader = this.getTrader();
        if (trader != null) {
            trader.userClose(player);
        }
        if (this.context != null) {
            this.context.clearCache();
        }
    }

    @Override
    public void clearContainer(@Nonnull Container container) {
        this.m_150411_(this.player, container);
    }

    public void validateCoinSlots() {
        boolean canAddCoins = this.hasCoinSlotAccess();
        for (CoinSlot slot : this.coinSlots) {
            slot.active = canAddCoins && this.coinSlotsVisible;
        }
    }

    private boolean hasCoinSlotAccess() {
        TraderData trader = this.getTrader();
        return trader != null && trader.hasPermission(this.player, "storeCoins") && !trader.hasBankAccount();
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player playerEntity, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < 36 ? !this.getCurrentTab().quickMoveStack(slotStack) && (this.hasCoinSlotAccess() ? !this.m_38903_(slotStack, 36, 36 + this.coinSlots.size(), false) && !this.m_38903_(slotStack, 36 + this.coinSlots.size(), this.f_38839_.size(), false) : !this.m_38903_(slotStack, 36 + this.coinSlots.size(), this.f_38839_.size(), false)) : index < this.f_38839_.size() && !this.m_38903_(slotStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    @Override
    public int getPermissionLevel(@Nonnull String permission) {
        TraderData trader = this.getTrader();
        if (trader != null) {
            return trader.getPermissionLevel(this.player, permission);
        }
        return 0;
    }

    @Override
    public void changeTab(int key) {
        if (this.currentTab == key) {
            return;
        }
        if (this.availableTabs.containsKey(key)) {
            if (this.availableTabs.get(key).canOpen(this.player)) {
                this.getCurrentTab().onTabClose();
                this.currentTab = key;
                this.getCurrentTab().onTabOpen();
            }
        } else {
            LightmansCurrency.LogWarning("Trader Storage Menu doesn't have a tab defined for " + key);
        }
    }

    @Override
    @Nonnull
    public LazyPacketData.Builder createTabChangeMessage(int newTab) {
        return this.createTabChangeMessage(newTab, null);
    }

    @Override
    @Nonnull
    public LazyPacketData.Builder createTabChangeMessage(int newTab, @Nullable LazyPacketData.Builder extraData) {
        LazyPacketData.Builder message = extraData == null ? LazyPacketData.builder() : extraData;
        message.setInt("ChangeTab", newTab);
        return message;
    }

    @Override
    public void SetCoinSlotsActive(boolean nowActive) {
        this.coinSlotsVisible = nowActive;
        SimpleSlot.SetActive(this.coinSlots, nowActive);
        if (this.isClient()) {
            this.SendMessage(this.createCoinSlotActiveMessage(nowActive, null));
        }
    }

    public LazyPacketData.Builder createCoinSlotActiveMessage(boolean nowActive, @Nullable LazyPacketData.Builder extraData) {
        LazyPacketData.Builder message = extraData == null ? LazyPacketData.builder() : extraData;
        message.setBoolean("SetCoinSlotsActive", nowActive);
        return message;
    }

    @Override
    public void HandleMessage(@Nonnull LazyPacketData message) {
        if (message.contains("ChangeTab", (byte)2)) {
            this.changeTab(message.getInt("ChangeTab"));
        }
        if (message.contains("SetCoinSlotsActive", (byte)1)) {
            this.SetCoinSlotsActive(message.getBoolean("SetCoinSlotsActive"));
        }
        try {
            this.getCurrentTab().receiveMessage(message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Consumer<LazyPacketData> listener : this.listeners) {
            try {
                listener.accept(message);
            }
            catch (Throwable throwable) {}
        }
    }

    public void addListener(Consumer<LazyPacketData> listener) {
        if (!this.listeners.contains(listener) && listener != null) {
            this.listeners.add(listener);
        }
    }

    public boolean HasCoinsToAdd() {
        return !this.coinSlotHandler.getStoredMoney().isEmpty();
    }

    @Override
    public void CollectStoredMoney() {
        TraderData trader = this.getTrader();
        if (trader == null) {
            this.player.m_6915_();
            return;
        }
        trader.CollectStoredMoney(this.player);
    }

    public void AddCoins() {
        TraderData trader = this.getTrader();
        if (trader == null) {
            this.player.m_6915_();
            return;
        }
        if (trader.hasPermission(this.player, "storeCoins")) {
            MoneyView addAmount = this.coinSlotHandler.getStoredMoney();
            for (MoneyValue value : addAmount.allValues()) {
                trader.addStoredMoney(value, false);
            }
            this.coinSlotContainer.m_6211_();
        } else {
            Permissions.PermissionWarning(this.player, "store coins", "storeCoins");
        }
    }
}

