/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyStorage;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.IMoneyCollectionMenu;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menus.LazyMessageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.common.menus.validation.IValidatedMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class SlotMachineMenu
extends LazyMessageMenu
implements IValidatedMenu,
IMoneyCollectionMenu {
    private final long traderID;
    private final Container coins;
    List<Slot> coinSlots = new ArrayList<Slot>();
    private final List<RewardCache> rewards = new ArrayList<RewardCache>();
    private final MenuValidator validator;

    @Nullable
    public final SlotMachineTraderData getTrader() {
        TraderData traderData = TraderSaveData.GetTrader(this.isClient(), this.traderID);
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            return trader;
        }
        return null;
    }

    public final boolean hasPendingReward() {
        return !this.rewards.isEmpty();
    }

    public final RewardCache getNextReward() {
        if (this.rewards.isEmpty()) {
            return null;
        }
        return this.rewards.get(0);
    }

    public final RewardCache getAndRemoveNextReward() {
        if (this.rewards.isEmpty()) {
            return null;
        }
        return this.rewards.remove(0);
    }

    @Override
    @Nonnull
    public MenuValidator getValidator() {
        return this.validator;
    }

    public SlotMachineMenu(int windowID, Inventory inventory, long traderID, @Nonnull MenuValidator validator) {
        super((MenuType)ModMenus.SLOT_MACHINE.get(), windowID, inventory);
        int x;
        this.validator = validator;
        this.traderID = traderID;
        this.coins = new SimpleContainer(5);
        this.addValidator(this.validator);
        this.addValidator((NonNullSupplier<Boolean>)((NonNullSupplier)() -> this.getTrader() != null));
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.m_38897_(new Slot((Container)inventory, x2 + y * 9 + 9, 8 + x2 * 18, 140 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 8 + x * 18, 198));
        }
        for (x = 0; x < this.coins.m_6643_(); ++x) {
            this.coinSlots.add(this.m_38897_(new CoinSlot(this.coins, x, 8 + (x + 4) * 18, 108)));
        }
        SlotMachineTraderData trader = this.getTrader();
        if (trader != null) {
            trader.userOpen(this.player);
        }
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player playerEntity, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < 36 ? !this.m_38903_(slotStack, 36, this.f_38839_.size(), false) : index < this.f_38839_.size() && !this.m_38903_(slotStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        for (RewardCache reward : this.rewards) {
            reward.giveToPlayer();
        }
        this.rewards.clear();
        this.m_150411_(player, this.coins);
        SlotMachineTraderData trader = this.getTrader();
        if (trader != null) {
            trader.userClose(this.player);
        }
    }

    public final void clearContainer(Container container) {
        this.m_150411_(this.player, container);
    }

    public final TradeContext getContext() {
        return this.getContext(null);
    }

    public final TradeContext getContext(@Nullable RewardCache rewardHolder) {
        TradeContext.Builder builder = TradeContext.create((TraderData)this.getTrader(), this.player).withCoinSlots(this.coins);
        if (rewardHolder != null) {
            builder.withItemHandler((IItemHandler)new InvWrapper(rewardHolder.itemHolder)).withStoredCoins(rewardHolder.moneyHolder);
        }
        return builder.build();
    }

    @Override
    public void CollectStoredMoney() {
        if (this.getTrader() != null) {
            SlotMachineTraderData trader = this.getTrader();
            trader.CollectStoredMoney(this.player);
        }
    }

    private void ExecuteTrades(int count) {
        if (!this.rewards.isEmpty()) {
            return;
        }
        SlotMachineTraderData trader = this.getTrader();
        if (trader != null) {
            boolean flag = true;
            for (int i = 0; flag && i < count; ++i) {
                RewardCache holder = new RewardCache();
                if (trader.TryExecuteTrade(this.getContext(holder), 0).isSuccess()) {
                    if (holder.itemHolder.m_7983_() && holder.moneyHolder.isEmpty()) {
                        LightmansCurrency.LogError("Successful Slot Machine Trade executed, but no items or money were received!");
                        continue;
                    }
                    this.rewards.add(holder);
                    continue;
                }
                flag = false;
            }
            if (!this.rewards.isEmpty()) {
                CompoundTag rewardData = new CompoundTag();
                ListTag resultList = new ListTag();
                for (RewardCache result : this.rewards) {
                    resultList.add((Object)result.save());
                }
                rewardData.m_128365_("Rewards", (Tag)resultList);
                this.SendMessageToClient(LazyPacketData.builder().setCompound("SyncRewards", rewardData));
            }
        }
    }

    public boolean GiveNextReward() {
        RewardCache nextReward = this.getAndRemoveNextReward();
        if (nextReward != null) {
            nextReward.giveToPlayer();
            return true;
        }
        return false;
    }

    @Override
    public void HandleMessage(@Nonnull LazyPacketData message) {
        if (message.contains("ExecuteTrade")) {
            if (!this.rewards.isEmpty()) {
                return;
            }
            this.ExecuteTrades(message.getInt("ExecuteTrade"));
        }
        if (message.contains("GiveNextReward")) {
            this.GiveNextReward();
        }
        if (message.contains("AnimationsCompleted")) {
            while (this.GiveNextReward()) {
            }
        }
        if (message.contains("SyncRewards") && this.isClient()) {
            this.rewards.clear();
            CompoundTag rewardData = message.getNBT("SyncRewards");
            ListTag rewardList = rewardData.m_128437_("Rewards", 10);
            for (int i = 0; i < rewardList.size(); ++i) {
                this.rewards.add(this.loadReward(rewardList.m_128728_(i)));
            }
        }
    }

    public final RewardCache loadReward(CompoundTag tag) {
        MoneyStorage storage = new MoneyStorage(() -> {});
        storage.load(tag.m_128437_("Money", 10));
        return new RewardCache((Container)InventoryUtil.loadAllItems("Items", tag, 4), storage);
    }

    public final class RewardCache {
        public final Container itemHolder;
        public final MoneyStorage moneyHolder;

        public RewardCache() {
            this.moneyHolder = new MoneyStorage(() -> {});
            this.itemHolder = new SimpleContainer(4);
        }

        public RewardCache(Container itemHolder, MoneyStorage money) {
            this.moneyHolder = new MoneyStorage(() -> {});
            this.itemHolder = itemHolder;
            this.moneyHolder.addValues(money.allValues());
        }

        public void giveToPlayer() {
            SlotMachineMenu.this.clearContainer(this.itemHolder);
            this.itemHolder.m_6211_();
            this.moneyHolder.GiveToPlayer(SlotMachineMenu.this.player);
        }

        public List<ItemStack> getDisplayItems() {
            if (!this.moneyHolder.isEmpty()) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (MoneyValue value : this.moneyHolder.allValues()) {
                    if (!(value instanceof CoinValue)) continue;
                    CoinValue coinValue = (CoinValue)value;
                    items.addAll(coinValue.getAsSeperatedItemList());
                }
                return items;
            }
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i < this.itemHolder.m_6643_(); ++i) {
                ItemStack item = this.itemHolder.m_8020_(i);
                if (item.m_41619_()) continue;
                items.add(item.m_41777_());
            }
            return items;
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            InventoryUtil.saveAllItems("Items", tag, this.itemHolder);
            tag.m_128365_("Money", (Tag)this.moneyHolder.save());
            return tag;
        }
    }
}

