/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menus.containers.SuppliedContainer;
import io.github.lightman314.lightmanscurrency.common.menus.slots.DisplaySlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.playertrading.IPlayerTrade;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PlayerTradeMenu
extends AbstractContainerMenu {
    public final int tradeID;
    private IPlayerTrade trade;
    public final Player player;
    private final Container hostItems;
    private final Container guestItems;

    public final IPlayerTrade getTradeData() {
        return this.trade;
    }

    public boolean isClient() {
        return this.player.f_19853_.f_46443_;
    }

    public boolean isServer() {
        return !this.isClient();
    }

    public final boolean isHost() {
        return this.trade.isHost(this.player);
    }

    public final int myState() {
        return this.isHost() ? this.trade.getHostState() : this.trade.getGuestState();
    }

    public final int otherState() {
        return this.isHost() ? this.trade.getGuestState() : this.trade.getHostState();
    }

    public PlayerTradeMenu(int windowID, Inventory inventory, int tradeID, IPlayerTrade trade) {
        super((MenuType)ModMenus.PLAYER_TRADE.get(), windowID);
        int x;
        int y;
        this.player = inventory.f_35978_;
        this.tradeID = tradeID;
        this.trade = trade;
        this.hostItems = new SuppliedContainer(() -> this.getTradeData().getHostItems());
        this.guestItems = new SuppliedContainer(() -> this.getTradeData().getGuestItems());
        Container leftSideContainer = this.isHost() ? this.hostItems : this.guestItems;
        Container rightSideContainer = this.isHost() ? this.guestItems : this.hostItems;
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 3; ++x) {
                this.m_38897_(new SimpleSlot(leftSideContainer, x + y * 3, 8 + x * 18, 99 + y * 18));
            }
        }
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 3; ++x) {
                this.m_38897_(new DisplaySlot(rightSideContainer, x + y * 3, 116 + x * 18, 99 + y * 18));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 209 + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.m_38897_(new Slot((Container)inventory, x2, 8 + x2 * 18, 267));
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < 12 ? !this.m_38903_(slotStack, 24, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, 12, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public boolean m_6875_(@NotNull Player player) {
        return true;
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        if (this.isClient() || this.trade.isCompleted()) {
            return;
        }
        LightmansCurrency.LogWarning("Player Trade Menu was closed by the " + (this.isHost() ? "host" : "guest") + ", but the trade was not completed!");
        this.m_150411_(player, this.trade.isHost(this.player) ? this.trade.getHostItems() : this.trade.getGuestItems());
    }

    public MoneyView getAvailableFunds() {
        return WalletCapability.getWalletMoney((Entity)this.player);
    }

    public void onTradeChange() {
    }

    public final void reloadTrade(IPlayerTrade trade) {
        if (this.isClient()) {
            this.trade = trade;
            this.onTradeChange();
        } else {
            LightmansCurrency.LogWarning("Attempted to reload the trade on the server-side menu.");
        }
    }
}

